/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.wire.FieldEncoding;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.ProtoReader;
import com.squareup.wire.ProtoWriter;
import com.squareup.wire.WireEnum;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

final class RuntimeEnumAdapter<E extends WireEnum>
extends ProtoAdapter<E> {
    private final Class<E> type;
    private Method fromValueMethod;

    RuntimeEnumAdapter(Class<E> type) {
        super(FieldEncoding.VARINT, type);
        this.type = type;
    }

    private Method getFromValueMethod() {
        Method method = this.fromValueMethod;
        if (method != null) {
            return method;
        }
        try {
            this.fromValueMethod = this.type.getMethod("fromValue", Integer.TYPE);
            return this.fromValueMethod;
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public int encodedSize(E value) {
        return ProtoWriter.varint32Size(value.getValue());
    }

    @Override
    public void encode(ProtoWriter writer, E value) throws IOException {
        writer.writeVarint32(value.getValue());
    }

    @Override
    public E decode(ProtoReader reader) throws IOException {
        WireEnum constant;
        int value = reader.readVarint32();
        try {
            constant = (WireEnum)this.getFromValueMethod().invoke(null, value);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
        if (constant == null) {
            throw new ProtoAdapter.EnumConstantNotFoundException(value, this.type);
        }
        return (E)constant;
    }

    public boolean equals(Object o) {
        return o instanceof RuntimeEnumAdapter && ((RuntimeEnumAdapter)o).type == this.type;
    }

    public int hashCode() {
        return this.type.hashCode();
    }
}

