/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.squareup.wire.schema.EnumConstant;
import com.squareup.wire.schema.EnumType;
import com.squareup.wire.schema.Extend;
import com.squareup.wire.schema.Extensions;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.MessageType;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.Reserved;
import com.squareup.wire.schema.Rpc;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.SchemaException;
import com.squareup.wire.schema.Service;
import com.squareup.wire.schema.Type;
import com.squareup.wire.schema.internal.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class Linker {
    private final ImmutableList<ProtoFile> protoFiles;
    private final Map<String, Type> protoTypeNames;
    private final Multimap<String, String> imports;
    private final List<String> errors;
    private final List<Object> contextStack;

    public Linker(Iterable<ProtoFile> protoFiles) {
        this.protoFiles = ImmutableList.copyOf(protoFiles);
        this.protoTypeNames = new LinkedHashMap<String, Type>();
        this.imports = LinkedHashMultimap.create();
        this.contextStack = Collections.emptyList();
        this.errors = new ArrayList<String>();
    }

    private Linker(Linker enclosing, Object additionalContext) {
        this.protoFiles = enclosing.protoFiles;
        this.protoTypeNames = enclosing.protoTypeNames;
        this.imports = enclosing.imports;
        this.contextStack = Util.concatenate(enclosing.contextStack, additionalContext);
        this.errors = enclosing.errors;
    }

    public Schema link() {
        Linker linker;
        for (ProtoFile protoFile : this.protoFiles) {
            for (Type type : protoFile.types()) {
                this.register(type);
            }
        }
        for (ProtoFile protoFile : this.protoFiles) {
            linker = this.withContext(protoFile);
            for (Extend extend : protoFile.extendList()) {
                extend.link(linker);
            }
        }
        for (ProtoFile protoFile : this.protoFiles) {
            linker = this.withContext(protoFile);
            for (Type type : protoFile.types()) {
                type.link(linker);
            }
            for (Service service : protoFile.services()) {
                service.link(linker);
            }
        }
        for (ProtoFile protoFile : this.protoFiles) {
            linker = this.withContext(protoFile);
            protoFile.linkOptions(linker);
            for (Type type : protoFile.types()) {
                type.linkOptions(linker);
            }
            for (Service service : protoFile.services()) {
                service.linkOptions(linker);
            }
        }
        LinkedHashMultimap<String, String> publicImports = LinkedHashMultimap.create();
        for (ProtoFile protoFile : this.protoFiles) {
            publicImports.putAll(protoFile.location().getPath(), protoFile.publicImports());
        }
        for (ProtoFile protoFile : this.protoFiles) {
            Collection<String> collection = this.imports.get(protoFile.location().getPath());
            this.addImports(collection, protoFile.imports(), publicImports);
            this.addImports(collection, protoFile.publicImports(), publicImports);
        }
        for (ProtoFile protoFile : this.protoFiles) {
            Linker linker2 = this.withContext(protoFile);
            protoFile.validate(linker2);
            for (Type type : protoFile.types()) {
                type.validate(linker2);
            }
            for (Service service : protoFile.services()) {
                service.validate(linker2);
            }
            for (Extend extend : protoFile.extendList()) {
                extend.validate(linker2);
            }
        }
        if (!this.errors.isEmpty()) {
            throw new SchemaException(this.errors);
        }
        return new Schema(this.protoFiles);
    }

    private void addImports(Collection<String> sink2, Collection<String> paths, Multimap<String, String> publicImports) {
        for (String path : paths) {
            if (!sink2.add(path)) continue;
            this.addImports(sink2, publicImports.get(path), publicImports);
        }
    }

    private void register(Type type) {
        this.protoTypeNames.put(type.type().toString(), type);
        for (Type nestedType : type.nestedTypes()) {
            this.register(nestedType);
        }
    }

    ProtoType resolveType(String name) {
        return this.resolveType(name, false);
    }

    ProtoType resolveMessageType(String name) {
        return this.resolveType(name, true);
    }

    private ProtoType resolveType(String name, boolean messageOnly) {
        ProtoType type = ProtoType.get(name);
        if (type.isScalar()) {
            if (messageOnly) {
                this.addError("expected a message but was %s", name);
            }
            return type;
        }
        if (type.isMap()) {
            if (messageOnly) {
                this.addError("expected a message but was %s", name);
            }
            ProtoType keyType = this.resolveType(type.keyType().toString(), false);
            ProtoType valueType = this.resolveType(type.valueType().toString(), false);
            return new ProtoType(keyType, valueType, name);
        }
        Type resolved = this.resolve(name, this.protoTypeNames);
        if (resolved == null) {
            this.addError("unable to resolve %s", name);
            return ProtoType.BYTES;
        }
        if (messageOnly && !(resolved instanceof MessageType)) {
            this.addError("expected a message but was %s", name);
            return ProtoType.BYTES;
        }
        return resolved.type();
    }

    <T> T resolve(String name, Map<String, T> map) {
        if (name.startsWith(".")) {
            T result = map.get(name.substring(1));
            if (result != null) {
                return result;
            }
        } else {
            T result;
            String prefix = this.resolveContext();
            while (!prefix.isEmpty()) {
                result = map.get(prefix + '.' + name);
                if (result != null) {
                    return result;
                }
                int dot = prefix.lastIndexOf(46);
                prefix = dot != -1 ? prefix.substring(0, dot) : "";
            }
            result = map.get(name);
            if (result != null) {
                return result;
            }
        }
        return null;
    }

    private String resolveContext() {
        for (int i = this.contextStack.size() - 1; i >= 0; --i) {
            Object context = this.contextStack.get(i);
            if (context instanceof Type) {
                return ((Type)context).type().toString();
            }
            if (context instanceof ProtoFile) {
                String packageName = ((ProtoFile)context).packageName();
                return packageName != null ? packageName : "";
            }
            if (!(context instanceof Field) || !((Field)context).isExtension()) continue;
            String packageName = ((Field)context).packageName();
            return packageName != null ? packageName : "";
        }
        throw new IllegalStateException();
    }

    String packageName() {
        for (Object context : this.contextStack) {
            if (!(context instanceof ProtoFile)) continue;
            return ((ProtoFile)context).packageName();
        }
        return null;
    }

    public Type get(ProtoType protoType) {
        return this.protoTypeNames.get(protoType.toString());
    }

    Field dereference(Field self, String field) {
        Type type;
        if (field.startsWith("[") && field.endsWith("]")) {
            field = field.substring(1, field.length() - 1);
        }
        if ((type = this.protoTypeNames.get(self.type().toString())) instanceof MessageType) {
            MessageType messageType = (MessageType)type;
            Field messageField = messageType.field(field);
            if (messageField != null) {
                return messageField;
            }
            Map<String, Field> typeExtensions = messageType.extensionFieldsMap();
            Field extensionField = this.resolve(field, typeExtensions);
            if (extensionField != null) {
                return extensionField;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    void validateFields(Iterable<Field> fields, List<Reserved> reserveds) {
        LinkedHashMultimap<Integer, Field> tagToField = LinkedHashMultimap.create();
        LinkedHashMultimap<String, Field> nameToField = LinkedHashMultimap.create();
        for (Field field : fields) {
            int tag = field.tag();
            if (!Util.isValidTag(tag)) {
                this.withContext(field).addError("tag is out of range: %s", tag);
            }
            for (Reserved reserved : reserveds) {
                if (reserved.matchesTag(tag)) {
                    this.withContext(field).addError("tag %s is reserved (%s)", tag, reserved.getLocation());
                }
                if (!reserved.matchesName(field.name())) continue;
                this.withContext(field).addError("name '%s' is reserved (%s)", field.name(), reserved.getLocation());
            }
            tagToField.put(tag, field);
            nameToField.put(field.qualifiedName(), field);
        }
        for (Map.Entry entry : tagToField.asMap().entrySet()) {
            if (((Collection)entry.getValue()).size() <= 1) continue;
            StringBuilder error = new StringBuilder();
            error.append(String.format("multiple fields share tag %s:", entry.getKey()));
            int index = 1;
            for (Field field : (Collection)entry.getValue()) {
                error.append(String.format("\n  %s. %s (%s)", index++, field.name(), field.location()));
            }
            this.addError("%s", error);
        }
        for (Collection collection : nameToField.asMap().values()) {
            if (collection.size() <= 1) continue;
            Field first = (Field)collection.iterator().next();
            StringBuilder error = new StringBuilder();
            error.append(String.format("multiple fields share name %s:", first.name()));
            boolean bl = true;
            for (Field field : collection) {
                void var9_21;
                error.append(String.format("\n  %s. %s (%s)", (int)(++var9_21), field.name(), field.location()));
            }
            this.addError("%s", error);
        }
    }

    void validateEnumConstantNameUniqueness(Iterable<Type> nestedTypes) {
        LinkedHashMultimap<String, EnumType> nameToType = LinkedHashMultimap.create();
        for (Type type : nestedTypes) {
            if (!(type instanceof EnumType)) continue;
            EnumType enumType = (EnumType)type;
            for (EnumConstant enumConstant : enumType.constants()) {
                nameToType.put(enumConstant.getName(), enumType);
            }
        }
        for (Map.Entry entry : nameToType.asMap().entrySet()) {
            if (((Collection)entry.getValue()).size() <= 1) continue;
            StringBuilder error = new StringBuilder();
            String constant = (String)entry.getKey();
            int index = 1;
            error.append(String.format("multiple enums share constant %s:", constant));
            for (EnumType enumType : (Collection)entry.getValue()) {
                error.append(String.format("\n  %s. %s.%s (%s)", index++, enumType.type(), constant, enumType.constant(constant).getLocation()));
            }
            this.addError("%s", error);
        }
    }

    void validateImport(Location location, ProtoType type) {
        String requiredImport;
        if (type.isMap()) {
            type = type.valueType();
        }
        if (type.isScalar()) {
            return;
        }
        String path = location.getPath();
        if (!path.equals(requiredImport = this.get(type).location().getPath()) && !this.imports.containsEntry(path, requiredImport)) {
            this.addError("%s needs to import %s", path, requiredImport);
        }
    }

    Linker withContext(Object context) {
        return new Linker(this, context);
    }

    void addError(String format, Object ... args) {
        StringBuilder error = new StringBuilder();
        error.append(String.format(format, args));
        for (int i = this.contextStack.size() - 1; i >= 0; --i) {
            String prefix;
            Object context = this.contextStack.get(i);
            String string = prefix = i == this.contextStack.size() - 1 ? "\n  for" : "\n  in";
            if (context instanceof Rpc) {
                Rpc rpc = (Rpc)context;
                error.append(String.format("%s rpc %s (%s)", prefix, rpc.name(), rpc.location()));
                continue;
            }
            if (context instanceof Extend) {
                Extend extend = (Extend)context;
                ProtoType type = extend.type();
                error.append(type != null ? String.format("%s extend %s (%s)", prefix, type, extend.location()) : String.format("%s extend (%s)", prefix, extend.location()));
                continue;
            }
            if (context instanceof Field) {
                Field field = (Field)context;
                error.append(String.format("%s field %s (%s)", prefix, field.name(), field.location()));
                continue;
            }
            if (context instanceof MessageType) {
                MessageType message = (MessageType)context;
                error.append(String.format("%s message %s (%s)", prefix, message.type(), message.location()));
                continue;
            }
            if (context instanceof EnumType) {
                EnumType enumType = (EnumType)context;
                error.append(String.format("%s enum %s (%s)", prefix, enumType.type(), enumType.location()));
                continue;
            }
            if (context instanceof Service) {
                Service service = (Service)context;
                error.append(String.format("%s service %s (%s)", prefix, service.type(), service.location()));
                continue;
            }
            if (!(context instanceof Extensions)) continue;
            Extensions extensions = (Extensions)context;
            error.append(String.format("%s extensions (%s)", prefix, extensions.getLocation()));
        }
        this.errors.add(error.toString());
    }
}

