/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.google.common.collect.ImmutableList;
import com.squareup.wire.schema.EnclosingType;
import com.squareup.wire.schema.EnumType;
import com.squareup.wire.schema.Linker;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.MarkSet;
import com.squareup.wire.schema.MessageType;
import com.squareup.wire.schema.Options;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.internal.parser.EnumElement;
import com.squareup.wire.schema.internal.parser.MessageElement;
import com.squareup.wire.schema.internal.parser.TypeElement;
import java.util.List;

public abstract class Type {
    public abstract Location location();

    public abstract ProtoType type();

    public abstract String documentation();

    public abstract Options options();

    public abstract List<Type> nestedTypes();

    abstract void link(Linker var1);

    abstract void linkOptions(Linker var1);

    abstract void validate(Linker var1);

    abstract Type retainAll(Schema var1, MarkSet var2);

    public static Type get(String packageName, ProtoType protoType, TypeElement type) {
        if (type instanceof EnumElement) {
            return EnumType.fromElement(protoType, (EnumElement)type);
        }
        if (type instanceof MessageElement) {
            return MessageType.fromElement(packageName, protoType, (MessageElement)type);
        }
        throw new IllegalArgumentException("unexpected type: " + type.getClass());
    }

    static ImmutableList<Type> fromElements(String packageName, List<TypeElement> elements) {
        ImmutableList.Builder types = new ImmutableList.Builder();
        for (TypeElement element : elements) {
            ProtoType protoType = ProtoType.get(packageName, element.getName());
            types.add(Type.get(packageName, protoType, element));
        }
        return types.build();
    }

    static TypeElement toElement(Type type) {
        if (type instanceof EnumType) {
            return ((EnumType)type).toElement();
        }
        if (type instanceof MessageType) {
            return ((MessageType)type).toElement();
        }
        if (type instanceof EnclosingType) {
            return ((EnclosingType)type).toElement();
        }
        throw new IllegalArgumentException("unexpected type: " + type.getClass());
    }

    static ImmutableList<TypeElement> toElements(List<Type> types) {
        ImmutableList.Builder elements = new ImmutableList.Builder();
        for (Type type : types) {
            elements.add(Type.toElement(type));
        }
        return elements.build();
    }
}

