/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema.internal.parser;

import com.squareup.wire.schema.internal.parser.OptionElement;
import com.squareup.wire.schema.internal.parser.SyntaxReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0001H\u0002J\b\u0010\f\u001a\u00020\rH\u0002J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00010\u000fH\u0002J,\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00010\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014H\u0002J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u0014J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u000fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001b"}, d2={"Lcom/squareup/wire/schema/internal/parser/OptionReader;", "", "reader", "Lcom/squareup/wire/schema/internal/parser/SyntaxReader;", "(Lcom/squareup/wire/schema/internal/parser/SyntaxReader;)V", "getReader$schema2proto_wire", "()Lcom/squareup/wire/schema/internal/parser/SyntaxReader;", "addToList", "", "list", "", "value", "readKindAndValue", "Lcom/squareup/wire/schema/internal/parser/OptionReader$KindAndValue;", "readList", "", "readMap", "", "", "openBrace", "", "closeBrace", "keyValueSeparator", "readOption", "Lcom/squareup/wire/schema/internal/parser/OptionElement;", "readOptions", "KindAndValue", "schema2proto-wire"})
public final class OptionReader {
    @NotNull
    private final SyntaxReader reader;

    @NotNull
    public final List<OptionElement> readOptions() {
        List result;
        block2: {
            if (!this.reader.peekChar('[')) {
                return CollectionsKt.emptyList();
            }
            boolean bl = false;
            result = new ArrayList();
            do {
                Collection collection = result;
                OptionElement optionElement = this.readOption('=');
                boolean bl2 = false;
                collection.add(optionElement);
                if (this.reader.peekChar(']')) break block2;
            } while (this.reader.peekChar(','));
            RuntimeException runtimeException = this.reader.unexpected("Expected ',' or ']");
            Intrinsics.checkExpressionValueIsNotNull(runtimeException, "reader.unexpected(\"Expected ',' or ']\")");
            throw (Throwable)runtimeException;
        }
        return result;
    }

    @NotNull
    public final OptionElement readOption(char keyValueSeparator) {
        boolean isExtension = this.reader.peekChar() == '[';
        boolean isParenthesized = this.reader.peekChar() == '(';
        String name = this.reader.readName();
        if (isExtension) {
            name = '[' + name + ']';
        }
        String subName = null;
        char c = this.reader.readChar();
        if (c == '.') {
            subName = this.reader.readName();
            c = this.reader.readChar();
        }
        if (keyValueSeparator == ':' && c == '{') {
            this.reader.pushBack('{');
        } else if (c != keyValueSeparator) {
            RuntimeException runtimeException = this.reader.unexpected("expected '" + keyValueSeparator + "' in option");
            Intrinsics.checkExpressionValueIsNotNull(runtimeException, "reader.unexpected(\"expec\u2026lueSeparator' in option\")");
            throw (Throwable)runtimeException;
        }
        KindAndValue kindAndValue = this.readKindAndValue();
        OptionElement.Kind kind = kindAndValue.getKind$schema2proto_wire();
        Object value = kindAndValue.getValue$schema2proto_wire();
        if (subName != null) {
            value = OptionElement.Companion.create$default(OptionElement.Companion, subName, kind, value, false, 8, null);
            kind = OptionElement.Kind.OPTION;
        }
        String string = name;
        Intrinsics.checkExpressionValueIsNotNull(string, "name");
        return OptionElement.Companion.create(string, kind, value, isParenthesized);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final KindAndValue readKindAndValue() {
        KindAndValue kindAndValue;
        String word;
        char peeked = this.reader.peekChar();
        switch (peeked) {
            case '{': {
                return new KindAndValue(OptionElement.Kind.MAP, this.readMap('{', '}', ':'));
            }
            case '[': {
                return new KindAndValue(OptionElement.Kind.LIST, this.readList());
            }
            case '\"': 
            case '\'': {
                String string = this.reader.readString();
                Intrinsics.checkExpressionValueIsNotNull(string, "reader.readString()");
                return new KindAndValue(OptionElement.Kind.STRING, string);
            }
        }
        if (Character.isDigit(peeked) || peeked == '-') {
            String string = this.reader.readWord();
            Intrinsics.checkExpressionValueIsNotNull(string, "reader.readWord()");
            return new KindAndValue(OptionElement.Kind.NUMBER, string);
        }
        String string = word = this.reader.readWord();
        if (string != null) {
            switch (string) {
                case "true": {
                    kindAndValue = new KindAndValue(OptionElement.Kind.BOOLEAN, "true");
                    return kindAndValue;
                }
                case "false": {
                    kindAndValue = new KindAndValue(OptionElement.Kind.BOOLEAN, "false");
                    return kindAndValue;
                }
            }
        }
        String string2 = word;
        Intrinsics.checkExpressionValueIsNotNull(string2, "word");
        kindAndValue = new KindAndValue(OptionElement.Kind.ENUM, string2);
        return kindAndValue;
    }

    private final Map<String, Object> readMap(char openBrace, char closeBrace, char keyValueSeparator) {
        if (this.reader.readChar() != openBrace) {
            throw (Throwable)((Object)new AssertionError());
        }
        boolean bl = false;
        Map result = new LinkedHashMap();
        while (!this.reader.peekChar(closeBrace)) {
            OptionElement option = this.readOption(keyValueSeparator);
            String name = option.getName();
            Object value = option.getValue();
            if (value instanceof OptionElement) {
                Map nested;
                Object v = result.get(name);
                if (!TypeIntrinsics.isMutableMap(v)) {
                    v = null;
                }
                if ((nested = (Map)v) == null) {
                    nested = new LinkedHashMap();
                    result.put(name, nested);
                }
                nested.put(((OptionElement)value).getName(), ((OptionElement)value).getValue());
            } else {
                Object previous = result.get(name);
                Object v = previous;
                if (v == null) {
                    result.put(name, value);
                } else if (v instanceof List) {
                    Object v2 = previous;
                    if (v2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableList<kotlin.Any>");
                    }
                    this.addToList(TypeIntrinsics.asMutableList(v2), value);
                } else {
                    ArrayList newList = new ArrayList();
                    newList.add(previous);
                    this.addToList(newList, value);
                    result.put(name, newList);
                }
            }
            this.reader.peekChar(',');
        }
        return result;
    }

    private final void addToList(List<Object> list, Object value) {
        if (value instanceof List) {
            list.addAll((Collection)value);
        } else {
            list.add(value);
        }
    }

    private final List<Object> readList() {
        this.reader.require('[');
        boolean bl = false;
        List result = new ArrayList();
        do {
            if (this.reader.peekChar(']')) {
                return result;
            }
            result.add(this.readKindAndValue().getValue$schema2proto_wire());
        } while (this.reader.peekChar(',') || this.reader.peekChar() == ']');
        RuntimeException runtimeException = this.reader.unexpected("expected ',' or ']'");
        Intrinsics.checkExpressionValueIsNotNull(runtimeException, "reader.unexpected(\"expected ',' or ']'\")");
        throw (Throwable)runtimeException;
    }

    @NotNull
    public final SyntaxReader getReader$schema2proto_wire() {
        return this.reader;
    }

    public OptionReader(@NotNull SyntaxReader reader) {
        Intrinsics.checkParameterIsNotNull(reader, "reader");
        this.reader = reader;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\n\u001a\u00020\u0003H\u00c0\u0003\u00a2\u0006\u0002\b\u000bJ\u000e\u0010\f\u001a\u00020\u0001H\u00c0\u0003\u00a2\u0006\u0002\b\rJ\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0001H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0004\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0016"}, d2={"Lcom/squareup/wire/schema/internal/parser/OptionReader$KindAndValue;", "", "kind", "Lcom/squareup/wire/schema/internal/parser/OptionElement$Kind;", "value", "(Lcom/squareup/wire/schema/internal/parser/OptionElement$Kind;Ljava/lang/Object;)V", "getKind$schema2proto_wire", "()Lcom/squareup/wire/schema/internal/parser/OptionElement$Kind;", "getValue$schema2proto_wire", "()Ljava/lang/Object;", "component1", "component1$schema2proto_wire", "component2", "component2$schema2proto_wire", "copy", "equals", "", "other", "hashCode", "", "toString", "", "schema2proto-wire"})
    public static final class KindAndValue {
        @NotNull
        private final OptionElement.Kind kind;
        @NotNull
        private final Object value;

        @NotNull
        public final OptionElement.Kind getKind$schema2proto_wire() {
            return this.kind;
        }

        @NotNull
        public final Object getValue$schema2proto_wire() {
            return this.value;
        }

        public KindAndValue(@NotNull OptionElement.Kind kind, @NotNull Object value) {
            Intrinsics.checkParameterIsNotNull((Object)kind, "kind");
            Intrinsics.checkParameterIsNotNull(value, "value");
            this.kind = kind;
            this.value = value;
        }

        @NotNull
        public final OptionElement.Kind component1$schema2proto_wire() {
            return this.kind;
        }

        @NotNull
        public final Object component2$schema2proto_wire() {
            return this.value;
        }

        @NotNull
        public final KindAndValue copy(@NotNull OptionElement.Kind kind, @NotNull Object value) {
            Intrinsics.checkParameterIsNotNull((Object)kind, "kind");
            Intrinsics.checkParameterIsNotNull(value, "value");
            return new KindAndValue(kind, value);
        }

        @NotNull
        public static /* synthetic */ KindAndValue copy$default(KindAndValue kindAndValue, OptionElement.Kind kind, Object object, int n, Object object2) {
            if ((n & 1) != 0) {
                kind = kindAndValue.kind;
            }
            if ((n & 2) != 0) {
                object = kindAndValue.value;
            }
            return kindAndValue.copy(kind, object);
        }

        @NotNull
        public String toString() {
            return "KindAndValue(kind=" + (Object)((Object)this.kind) + ", value=" + this.value + ")";
        }

        public int hashCode() {
            OptionElement.Kind kind = this.kind;
            Object object = this.value;
            return (kind != null ? ((Object)((Object)kind)).hashCode() : 0) * 31 + (object != null ? object.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof KindAndValue)) break block3;
                    KindAndValue kindAndValue = (KindAndValue)object;
                    if (!Intrinsics.areEqual((Object)this.kind, (Object)kindAndValue.kind) || !Intrinsics.areEqual(this.value, kindAndValue.value)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

