/*
 * Decompiled with CFR 0.152.
 */
package no.entur.schema2proto.generateproto;

import com.squareup.wire.schema.internal.parser.OptionElement;
import com.sun.xml.xsom.XSAttributeDecl;
import com.sun.xml.xsom.XSFacet;
import com.sun.xml.xsom.XSParticle;
import com.sun.xml.xsom.XSRestrictionSimpleType;
import com.sun.xml.xsom.XSSimpleType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import no.entur.schema2proto.generateproto.Schema2ProtoConfiguration;
import no.entur.schema2proto.generateproto.SchemaParser;
import no.entur.schema2proto.generateproto.TypeRegistry;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PGVRuleFactory {
    public static final String VALIDATE_RULES_NAME = "validate.rules";
    private static final String RULE_STRING_PATTERN = "string.pattern";
    private final SchemaParser schemaParser;
    private Schema2ProtoConfiguration configuration;
    private final Set<String> basicTypes;
    private Map<String, OptionElement> defaultValidationRulesForBasicTypes;
    private static final Logger LOGGER = LoggerFactory.getLogger(PGVRuleFactory.class);

    public PGVRuleFactory(Schema2ProtoConfiguration configuration, SchemaParser schemaParser) {
        this.configuration = configuration;
        this.schemaParser = schemaParser;
        this.basicTypes = TypeRegistry.getBasicTypes();
        this.defaultValidationRulesForBasicTypes = new HashMap<String, OptionElement>();
        this.defaultValidationRulesForBasicTypes.putAll(this.getValidationRuleForBasicTypes());
    }

    public List<OptionElement> getValidationRule(XSParticle parentParticle) {
        ArrayList<OptionElement> validationRules = new ArrayList<OptionElement>();
        return validationRules;
    }

    public List<OptionElement> getValidationRule(XSAttributeDecl attributeDecl) {
        ArrayList<OptionElement> validationRules = new ArrayList<OptionElement>();
        if (this.configuration.includeValidationRules) {
            // empty if block
        }
        return validationRules;
    }

    public List<OptionElement> getValidationRule(XSSimpleType simpleType2) {
        ArrayList<OptionElement> validationRules = new ArrayList<OptionElement>();
        if (this.configuration.includeValidationRules) {
            String typeName = simpleType2.getName();
            if (typeName != null && this.basicTypes.contains(typeName)) {
                validationRules.addAll(this.getValidationRuleForBasicType(typeName));
            } else if (simpleType2.isRestriction()) {
                XSRestrictionSimpleType restriction = simpleType2.asRestriction();
                Collection<? extends XSFacet> declaredFacets = restriction.getDeclaredFacets();
                String baseType = this.schemaParser.findFieldType(simpleType2);
                if ("string".equals(baseType)) {
                    this.addOptionForString(validationRules, declaredFacets);
                }
            } else {
                LOGGER.warn("During validation rules extraction; Found anonymous simpleType that is not a restriction: {}", (Object)simpleType2);
            }
        }
        return validationRules;
    }

    private void addOptionForString(List<OptionElement> validationRules, Collection<? extends XSFacet> declaredFacets) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        block10: for (XSFacet xSFacet : declaredFacets) {
            switch (xSFacet.getName()) {
                case "pattern": {
                    parameters.put("pattern", StringUtils.replace(xSFacet.getValue().value, "\\", "\\\\"));
                    continue block10;
                }
                case "minLength": {
                    parameters.put("min_len", Integer.parseInt(xSFacet.getValue().value));
                    continue block10;
                }
                case "maxLength": {
                    parameters.put("max_len", Integer.parseInt(xSFacet.getValue().value));
                    continue block10;
                }
            }
            LOGGER.warn("Unhandled facet {}", (Object)xSFacet.getName());
        }
        OptionElement option = new OptionElement("string", OptionElement.Kind.MAP, parameters, false);
        OptionElement optionElement = new OptionElement(VALIDATE_RULES_NAME, OptionElement.Kind.OPTION, option, true);
        validationRules.add(optionElement);
    }

    private List<OptionElement> getValidationRuleForBasicType(String name) {
        ArrayList<OptionElement> validationRules = new ArrayList<OptionElement>();
        OptionElement validationRule = this.defaultValidationRulesForBasicTypes.get(name);
        if (validationRule != null) {
            validationRules.add(validationRule);
        }
        return validationRules;
    }

    public Map<String, OptionElement> getValidationRuleForBasicTypes() {
        HashMap<String, OptionElement> typeToValidationRule = new HashMap<String, OptionElement>();
        typeToValidationRule.put("gYearMonth", this.createOptionElement(RULE_STRING_PATTERN, OptionElement.Kind.STRING, "[0-9]{4}-[0-9]{2}"));
        typeToValidationRule.put("gYear", this.createOptionElement(RULE_STRING_PATTERN, OptionElement.Kind.STRING, "[0-9]{4}"));
        typeToValidationRule.put("gMonthDay", this.createOptionElement(RULE_STRING_PATTERN, OptionElement.Kind.STRING, "[0-9]{4}-[0-9]{2}"));
        typeToValidationRule.put("gDay", this.createOptionElement(RULE_STRING_PATTERN, OptionElement.Kind.STRING, "[0-9]{2}"));
        typeToValidationRule.put("gMonth", this.createOptionElement(RULE_STRING_PATTERN, OptionElement.Kind.STRING, "[0-9]{2}"));
        typeToValidationRule.put("language", this.createOptionElement(RULE_STRING_PATTERN, OptionElement.Kind.STRING, "[a-zA-Z]{1,8}(-[a-zA-Z0-9]{1,8})*"));
        typeToValidationRule.put("nonPositiveInteger", this.createOptionElement("sint32.lte", OptionElement.Kind.NUMBER, 0));
        typeToValidationRule.put("negativeInteger", this.createOptionElement("sint32.lt", OptionElement.Kind.NUMBER, 0));
        typeToValidationRule.put("nonNegativeInteger", this.createOptionElement("uint32.gte", OptionElement.Kind.NUMBER, 0));
        typeToValidationRule.put("positiveInteger", this.createOptionElement("uint32.gt", OptionElement.Kind.NUMBER, 0));
        return typeToValidationRule;
    }

    private OptionElement createOptionElement(String name, OptionElement.Kind kind, Object value) {
        OptionElement option = new OptionElement(name, kind, value, false);
        return new OptionElement(VALIDATE_RULES_NAME, OptionElement.Kind.OPTION, option, true);
    }
}

