/*
 * Decompiled with CFR 0.152.
 */
package build.buf.protovalidate;

import build.buf.protovalidate.AnyEvaluator;
import build.buf.protovalidate.AstExpression;
import build.buf.protovalidate.CelPrograms;
import build.buf.protovalidate.CompiledProgram;
import build.buf.protovalidate.Config;
import build.buf.protovalidate.DescriptorMappings;
import build.buf.protovalidate.EmbeddedMessageEvaluator;
import build.buf.protovalidate.EnumEvaluator;
import build.buf.protovalidate.Evaluator;
import build.buf.protovalidate.Expression;
import build.buf.protovalidate.FieldEvaluator;
import build.buf.protovalidate.FieldPathUtils;
import build.buf.protovalidate.ListEvaluator;
import build.buf.protovalidate.MapEvaluator;
import build.buf.protovalidate.MessageEvaluator;
import build.buf.protovalidate.MessageOneofEvaluator;
import build.buf.protovalidate.MessageValue;
import build.buf.protovalidate.OneofEvaluator;
import build.buf.protovalidate.ProtoAdapter;
import build.buf.protovalidate.RuleCache;
import build.buf.protovalidate.RuleResolver;
import build.buf.protovalidate.UnknownDescriptorEvaluator;
import build.buf.protovalidate.ValueEvaluator;
import build.buf.protovalidate.exceptions.CompilationException;
import build.buf.validate.FieldPath;
import build.buf.validate.FieldPathElement;
import build.buf.validate.FieldRules;
import build.buf.validate.Ignore;
import build.buf.validate.MessageOneofRule;
import build.buf.validate.MessageRules;
import build.buf.validate.OneofRules;
import build.buf.validate.Rule;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import dev.cel.bundle.Cel;
import dev.cel.bundle.CelBuilder;
import dev.cel.common.types.StructTypeReference;
import dev.cel.runtime.CelEvaluationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;

final class EvaluatorBuilder {
    private static final FieldPathElement CEL_FIELD_PATH_ELEMENT = FieldPathUtils.fieldPathElement(FieldRules.getDescriptor().findFieldByNumber(23));
    private volatile Map<Descriptors.Descriptor, MessageEvaluator> evaluatorCache = Collections.emptyMap();
    private final Cel cel;
    private final boolean disableLazy;
    private final RuleCache rules;

    EvaluatorBuilder(Cel cel, Config config) {
        this.cel = cel;
        this.disableLazy = false;
        this.rules = new RuleCache(cel, config);
    }

    EvaluatorBuilder(Cel cel, Config config, List<Descriptors.Descriptor> descriptors, boolean disableLazy) throws CompilationException {
        Objects.requireNonNull(descriptors, "descriptors must not be null");
        this.cel = cel;
        this.disableLazy = disableLazy;
        this.rules = new RuleCache(cel, config);
        for (Descriptors.Descriptor descriptor : descriptors) {
            this.build(descriptor);
        }
    }

    Evaluator load(Descriptors.Descriptor desc) throws CompilationException {
        Evaluator evaluator = this.evaluatorCache.get(desc);
        if (evaluator == null && this.disableLazy) {
            return new UnknownDescriptorEvaluator(desc);
        }
        return this.build(desc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Evaluator build(Descriptors.Descriptor desc) throws CompilationException {
        Evaluator eval = this.evaluatorCache.get(desc);
        if (eval != null) {
            return eval;
        }
        EvaluatorBuilder evaluatorBuilder = this;
        synchronized (evaluatorBuilder) {
            eval = this.evaluatorCache.get(desc);
            if (eval != null) {
                return eval;
            }
            Map<Descriptors.Descriptor, MessageEvaluator> updatedCache = new DescriptorCacheBuilder(this.cel, this.rules, this.evaluatorCache).build(desc);
            this.evaluatorCache = updatedCache;
            eval = updatedCache.get(desc);
            if (eval == null) {
                throw new IllegalStateException("updated cache missing evaluator for descriptor - should not happen");
            }
        }
        return eval;
    }

    private static class DescriptorCacheBuilder {
        private final RuleResolver resolver = new RuleResolver();
        private final Cel cel;
        private final RuleCache ruleCache;
        private final HashMap<Descriptors.Descriptor, MessageEvaluator> cache;

        private DescriptorCacheBuilder(Cel cel, RuleCache ruleCache, Map<Descriptors.Descriptor, MessageEvaluator> previousCache) {
            this.cel = Objects.requireNonNull(cel, "cel");
            this.ruleCache = Objects.requireNonNull(ruleCache, "ruleCache");
            this.cache = new HashMap<Descriptors.Descriptor, MessageEvaluator>(previousCache);
        }

        Map<Descriptors.Descriptor, MessageEvaluator> build(Descriptors.Descriptor descriptor) throws CompilationException {
            this.createMessageEvaluator(descriptor);
            return Collections.unmodifiableMap(this.cache);
        }

        private MessageEvaluator createMessageEvaluator(Descriptors.Descriptor desc) throws CompilationException {
            MessageEvaluator eval = this.cache.get(desc);
            if (eval != null) {
                return eval;
            }
            MessageEvaluator msgEval = new MessageEvaluator();
            this.cache.put(desc, msgEval);
            this.buildMessage(desc, msgEval);
            return msgEval;
        }

        private void buildMessage(Descriptors.Descriptor desc, MessageEvaluator msgEval) throws CompilationException {
            try {
                DynamicMessage defaultInstance = DynamicMessage.newBuilder(desc).buildPartial();
                Descriptors.Descriptor descriptor = defaultInstance.getDescriptorForType();
                MessageRules msgRules = this.resolver.resolveMessageRules(descriptor);
                this.processMessageExpressions(descriptor, msgRules, msgEval, defaultInstance);
                this.processMessageOneofRules(descriptor, msgRules, msgEval);
                this.processOneofRules(descriptor, msgEval);
                this.processFields(descriptor, msgRules, msgEval);
            }
            catch (InvalidProtocolBufferException e) {
                throw new CompilationException("failed to parse proto definition: " + desc.getFullName(), e);
            }
        }

        private void processMessageExpressions(Descriptors.Descriptor desc, MessageRules msgRules, MessageEvaluator msgEval, DynamicMessage message) throws CompilationException {
            List<Rule> celList = msgRules.getCelList();
            if (celList.isEmpty()) {
                return;
            }
            Cel finalCel = this.cel.toCelBuilder().addMessageTypes(message.getDescriptorForType()).addVar("this", StructTypeReference.create(desc.getFullName())).build();
            List<CompiledProgram> compiledPrograms = DescriptorCacheBuilder.compileRules(celList, finalCel, false);
            if (compiledPrograms.isEmpty()) {
                throw new CompilationException("compile returned null");
            }
            msgEval.append(new CelPrograms(null, compiledPrograms));
        }

        private void processMessageOneofRules(Descriptors.Descriptor desc, MessageRules msgRules, MessageEvaluator msgEval) throws CompilationException {
            for (MessageOneofRule rule : msgRules.getOneofList()) {
                if (rule.getFieldsCount() == 0) {
                    throw new CompilationException(String.format("at least one field must be specified in oneof rule for the message %s", desc.getFullName()));
                }
                LinkedHashSet<Descriptors.FieldDescriptor> fields = new LinkedHashSet<Descriptors.FieldDescriptor>(rule.getFieldsCount());
                for (String name : rule.getFieldsList()) {
                    Descriptors.FieldDescriptor field = desc.findFieldByName(name);
                    if (field == null) {
                        throw new CompilationException(String.format("field %s not found in %s", name, desc.getFullName()));
                    }
                    if (fields.add(field)) continue;
                    throw new CompilationException(String.format("duplicate %s in oneof rule for the message %s", name, desc.getFullName()));
                }
                msgEval.append(new MessageOneofEvaluator(new ArrayList<Descriptors.FieldDescriptor>(fields), rule.getRequired()));
            }
        }

        private void processOneofRules(Descriptors.Descriptor desc, MessageEvaluator msgEval) throws InvalidProtocolBufferException, CompilationException {
            List<Descriptors.OneofDescriptor> oneofs = desc.getOneofs();
            for (Descriptors.OneofDescriptor oneofDesc : oneofs) {
                OneofRules oneofRules = this.resolver.resolveOneofRules(oneofDesc);
                OneofEvaluator oneofEvaluatorEval = new OneofEvaluator(oneofDesc, oneofRules.getRequired());
                msgEval.append(oneofEvaluatorEval);
            }
        }

        private void processFields(Descriptors.Descriptor desc, MessageRules msgRules, MessageEvaluator msgEval) throws CompilationException, InvalidProtocolBufferException {
            List<Descriptors.FieldDescriptor> fields = desc.getFields();
            for (Descriptors.FieldDescriptor fieldDescriptor : fields) {
                Descriptors.FieldDescriptor descriptor = desc.findFieldByName(fieldDescriptor.getName());
                FieldRules fieldRules = this.resolver.resolveFieldRules(descriptor);
                if (!fieldRules.hasIgnore() && msgRules.getOneofList().stream().anyMatch(oneof -> oneof.getFieldsList().contains(fieldDescriptor.getName()))) {
                    fieldRules = fieldRules.toBuilder().setIgnore(Ignore.IGNORE_IF_ZERO_VALUE).build();
                }
                FieldEvaluator fldEval = this.buildField(descriptor, fieldRules);
                msgEval.append(fldEval);
            }
        }

        private FieldEvaluator buildField(Descriptors.FieldDescriptor fieldDescriptor, FieldRules fieldRules) throws CompilationException {
            ValueEvaluator valueEvaluatorEval = new ValueEvaluator(fieldDescriptor, null);
            FieldEvaluator fieldEvaluator = new FieldEvaluator(valueEvaluatorEval, fieldDescriptor, fieldRules.getRequired(), fieldDescriptor.hasPresence(), fieldRules.getIgnore());
            this.buildValue(fieldDescriptor, fieldRules, fieldEvaluator.valueEvaluator);
            return fieldEvaluator;
        }

        private static boolean shouldIgnoreEmpty(FieldRules rules) {
            return rules.getIgnore() == Ignore.IGNORE_IF_ZERO_VALUE;
        }

        private void buildValue(Descriptors.FieldDescriptor fieldDescriptor, FieldRules fieldRules, ValueEvaluator valueEvaluator) throws CompilationException {
            if (fieldRules.getIgnore() == Ignore.IGNORE_ALWAYS) {
                return;
            }
            this.processIgnoreEmpty(fieldDescriptor, fieldRules, valueEvaluator);
            this.processFieldExpressions(fieldDescriptor, fieldRules, valueEvaluator);
            this.processEmbeddedMessage(fieldDescriptor, valueEvaluator);
            this.processWrapperRules(fieldDescriptor, fieldRules, valueEvaluator);
            this.processStandardRules(fieldDescriptor, fieldRules, valueEvaluator);
            this.processAnyRules(fieldDescriptor, fieldRules, valueEvaluator);
            this.processEnumRules(fieldDescriptor, fieldRules, valueEvaluator);
            this.processMapRules(fieldDescriptor, fieldRules, valueEvaluator);
            this.processRepeatedRules(fieldDescriptor, fieldRules, valueEvaluator);
        }

        private void processIgnoreEmpty(Descriptors.FieldDescriptor fieldDescriptor, FieldRules fieldRules, ValueEvaluator valueEvaluatorEval) throws CompilationException {
            if (valueEvaluatorEval.hasNestedRule() && DescriptorCacheBuilder.shouldIgnoreEmpty(fieldRules)) {
                valueEvaluatorEval.setIgnoreEmpty(this.zeroValue(fieldDescriptor, true));
            }
        }

        private Object zeroValue(Descriptors.FieldDescriptor fieldDescriptor, boolean forItems) throws CompilationException {
            Object zero;
            if (forItems && fieldDescriptor.isRepeated()) {
                switch (fieldDescriptor.getType().getJavaType()) {
                    case INT: 
                    case LONG: {
                        zero = 0L;
                        break;
                    }
                    case FLOAT: 
                    case DOUBLE: {
                        zero = 0.0;
                        break;
                    }
                    case BOOLEAN: {
                        zero = false;
                        break;
                    }
                    case STRING: {
                        zero = "";
                        break;
                    }
                    case BYTE_STRING: {
                        zero = ByteString.EMPTY;
                        break;
                    }
                    case ENUM: {
                        zero = (long)fieldDescriptor.getEnumType().getValues().get(0).getNumber();
                        break;
                    }
                    case MESSAGE: {
                        zero = this.createMessageForType(fieldDescriptor.getMessageType());
                        break;
                    }
                    default: {
                        zero = fieldDescriptor.getDefaultValue();
                        break;
                    }
                }
            } else {
                zero = fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE && !fieldDescriptor.isRepeated() ? this.createMessageForType(fieldDescriptor.getMessageType()) : ProtoAdapter.scalarToCel(fieldDescriptor.getType(), fieldDescriptor.getDefaultValue());
            }
            return zero;
        }

        private Message createMessageForType(Descriptors.Descriptor messageType) throws CompilationException {
            try {
                return DynamicMessage.parseFrom(messageType, new byte[0]);
            }
            catch (InvalidProtocolBufferException e) {
                throw new CompilationException("field descriptor type is invalid " + e.getMessage(), e);
            }
        }

        private void processFieldExpressions(Descriptors.FieldDescriptor fieldDescriptor, FieldRules fieldRules, ValueEvaluator valueEvaluatorEval) throws CompilationException {
            Cel finalCel;
            List<CompiledProgram> compiledPrograms;
            List<Rule> rulesCelList = fieldRules.getCelList();
            if (rulesCelList.isEmpty()) {
                return;
            }
            CelBuilder builder = this.cel.toCelBuilder();
            builder = builder.addVar("this", DescriptorMappings.getCELType(fieldDescriptor, valueEvaluatorEval.hasNestedRule()));
            if (fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                builder = builder.addMessageTypes(fieldDescriptor.getMessageType());
            }
            if (!(compiledPrograms = DescriptorCacheBuilder.compileRules(rulesCelList, finalCel = builder.build(), true)).isEmpty()) {
                valueEvaluatorEval.append(new CelPrograms(valueEvaluatorEval, compiledPrograms));
            }
        }

        private void processEmbeddedMessage(Descriptors.FieldDescriptor fieldDescriptor, ValueEvaluator valueEvaluatorEval) throws CompilationException {
            if (fieldDescriptor.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE || fieldDescriptor.isMapField() || fieldDescriptor.isRepeated() && !valueEvaluatorEval.hasNestedRule()) {
                return;
            }
            EmbeddedMessageEvaluator embedEval = new EmbeddedMessageEvaluator(valueEvaluatorEval, this.createMessageEvaluator(fieldDescriptor.getMessageType()));
            valueEvaluatorEval.append(embedEval);
        }

        private void processWrapperRules(Descriptors.FieldDescriptor fieldDescriptor, FieldRules fieldRules, ValueEvaluator valueEvaluatorEval) throws CompilationException {
            if (fieldDescriptor.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE || fieldDescriptor.isMapField() || fieldDescriptor.isRepeated() && !valueEvaluatorEval.hasNestedRule()) {
                return;
            }
            Descriptors.FieldDescriptor expectedWrapperDescriptor = DescriptorMappings.expectedWrapperRules(fieldDescriptor.getMessageType().getFullName());
            if (expectedWrapperDescriptor != null) {
                Descriptors.FieldDescriptor oneofFieldDescriptor = fieldRules.getOneofFieldDescriptor(DescriptorMappings.FIELD_RULES_ONEOF_DESC);
                if (oneofFieldDescriptor == null) {
                    return;
                }
                if (!expectedWrapperDescriptor.getMessageType().getFullName().equals(oneofFieldDescriptor.getMessageType().getFullName())) {
                    throw new CompilationException(String.format("mismatched message rules, %s is not a valid rule for field %s", oneofFieldDescriptor.getName(), fieldDescriptor.getName()));
                }
            }
            if (expectedWrapperDescriptor == null || !fieldRules.hasField(expectedWrapperDescriptor)) {
                return;
            }
            ValueEvaluator unwrapped = new ValueEvaluator(valueEvaluatorEval.getDescriptor(), valueEvaluatorEval.getNestedRule());
            this.buildValue(fieldDescriptor.getMessageType().findFieldByName("value"), fieldRules, unwrapped);
            valueEvaluatorEval.append(unwrapped);
        }

        private void processStandardRules(Descriptors.FieldDescriptor fieldDescriptor, FieldRules fieldRules, ValueEvaluator valueEvaluatorEval) throws CompilationException {
            Descriptors.FieldDescriptor expectedWrapperDescriptor;
            if (fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE && (expectedWrapperDescriptor = DescriptorMappings.expectedWrapperRules(fieldDescriptor.getMessageType().getFullName())) != null) {
                return;
            }
            List<CompiledProgram> compile = this.ruleCache.compile(fieldDescriptor, fieldRules, valueEvaluatorEval.hasNestedRule());
            if (compile.isEmpty()) {
                return;
            }
            valueEvaluatorEval.append(new CelPrograms(valueEvaluatorEval, compile));
        }

        private void processAnyRules(Descriptors.FieldDescriptor fieldDescriptor, FieldRules fieldRules, ValueEvaluator valueEvaluatorEval) {
            if (fieldDescriptor.isRepeated() && !valueEvaluatorEval.hasNestedRule() || fieldDescriptor.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE || !fieldDescriptor.getMessageType().getFullName().equals("google.protobuf.Any")) {
                return;
            }
            Descriptors.FieldDescriptor typeURLDesc = fieldDescriptor.getMessageType().findFieldByName("type_url");
            valueEvaluatorEval.append(new AnyEvaluator(valueEvaluatorEval, typeURLDesc, fieldRules.getAny().getInList(), fieldRules.getAny().getNotInList()));
        }

        private void processEnumRules(Descriptors.FieldDescriptor fieldDescriptor, FieldRules fieldRules, ValueEvaluator valueEvaluatorEval) {
            if (fieldDescriptor.getJavaType() != Descriptors.FieldDescriptor.JavaType.ENUM) {
                return;
            }
            if (fieldRules.getEnum().getDefinedOnly()) {
                Descriptors.EnumDescriptor enumDescriptor = fieldDescriptor.getEnumType();
                valueEvaluatorEval.append(new EnumEvaluator(valueEvaluatorEval, enumDescriptor.getValues()));
            }
        }

        private void processMapRules(Descriptors.FieldDescriptor fieldDescriptor, FieldRules fieldRules, ValueEvaluator valueEvaluatorEval) throws CompilationException {
            if (!fieldDescriptor.isMapField()) {
                return;
            }
            MapEvaluator mapEval = new MapEvaluator(valueEvaluatorEval, fieldDescriptor);
            this.buildValue(fieldDescriptor.getMessageType().findFieldByNumber(1), fieldRules.getMap().getKeys(), mapEval.getKeyEvaluator());
            this.buildValue(fieldDescriptor.getMessageType().findFieldByNumber(2), fieldRules.getMap().getValues(), mapEval.getValueEvaluator());
            valueEvaluatorEval.append(mapEval);
        }

        private void processRepeatedRules(Descriptors.FieldDescriptor fieldDescriptor, FieldRules fieldRules, ValueEvaluator valueEvaluatorEval) throws CompilationException {
            if (fieldDescriptor.isMapField() || !fieldDescriptor.isRepeated() || valueEvaluatorEval.hasNestedRule()) {
                return;
            }
            ListEvaluator listEval = new ListEvaluator(valueEvaluatorEval);
            this.buildValue(fieldDescriptor, fieldRules.getRepeated().getItems(), listEval.itemRules);
            valueEvaluatorEval.append(listEval);
        }

        private static List<CompiledProgram> compileRules(List<Rule> rules, Cel cel, boolean isField) throws CompilationException {
            List<Expression> expressions = Expression.fromRules(rules);
            ArrayList<CompiledProgram> compiledPrograms = new ArrayList<CompiledProgram>();
            for (int i = 0; i < expressions.size(); ++i) {
                Expression expression = expressions.get(i);
                AstExpression astExpression = AstExpression.newAstExpression(cel, expression);
                FieldPath rulePath = null;
                if (isField) {
                    rulePath = FieldPath.newBuilder().addElements(CEL_FIELD_PATH_ELEMENT.toBuilder().setIndex(i)).build();
                }
                try {
                    compiledPrograms.add(new CompiledProgram(cel.createProgram(astExpression.ast), astExpression.source, rulePath, new MessageValue(rules.get(i)), null));
                    continue;
                }
                catch (CelEvaluationException e) {
                    throw new CompilationException("failed to evaluate rule " + rules.get(i).getId(), e);
                }
            }
            return compiledPrograms;
        }
    }
}

