/*
 * Decompiled with CFR 0.152.
 */
package build.buf.protovalidate;

import build.buf.protovalidate.Evaluator;
import build.buf.protovalidate.FieldPathUtils;
import build.buf.protovalidate.RuleViolation;
import build.buf.protovalidate.RuleViolationHelper;
import build.buf.protovalidate.Value;
import build.buf.protovalidate.ValueEvaluator;
import build.buf.protovalidate.exceptions.ExecutionException;
import build.buf.validate.FieldPath;
import build.buf.validate.FieldPathElement;
import build.buf.validate.FieldRules;
import build.buf.validate.RepeatedRules;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

final class ListEvaluator
implements Evaluator {
    private static final FieldPath REPEATED_ITEMS_RULE_PATH = FieldPath.newBuilder().addElements(FieldPathUtils.fieldPathElement(FieldRules.getDescriptor().findFieldByNumber(18))).addElements(FieldPathUtils.fieldPathElement(RepeatedRules.getDescriptor().findFieldByNumber(4))).build();
    private final RuleViolationHelper helper;
    final ValueEvaluator itemRules;

    ListEvaluator(ValueEvaluator valueEvaluator) {
        this.helper = new RuleViolationHelper(valueEvaluator);
        this.itemRules = new ValueEvaluator(null, REPEATED_ITEMS_RULE_PATH);
    }

    @Override
    public boolean tautology() {
        return this.itemRules.tautology();
    }

    @Override
    public List<RuleViolation.Builder> evaluate(Value val, boolean failFast) throws ExecutionException {
        ArrayList<RuleViolation.Builder> allViolations = new ArrayList<RuleViolation.Builder>();
        List<Value> repeatedValues = val.repeatedValue();
        for (int i = 0; i < repeatedValues.size(); ++i) {
            List<RuleViolation.Builder> violations = this.itemRules.evaluate(repeatedValues.get(i), failFast);
            if (violations.isEmpty()) continue;
            FieldPathElement fieldPathElement = Objects.requireNonNull(this.helper.getFieldPathElement()).toBuilder().setIndex(i).build();
            FieldPathUtils.updatePaths(violations, fieldPathElement, this.helper.getRulePrefixElements());
            if (failFast && !violations.isEmpty()) {
                return violations;
            }
            allViolations.addAll(violations);
        }
        return allViolations;
    }
}

