/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.xsom.impl.parser.state;

import com.sun.xml.xsom.impl.parser.state.AttributesImpl;
import com.sun.xml.xsom.impl.parser.state.NGCCEventReceiver;
import com.sun.xml.xsom.impl.parser.state.NGCCEventSource;
import com.sun.xml.xsom.impl.parser.state.NGCCHandler;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Stack;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class NGCCRuntime
implements ContentHandler,
NGCCEventSource {
    private Locator locator;
    private final Stack attStack = new Stack();
    private AttributesImpl currentAtts;
    private StringBuffer text = new StringBuffer();
    private NGCCEventReceiver currentHandler;
    static final String IMPOSSIBLE = "\u0000";
    private ContentHandler redirect = null;
    private int redirectionDepth = 0;
    private final ArrayList namespaces = new ArrayList();
    private int nsEffectivePtr = 0;
    private final Stack nsEffectiveStack = new Stack();
    private int indent = 0;
    private boolean needIndent = true;

    public NGCCRuntime() {
        this.reset();
    }

    public void setRootHandler(NGCCHandler rootHandler) {
        if (this.currentHandler != null) {
            throw new IllegalStateException();
        }
        this.currentHandler = rootHandler;
    }

    public void reset() {
        this.attStack.clear();
        this.currentAtts = null;
        this.currentHandler = null;
        this.indent = 0;
        this.locator = null;
        this.namespaces.clear();
        this.needIndent = true;
        this.redirect = null;
        this.redirectionDepth = 0;
        this.text = new StringBuffer();
        this.attStack.push(new AttributesImpl());
    }

    @Override
    public void setDocumentLocator(Locator _loc) {
        this.locator = _loc;
    }

    public Locator getLocator() {
        return this.locator;
    }

    public Attributes getCurrentAttributes() {
        return this.currentAtts;
    }

    @Override
    public int replace(NGCCEventReceiver o, NGCCEventReceiver n) {
        if (o != this.currentHandler) {
            throw new IllegalStateException();
        }
        this.currentHandler = n;
        return 0;
    }

    private void processPendingText(boolean ignorable) throws SAXException {
        if (!ignorable || this.text.toString().trim().length() != 0) {
            this.currentHandler.text(this.text.toString());
        }
        if (this.text.length() > 1024) {
            this.text = new StringBuffer();
        } else {
            this.text.setLength(0);
        }
    }

    public void processList(String str) throws SAXException {
        StringTokenizer t2 = new StringTokenizer(str, " \t\r\n");
        while (t2.hasMoreTokens()) {
            this.currentHandler.text(t2.nextToken());
        }
    }

    @Override
    public void startElement(String uri, String localname, String qname2, Attributes atts) throws SAXException {
        if (this.redirect != null) {
            this.redirect.startElement(uri, localname, qname2, atts);
            ++this.redirectionDepth;
        } else {
            this.processPendingText(true);
            this.currentHandler.enterElement(uri, localname, qname2, atts);
        }
    }

    public void onEnterElementConsumed(String uri, String localName, String qname2, Attributes atts) throws SAXException {
        this.currentAtts = new AttributesImpl(atts);
        this.attStack.push(this.currentAtts);
        this.nsEffectiveStack.push(new Integer(this.nsEffectivePtr));
        this.nsEffectivePtr = this.namespaces.size();
    }

    public void onLeaveElementConsumed(String uri, String localName, String qname2) throws SAXException {
        this.attStack.pop();
        this.currentAtts = this.attStack.isEmpty() ? null : (AttributesImpl)this.attStack.peek();
        this.nsEffectivePtr = (Integer)this.nsEffectiveStack.pop();
    }

    @Override
    public void endElement(String uri, String localname, String qname2) throws SAXException {
        if (this.redirect != null) {
            this.redirect.endElement(uri, localname, qname2);
            --this.redirectionDepth;
            if (this.redirectionDepth != 0) {
                return;
            }
            for (int i = 0; i < this.namespaces.size(); i += 2) {
                this.redirect.endPrefixMapping((String)this.namespaces.get(i));
            }
            this.redirect.endDocument();
            this.redirect = null;
        }
        this.processPendingText(false);
        this.currentHandler.leaveElement(uri, localname, qname2);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.redirect != null) {
            this.redirect.characters(ch, start, length);
        } else {
            this.text.append(ch, start, length);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.redirect != null) {
            this.redirect.ignorableWhitespace(ch, start, length);
        } else {
            this.text.append(ch, start, length);
        }
    }

    public int getAttributeIndex(String uri, String localname) {
        return this.currentAtts.getIndex(uri, localname);
    }

    public void consumeAttribute(int index) throws SAXException {
        String uri = this.currentAtts.getURI(index);
        String local = this.currentAtts.getLocalName(index);
        String qname2 = this.currentAtts.getQName(index);
        String value = this.currentAtts.getValue(index);
        this.currentAtts.removeAttribute(index);
        this.currentHandler.enterAttribute(uri, local, qname2);
        this.currentHandler.text(value);
        this.currentHandler.leaveAttribute(uri, local, qname2);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.redirect != null) {
            this.redirect.startPrefixMapping(prefix, uri);
        } else {
            this.namespaces.add(prefix);
            this.namespaces.add(uri);
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        if (this.redirect != null) {
            this.redirect.endPrefixMapping(prefix);
        } else {
            this.namespaces.remove(this.namespaces.size() - 1);
            this.namespaces.remove(this.namespaces.size() - 1);
        }
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        if (this.redirect != null) {
            this.redirect.skippedEntity(name);
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        if (this.redirect != null) {
            this.redirect.processingInstruction(target, data);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        this.currentHandler.leaveElement(IMPOSSIBLE, IMPOSSIBLE, IMPOSSIBLE);
        this.reset();
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void sendEnterAttribute(int threadId, String uri, String local, String qname2) throws SAXException {
        this.currentHandler.enterAttribute(uri, local, qname2);
    }

    @Override
    public void sendEnterElement(int threadId, String uri, String local, String qname2, Attributes atts) throws SAXException {
        this.currentHandler.enterElement(uri, local, qname2, atts);
    }

    @Override
    public void sendLeaveAttribute(int threadId, String uri, String local, String qname2) throws SAXException {
        this.currentHandler.leaveAttribute(uri, local, qname2);
    }

    @Override
    public void sendLeaveElement(int threadId, String uri, String local, String qname2) throws SAXException {
        this.currentHandler.leaveElement(uri, local, qname2);
    }

    @Override
    public void sendText(int threadId, String value) throws SAXException {
        this.currentHandler.text(value);
    }

    public void redirectSubtree(ContentHandler child, String uri, String local, String qname2) throws SAXException {
        this.redirect = child;
        this.redirect.setDocumentLocator(this.locator);
        this.redirect.startDocument();
        for (int i = 0; i < this.namespaces.size(); i += 2) {
            this.redirect.startPrefixMapping((String)this.namespaces.get(i), (String)this.namespaces.get(i + 1));
        }
        this.redirect.startElement(uri, local, qname2, this.currentAtts);
        this.redirectionDepth = 1;
    }

    public String resolveNamespacePrefix(String prefix) {
        for (int i = this.nsEffectivePtr - 2; i >= 0; i -= 2) {
            if (!this.namespaces.get(i).equals(prefix)) continue;
            return (String)this.namespaces.get(i + 1);
        }
        if (prefix.equals("")) {
            return "";
        }
        if (prefix.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        return null;
    }

    protected void unexpectedX(String token) throws SAXException {
        throw new SAXParseException(MessageFormat.format("Unexpected {0} appears at line {1} column {2}", token, new Integer(this.getLocator().getLineNumber()), new Integer(this.getLocator().getColumnNumber())), this.getLocator());
    }

    private void printIndent() {
        for (int i = 0; i < this.indent; ++i) {
            System.out.print("  ");
        }
    }

    public void trace(String s2) {
        if (this.needIndent) {
            this.needIndent = false;
            this.printIndent();
        }
        System.out.print(s2);
    }

    public void traceln(String s2) {
        this.trace(s2);
        this.trace("\n");
        this.needIndent = true;
    }
}

