/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.bundle;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import dev.cel.bundle.AutoValue_CelEnvironment;
import dev.cel.bundle.AutoValue_CelEnvironment_ExtensionConfig;
import dev.cel.bundle.AutoValue_CelEnvironment_FunctionDecl;
import dev.cel.bundle.AutoValue_CelEnvironment_OverloadDecl;
import dev.cel.bundle.AutoValue_CelEnvironment_TypeDecl;
import dev.cel.bundle.AutoValue_CelEnvironment_VariableDecl;
import dev.cel.bundle.Cel;
import dev.cel.bundle.CelEnvironmentException;
import dev.cel.bundle.CelFactory;
import dev.cel.bundle.RequiredFieldsChecker;
import dev.cel.common.CelFunctionDecl;
import dev.cel.common.CelOptions;
import dev.cel.common.CelOverloadDecl;
import dev.cel.common.CelVarDecl;
import dev.cel.common.Source;
import dev.cel.common.types.CelType;
import dev.cel.common.types.CelTypeProvider;
import dev.cel.common.types.ListType;
import dev.cel.common.types.MapType;
import dev.cel.common.types.OptionalType;
import dev.cel.common.types.SimpleType;
import dev.cel.common.types.TypeParamType;
import dev.cel.compiler.CelCompiler;
import dev.cel.compiler.CelCompilerBuilder;
import dev.cel.extensions.CelExtensions;
import dev.cel.extensions.CelOptionalLibrary;
import dev.cel.runtime.CelRuntimeBuilder;
import java.util.Arrays;
import java.util.Optional;

@AutoValue
public abstract class CelEnvironment {
    @VisibleForTesting
    static final ImmutableMap<String, CanonicalCelExtension> CEL_EXTENSION_CONFIG_MAP = ImmutableMap.of("bindings", CanonicalCelExtension.BINDINGS, "encoders", CanonicalCelExtension.ENCODERS, "lists", CanonicalCelExtension.LISTS, "math", CanonicalCelExtension.MATH, "optional", CanonicalCelExtension.OPTIONAL, "protos", CanonicalCelExtension.PROTOS, "sets", CanonicalCelExtension.SETS, "strings", CanonicalCelExtension.STRINGS);

    public abstract Optional<Source> source();

    public abstract String name();

    public abstract String container();

    public abstract String description();

    public abstract Builder toBuilder();

    public abstract ImmutableSet<ExtensionConfig> extensions();

    public abstract ImmutableSet<VariableDecl> variables();

    public abstract ImmutableSet<FunctionDecl> functions();

    public static Builder newBuilder() {
        return new AutoValue_CelEnvironment.Builder().setName("").setDescription("").setContainer("").setVariables(ImmutableSet.of()).setFunctions(ImmutableSet.of());
    }

    public CelCompiler extend(CelCompiler celCompiler, CelOptions celOptions) throws CelEnvironmentException {
        try {
            CelTypeProvider celTypeProvider = celCompiler.getTypeProvider();
            CelCompilerBuilder compilerBuilder = celCompiler.toCompilerBuilder().setTypeProvider(celTypeProvider).setContainer(this.container()).addVarDeclarations(this.variables().stream().map(v -> v.toCelVarDecl(celTypeProvider)).collect(ImmutableList.toImmutableList())).addFunctionDeclarations(this.functions().stream().map(f -> f.toCelFunctionDecl(celTypeProvider)).collect(ImmutableList.toImmutableList()));
            if (!this.container().isEmpty()) {
                compilerBuilder.setContainer(this.container());
            }
            this.addAllCompilerExtensions(compilerBuilder, celOptions);
            return compilerBuilder.build();
        }
        catch (RuntimeException e) {
            throw new CelEnvironmentException(e.getMessage(), e);
        }
    }

    public Cel extend(Cel cel, CelOptions celOptions) throws CelEnvironmentException {
        try {
            CelCompiler celCompiler = this.extend((CelCompiler)cel, celOptions);
            CelRuntimeBuilder celRuntimeBuilder = cel.toRuntimeBuilder();
            this.addAllRuntimeExtensions(celRuntimeBuilder, celOptions);
            return CelFactory.combine(celCompiler, celRuntimeBuilder.build());
        }
        catch (RuntimeException e) {
            throw new CelEnvironmentException(e.getMessage(), e);
        }
    }

    private void addAllCompilerExtensions(CelCompilerBuilder celCompilerBuilder, CelOptions celOptions) {
        for (ExtensionConfig extensionConfig : this.extensions()) {
            CanonicalCelExtension extension = CelEnvironment.getExtensionOrThrow(extensionConfig.name());
            extension.addCompilerExtension(celCompilerBuilder, celOptions);
        }
    }

    private void addAllRuntimeExtensions(CelRuntimeBuilder celRuntimeBuilder, CelOptions celOptions) {
        for (ExtensionConfig extensionConfig : this.extensions()) {
            CanonicalCelExtension extension = CelEnvironment.getExtensionOrThrow(extensionConfig.name());
            extension.addRuntimeExtension(celRuntimeBuilder, celOptions);
        }
    }

    private static CanonicalCelExtension getExtensionOrThrow(String extensionName) {
        CanonicalCelExtension extension = CEL_EXTENSION_CONFIG_MAP.get(extensionName);
        if (extension == null) {
            throw new IllegalArgumentException("Unrecognized extension: " + extensionName);
        }
        return extension;
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract ImmutableSet.Builder<ExtensionConfig> extensionsBuilder();

        abstract Builder setSource(Optional<Source> var1);

        public abstract Builder setSource(Source var1);

        public abstract Builder setName(String var1);

        public abstract Builder setDescription(String var1);

        public abstract Builder setContainer(String var1);

        @CanIgnoreReturnValue
        public Builder addExtensions(ExtensionConfig ... extensions) {
            Preconditions.checkNotNull(extensions);
            return this.addExtensions(Arrays.asList(extensions));
        }

        @CanIgnoreReturnValue
        public Builder addExtensions(Iterable<ExtensionConfig> extensions) {
            Preconditions.checkNotNull(extensions);
            this.extensionsBuilder().addAll((Iterable)extensions);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setVariables(VariableDecl ... variables) {
            return this.setVariables(ImmutableSet.copyOf(variables));
        }

        public abstract Builder setVariables(ImmutableSet<VariableDecl> var1);

        @CanIgnoreReturnValue
        public Builder setFunctions(FunctionDecl ... functions) {
            return this.setFunctions(ImmutableSet.copyOf(functions));
        }

        public abstract Builder setFunctions(ImmutableSet<FunctionDecl> var1);

        @CheckReturnValue
        public abstract CelEnvironment build();
    }

    @AutoValue
    public static abstract class ExtensionConfig {
        public abstract String name();

        public abstract int version();

        public static Builder newBuilder() {
            return new AutoValue_CelEnvironment_ExtensionConfig.Builder().setVersion(0);
        }

        public static ExtensionConfig of(String name) {
            return ExtensionConfig.of(name, 0);
        }

        public static ExtensionConfig of(String name, int version) {
            return ExtensionConfig.newBuilder().setName(name).setVersion(version).build();
        }

        @AutoValue.Builder
        public static abstract class Builder
        implements RequiredFieldsChecker {
            public abstract Optional<String> name();

            public abstract Optional<Integer> version();

            public abstract Builder setName(String var1);

            public abstract Builder setVersion(int var1);

            @Override
            public ImmutableList<RequiredFieldsChecker.RequiredField> requiredFields() {
                return ImmutableList.of(RequiredFieldsChecker.RequiredField.of("name", this::name));
            }

            public abstract ExtensionConfig build();
        }
    }

    @VisibleForTesting
    static enum CanonicalCelExtension {
        BINDINGS((compilerBuilder, options) -> compilerBuilder.addLibraries(CelExtensions.bindings())),
        PROTOS((compilerBuilder, options) -> compilerBuilder.addLibraries(CelExtensions.protos())),
        ENCODERS((compilerBuilder, options) -> compilerBuilder.addLibraries(CelExtensions.encoders()), (runtimeBuilder, options) -> runtimeBuilder.addLibraries(CelExtensions.encoders())),
        MATH((compilerBuilder, options) -> compilerBuilder.addLibraries(CelExtensions.math(options)), (runtimeBuilder, options) -> runtimeBuilder.addLibraries(CelExtensions.math(options))),
        OPTIONAL((compilerBuilder, options) -> compilerBuilder.addLibraries(CelOptionalLibrary.INSTANCE), (runtimeBuilder, options) -> runtimeBuilder.addLibraries(CelOptionalLibrary.INSTANCE)),
        STRINGS((compilerBuilder, options) -> compilerBuilder.addLibraries(CelExtensions.strings()), (runtimeBuilder, options) -> runtimeBuilder.addLibraries(CelExtensions.strings())),
        SETS((compilerBuilder, options) -> compilerBuilder.addLibraries(CelExtensions.sets(options)), (runtimeBuilder, options) -> runtimeBuilder.addLibraries(CelExtensions.sets(options))),
        LISTS((compilerBuilder, options) -> compilerBuilder.addLibraries(CelExtensions.lists()), (runtimeBuilder, options) -> runtimeBuilder.addLibraries(CelExtensions.lists()));

        private final CompilerExtensionApplier compilerExtensionApplier;
        private final RuntimeExtensionApplier runtimeExtensionApplier;

        void addCompilerExtension(CelCompilerBuilder compilerBuilder, CelOptions options) {
            this.compilerExtensionApplier.apply(compilerBuilder, options);
        }

        void addRuntimeExtension(CelRuntimeBuilder runtimeBuilder, CelOptions options) {
            this.runtimeExtensionApplier.apply(runtimeBuilder, options);
        }

        private CanonicalCelExtension(CompilerExtensionApplier compilerExtensionApplier) {
            this(compilerExtensionApplier, (runtimeBuilder, options) -> {});
        }

        private CanonicalCelExtension(CompilerExtensionApplier compilerExtensionApplier, RuntimeExtensionApplier runtimeExtensionApplier) {
            this.compilerExtensionApplier = compilerExtensionApplier;
            this.runtimeExtensionApplier = runtimeExtensionApplier;
        }

        static interface CompilerExtensionApplier {
            public void apply(CelCompilerBuilder var1, CelOptions var2);
        }

        static interface RuntimeExtensionApplier {
            public void apply(CelRuntimeBuilder var1, CelOptions var2);
        }
    }

    @AutoValue
    public static abstract class FunctionDecl {
        public abstract String name();

        public abstract ImmutableSet<OverloadDecl> overloads();

        public static Builder newBuilder() {
            return new AutoValue_CelEnvironment_FunctionDecl.Builder();
        }

        public static FunctionDecl create(String name, ImmutableSet<OverloadDecl> overloads) {
            return FunctionDecl.newBuilder().setName(name).setOverloads(overloads).build();
        }

        public CelFunctionDecl toCelFunctionDecl(CelTypeProvider celTypeProvider) {
            return CelFunctionDecl.newFunctionDeclaration(this.name(), this.overloads().stream().map(o -> o.toCelOverloadDecl(celTypeProvider)).collect(ImmutableList.toImmutableList()));
        }

        @AutoValue.Builder
        public static abstract class Builder
        implements RequiredFieldsChecker {
            public abstract Optional<String> name();

            public abstract Optional<ImmutableSet<OverloadDecl>> overloads();

            public abstract Builder setName(String var1);

            public abstract Builder setOverloads(ImmutableSet<OverloadDecl> var1);

            @Override
            public ImmutableList<RequiredFieldsChecker.RequiredField> requiredFields() {
                return ImmutableList.of(RequiredFieldsChecker.RequiredField.of("name", this::name), RequiredFieldsChecker.RequiredField.of("overloads", this::overloads));
            }

            public abstract FunctionDecl build();
        }
    }

    @AutoValue
    public static abstract class VariableDecl {
        public abstract String name();

        public abstract TypeDecl type();

        public static Builder newBuilder() {
            return new AutoValue_CelEnvironment_VariableDecl.Builder();
        }

        public static VariableDecl create(String name, TypeDecl type) {
            return VariableDecl.newBuilder().setName(name).setType(type).build();
        }

        public CelVarDecl toCelVarDecl(CelTypeProvider celTypeProvider) {
            return CelVarDecl.newVarDeclaration(this.name(), this.type().toCelType(celTypeProvider));
        }

        @AutoValue.Builder
        public static abstract class Builder
        implements RequiredFieldsChecker {
            public abstract Optional<String> name();

            public abstract Optional<TypeDecl> type();

            public abstract Builder setName(String var1);

            public abstract Builder setType(TypeDecl var1);

            @Override
            public ImmutableList<RequiredFieldsChecker.RequiredField> requiredFields() {
                return ImmutableList.of(RequiredFieldsChecker.RequiredField.of("name", this::name), RequiredFieldsChecker.RequiredField.of("type", this::type));
            }

            public abstract VariableDecl build();
        }
    }

    @AutoValue
    public static abstract class TypeDecl {
        public abstract String name();

        public abstract ImmutableList<TypeDecl> params();

        public abstract boolean isTypeParam();

        public static TypeDecl create(String name) {
            return TypeDecl.newBuilder().setName(name).build();
        }

        public static Builder newBuilder() {
            return new AutoValue_CelEnvironment_TypeDecl.Builder().setIsTypeParam(false);
        }

        public CelType toCelType(CelTypeProvider celTypeProvider) {
            switch (this.name()) {
                case "list": {
                    if (this.params().size() != 1) {
                        throw new IllegalArgumentException("List type has unexpected param count: " + this.params().size());
                    }
                    CelType elementType = ((TypeDecl)this.params().get(0)).toCelType(celTypeProvider);
                    return ListType.create(elementType);
                }
                case "map": {
                    if (this.params().size() != 2) {
                        throw new IllegalArgumentException("Map type has unexpected param count: " + this.params().size());
                    }
                    CelType keyType = ((TypeDecl)this.params().get(0)).toCelType(celTypeProvider);
                    CelType valueType = ((TypeDecl)this.params().get(1)).toCelType(celTypeProvider);
                    return MapType.create(keyType, valueType);
                }
            }
            if (this.isTypeParam()) {
                return TypeParamType.create(this.name());
            }
            CelType simpleType2 = SimpleType.findByName(this.name()).orElse(null);
            if (simpleType2 != null) {
                return simpleType2;
            }
            if (this.name().equals("optional_type")) {
                Preconditions.checkState(this.params().size() == 1, "Optional type must have exactly 1 parameter. Found %s", this.params().size());
                return OptionalType.create(((TypeDecl)this.params().get(0)).toCelType(celTypeProvider));
            }
            return celTypeProvider.findType(this.name()).orElseThrow(() -> new IllegalArgumentException("Undefined type name: " + this.name()));
        }

        @AutoValue.Builder
        public static abstract class Builder
        implements RequiredFieldsChecker {
            public abstract Optional<String> name();

            public abstract Builder setName(String var1);

            abstract ImmutableList.Builder<TypeDecl> paramsBuilder();

            public abstract Builder setParams(ImmutableList<TypeDecl> var1);

            @CanIgnoreReturnValue
            public Builder addParams(TypeDecl ... params) {
                return this.addParams(Arrays.asList(params));
            }

            @CanIgnoreReturnValue
            public Builder addParams(Iterable<TypeDecl> params) {
                this.paramsBuilder().addAll((Iterable)Preconditions.checkNotNull(params));
                return this;
            }

            public abstract Builder setIsTypeParam(boolean var1);

            @Override
            public ImmutableList<RequiredFieldsChecker.RequiredField> requiredFields() {
                return ImmutableList.of(RequiredFieldsChecker.RequiredField.of("type_name", this::name));
            }

            @CheckReturnValue
            public abstract TypeDecl build();
        }
    }

    @AutoValue
    public static abstract class OverloadDecl {
        public abstract String id();

        public abstract Optional<TypeDecl> target();

        public abstract ImmutableList<TypeDecl> arguments();

        public abstract TypeDecl returnType();

        public static Builder newBuilder() {
            return new AutoValue_CelEnvironment_OverloadDecl.Builder().setArguments(ImmutableList.of());
        }

        public CelOverloadDecl toCelOverloadDecl(CelTypeProvider celTypeProvider) {
            CelOverloadDecl.Builder builder = CelOverloadDecl.newBuilder().setIsInstanceFunction(false).setOverloadId(this.id()).setResultType(this.returnType().toCelType(celTypeProvider));
            this.target().ifPresent(t2 -> builder.setIsInstanceFunction(true).addParameterTypes(t2.toCelType(celTypeProvider)));
            for (TypeDecl type : this.arguments()) {
                builder.addParameterTypes(type.toCelType(celTypeProvider));
            }
            return builder.build();
        }

        @AutoValue.Builder
        public static abstract class Builder
        implements RequiredFieldsChecker {
            public abstract Optional<String> id();

            public abstract Optional<TypeDecl> returnType();

            public abstract Builder setId(String var1);

            public abstract Builder setTarget(TypeDecl var1);

            abstract ImmutableList.Builder<TypeDecl> argumentsBuilder();

            public abstract Builder setArguments(ImmutableList<TypeDecl> var1);

            @CanIgnoreReturnValue
            public Builder addArguments(Iterable<TypeDecl> args) {
                this.argumentsBuilder().addAll((Iterable)Preconditions.checkNotNull(args));
                return this;
            }

            @CanIgnoreReturnValue
            public Builder addArguments(TypeDecl ... args) {
                return this.addArguments(Arrays.asList(args));
            }

            public abstract Builder setReturnType(TypeDecl var1);

            @Override
            public ImmutableList<RequiredFieldsChecker.RequiredField> requiredFields() {
                return ImmutableList.of(RequiredFieldsChecker.RequiredField.of("id", this::id), RequiredFieldsChecker.RequiredField.of("return", this::returnType));
            }

            @CheckReturnValue
            public abstract OverloadDecl build();
        }
    }
}

