/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.bundle;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.Message;
import dev.cel.bundle.Cel;
import dev.cel.bundle.CelBuilder;
import dev.cel.checker.CelCheckerBuilder;
import dev.cel.checker.ProtoTypeMask;
import dev.cel.checker.TypeProvider;
import dev.cel.common.CelAbstractSyntaxTree;
import dev.cel.common.CelFunctionDecl;
import dev.cel.common.CelOptions;
import dev.cel.common.CelSource;
import dev.cel.common.CelValidationResult;
import dev.cel.common.CelVarDecl;
import dev.cel.common.internal.EnvVisitable;
import dev.cel.common.internal.EnvVisitor;
import dev.cel.common.internal.FileDescriptorSetConverter;
import dev.cel.common.types.CelProtoTypes;
import dev.cel.common.types.CelType;
import dev.cel.common.types.CelTypeProvider;
import dev.cel.common.values.CelValueProvider;
import dev.cel.compiler.CelCompiler;
import dev.cel.compiler.CelCompilerBuilder;
import dev.cel.compiler.CelCompilerLibrary;
import dev.cel.expr.Decl;
import dev.cel.expr.Type;
import dev.cel.parser.CelMacro;
import dev.cel.parser.CelParserBuilder;
import dev.cel.parser.CelStandardMacro;
import dev.cel.runtime.CelEvaluationException;
import dev.cel.runtime.CelFunctionBinding;
import dev.cel.runtime.CelRuntime;
import dev.cel.runtime.CelRuntimeBuilder;
import dev.cel.runtime.CelRuntimeLibrary;
import java.util.Arrays;
import java.util.function.Function;

@Immutable
final class CelImpl
implements Cel,
EnvVisitable {
    private final Supplier<CelCompiler> compiler;
    private final Supplier<CelRuntime> runtime;

    @Override
    public CelValidationResult parse(String expression, String description) {
        return this.compiler.get().parse(expression, description);
    }

    @Override
    public CelValidationResult parse(CelSource source2) {
        return this.compiler.get().parse(source2);
    }

    @Override
    public CelValidationResult check(CelAbstractSyntaxTree ast) {
        return this.compiler.get().check(ast);
    }

    @Override
    public CelTypeProvider getTypeProvider() {
        return this.compiler.get().getTypeProvider();
    }

    @Override
    public CelRuntime.Program createProgram(CelAbstractSyntaxTree ast) throws CelEvaluationException {
        return this.runtime.get().createProgram(ast);
    }

    @Override
    public void accept(EnvVisitor envVisitor) {
        CelCompiler celCompiler = this.compiler.get();
        if (celCompiler instanceof EnvVisitable) {
            ((EnvVisitable)((Object)celCompiler)).accept(envVisitor);
        }
    }

    @Override
    public CelBuilder toCelBuilder() {
        return CelImpl.newBuilder(this.toCompilerBuilder(), this.toRuntimeBuilder());
    }

    @Override
    public CelParserBuilder toParserBuilder() {
        return this.compiler.get().toParserBuilder();
    }

    @Override
    public CelCheckerBuilder toCheckerBuilder() {
        return this.compiler.get().toCheckerBuilder();
    }

    @Override
    public CelCompilerBuilder toCompilerBuilder() {
        return this.compiler.get().toCompilerBuilder();
    }

    @Override
    public CelRuntimeBuilder toRuntimeBuilder() {
        return this.runtime.get().toRuntimeBuilder();
    }

    static CelImpl combine(CelCompiler compiler, CelRuntime runtime) {
        return new CelImpl(Suppliers.memoize(() -> compiler), Suppliers.memoize(() -> runtime));
    }

    static CelBuilder newBuilder(CelCompilerBuilder compilerBuilder, CelRuntimeBuilder celRuntimeBuilder) {
        return new Builder(compilerBuilder, celRuntimeBuilder);
    }

    private CelImpl(Supplier<CelCompiler> compiler, Supplier<CelRuntime> runtime) {
        this.compiler = compiler;
        this.runtime = runtime;
    }

    public static final class Builder
    implements CelBuilder {
        private final CelCompilerBuilder compilerBuilder;
        private final CelRuntimeBuilder runtimeBuilder;

        private Builder(CelCompilerBuilder celCompilerBuilder, CelRuntimeBuilder celRuntimeBuilder) {
            this.compilerBuilder = celCompilerBuilder;
            this.runtimeBuilder = celRuntimeBuilder;
        }

        @Override
        public CelBuilder setOptions(CelOptions options) {
            this.compilerBuilder.setOptions(options);
            this.runtimeBuilder.setOptions(options);
            return this;
        }

        @Override
        public CelBuilder setStandardMacros(CelStandardMacro ... macros) {
            this.compilerBuilder.setStandardMacros(macros);
            return this;
        }

        @Override
        public CelBuilder setStandardMacros(Iterable<CelStandardMacro> macros) {
            this.compilerBuilder.setStandardMacros(macros);
            return this;
        }

        @Override
        public CelBuilder addMacros(CelMacro ... macros) {
            Preconditions.checkNotNull(macros);
            return this.addMacros(Arrays.asList(macros));
        }

        @Override
        public CelBuilder addMacros(Iterable<CelMacro> macros) {
            Preconditions.checkNotNull(macros);
            this.compilerBuilder.addMacros(macros);
            return this;
        }

        @Override
        public CelBuilder setContainer(String container) {
            this.compilerBuilder.setContainer(container);
            return this;
        }

        @Override
        public CelBuilder addVar(String name, Type type) {
            this.compilerBuilder.addVar(name, type);
            return this;
        }

        @Override
        public CelBuilder addVar(String name, CelType type) {
            this.compilerBuilder.addVar(name, type);
            return this;
        }

        @Override
        public CelBuilder addDeclarations(Decl ... declarations) {
            this.compilerBuilder.addDeclarations(declarations);
            return this;
        }

        @Override
        public CelBuilder addDeclarations(Iterable<Decl> declarations) {
            this.compilerBuilder.addDeclarations(declarations);
            return this;
        }

        @Override
        public CelBuilder addFunctionDeclarations(CelFunctionDecl ... celFunctionDecls) {
            this.compilerBuilder.addFunctionDeclarations(celFunctionDecls);
            return this;
        }

        @Override
        public CelBuilder addFunctionDeclarations(Iterable<CelFunctionDecl> celFunctionDecls) {
            this.compilerBuilder.addFunctionDeclarations(celFunctionDecls);
            return this;
        }

        @Override
        public CelBuilder addVarDeclarations(CelVarDecl ... celVarDecls) {
            this.compilerBuilder.addVarDeclarations(celVarDecls);
            return this;
        }

        @Override
        public CelBuilder addVarDeclarations(Iterable<CelVarDecl> celVarDecls) {
            this.compilerBuilder.addVarDeclarations(celVarDecls);
            return this;
        }

        @Override
        public CelBuilder addProtoTypeMasks(ProtoTypeMask ... typeMasks) {
            this.compilerBuilder.addProtoTypeMasks(typeMasks);
            return this;
        }

        @Override
        public CelBuilder addProtoTypeMasks(Iterable<ProtoTypeMask> typeMasks) {
            this.compilerBuilder.addProtoTypeMasks(typeMasks);
            return this;
        }

        @Override
        public CelBuilder addFunctionBindings(CelFunctionBinding ... bindings) {
            this.runtimeBuilder.addFunctionBindings(bindings);
            return this;
        }

        @Override
        public CelBuilder addFunctionBindings(Iterable<CelFunctionBinding> bindings) {
            this.runtimeBuilder.addFunctionBindings(bindings);
            return this;
        }

        @Override
        public CelBuilder setResultType(CelType resultType) {
            Preconditions.checkNotNull(resultType);
            return this.setProtoResultType(CelProtoTypes.celTypeToType(resultType));
        }

        @Override
        public CelBuilder setProtoResultType(Type resultType) {
            this.compilerBuilder.setProtoResultType(resultType);
            return this;
        }

        @Override
        public CelBuilder setTypeFactory(Function<String, Message.Builder> typeFactory) {
            this.runtimeBuilder.setTypeFactory(typeFactory);
            return this;
        }

        @Override
        public CelBuilder setValueProvider(CelValueProvider celValueProvider) {
            this.runtimeBuilder.setValueProvider(celValueProvider);
            return this;
        }

        @Override
        @Deprecated
        public Builder setTypeProvider(TypeProvider typeProvider) {
            this.compilerBuilder.setTypeProvider(typeProvider);
            return this;
        }

        @Override
        public CelBuilder setTypeProvider(CelTypeProvider celTypeProvider) {
            this.compilerBuilder.setTypeProvider(celTypeProvider);
            return this;
        }

        @Override
        public CelBuilder addMessageTypes(Descriptors.Descriptor ... descriptors) {
            this.compilerBuilder.addMessageTypes(descriptors);
            this.runtimeBuilder.addMessageTypes(descriptors);
            return this;
        }

        @Override
        public CelBuilder addMessageTypes(Iterable<Descriptors.Descriptor> descriptors) {
            this.compilerBuilder.addMessageTypes(descriptors);
            this.runtimeBuilder.addMessageTypes(descriptors);
            return this;
        }

        @Override
        public CelBuilder addFileTypes(Descriptors.FileDescriptor ... fileDescriptors) {
            this.compilerBuilder.addFileTypes(fileDescriptors);
            this.runtimeBuilder.addFileTypes(fileDescriptors);
            return this;
        }

        @Override
        public CelBuilder addFileTypes(Iterable<Descriptors.FileDescriptor> fileDescriptors) {
            this.compilerBuilder.addFileTypes(fileDescriptors);
            this.runtimeBuilder.addFileTypes(fileDescriptors);
            return this;
        }

        @Override
        public CelBuilder addFileTypes(DescriptorProtos.FileDescriptorSet fileDescriptorSet) {
            ImmutableSet<Descriptors.FileDescriptor> fileDescriptors = FileDescriptorSetConverter.convert(fileDescriptorSet);
            this.compilerBuilder.addFileTypes(fileDescriptors);
            this.runtimeBuilder.addFileTypes(fileDescriptors);
            return this;
        }

        @Override
        public CelBuilder setStandardEnvironmentEnabled(boolean value) {
            this.compilerBuilder.setStandardEnvironmentEnabled(value);
            this.runtimeBuilder.setStandardEnvironmentEnabled(value);
            return this;
        }

        @Override
        public CelBuilder addCompilerLibraries(CelCompilerLibrary ... libraries) {
            Preconditions.checkNotNull(libraries);
            return this.addCompilerLibraries(Arrays.asList(libraries));
        }

        @Override
        public CelBuilder addCompilerLibraries(Iterable<CelCompilerLibrary> libraries) {
            Preconditions.checkNotNull(libraries);
            this.compilerBuilder.addLibraries(libraries);
            return this;
        }

        @Override
        public CelBuilder addRuntimeLibraries(CelRuntimeLibrary ... libraries) {
            Preconditions.checkNotNull(libraries);
            return this.addRuntimeLibraries(Arrays.asList(libraries));
        }

        @Override
        public CelBuilder addRuntimeLibraries(Iterable<CelRuntimeLibrary> libraries) {
            Preconditions.checkNotNull(libraries);
            this.runtimeBuilder.addLibraries(libraries);
            return this;
        }

        @Override
        public CelBuilder setExtensionRegistry(ExtensionRegistry extensionRegistry) {
            Preconditions.checkNotNull(extensionRegistry);
            this.runtimeBuilder.setExtensionRegistry(extensionRegistry);
            return this;
        }

        @Override
        public Cel build() {
            return new CelImpl(Suppliers.memoize(this.compilerBuilder::build), Suppliers.memoize(this.runtimeBuilder::build));
        }
    }
}

