/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.checker;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.Immutable;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import dev.cel.checker.CelChecker;
import dev.cel.checker.CelCheckerBuilder;
import dev.cel.checker.CelCheckerLibrary;
import dev.cel.checker.CelIdentDecl;
import dev.cel.checker.CelStandardDeclarations;
import dev.cel.checker.Env;
import dev.cel.checker.ExprChecker;
import dev.cel.checker.ProtoTypeMask;
import dev.cel.checker.ProtoTypeMaskTypeProvider;
import dev.cel.checker.TypeProvider;
import dev.cel.checker.TypeProviderLegacyImpl;
import dev.cel.common.CelAbstractSyntaxTree;
import dev.cel.common.CelDescriptorUtil;
import dev.cel.common.CelFunctionDecl;
import dev.cel.common.CelIssue;
import dev.cel.common.CelOptions;
import dev.cel.common.CelOverloadDecl;
import dev.cel.common.CelSource;
import dev.cel.common.CelSourceLocation;
import dev.cel.common.CelValidationResult;
import dev.cel.common.CelVarDecl;
import dev.cel.common.annotations.Internal;
import dev.cel.common.ast.CelExprConverter;
import dev.cel.common.internal.EnvVisitable;
import dev.cel.common.internal.EnvVisitor;
import dev.cel.common.internal.Errors;
import dev.cel.common.types.CelProtoTypes;
import dev.cel.common.types.CelType;
import dev.cel.common.types.CelTypeProvider;
import dev.cel.common.types.ProtoMessageTypeProvider;
import dev.cel.expr.Decl;
import dev.cel.expr.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeSet;

@Immutable
@Internal
public final class CelCheckerLegacyImpl
implements CelChecker,
EnvVisitable {
    private final CelOptions celOptions;
    private final String container;
    private final ImmutableSet<CelIdentDecl> identDeclarations;
    private final ImmutableSet<CelFunctionDecl> functionDeclarations;
    private final Optional<CelType> expectedResultType;
    private final TypeProvider typeProvider;
    private final CelTypeProvider celTypeProvider;
    private final boolean standardEnvironmentEnabled;
    private final CelStandardDeclarations overriddenStandardDeclarations;
    private final Builder checkerBuilder;

    @Override
    public CelValidationResult check(CelAbstractSyntaxTree ast) {
        CelSource source2 = ast.getSource();
        Errors errors = new Errors(source2.getDescription(), source2.getContent().toString());
        Env env = this.getEnv(errors);
        if (errors.getErrorCount() > 0) {
            return new CelValidationResult(source2, CelCheckerLegacyImpl.errorsToIssues(errors));
        }
        CelAbstractSyntaxTree checkedAst = ExprChecker.typecheck(env, this.container, ast, this.expectedResultType);
        if (errors.getErrorCount() > 0) {
            return new CelValidationResult(source2, CelCheckerLegacyImpl.errorsToIssues(errors));
        }
        return new CelValidationResult(checkedAst, ImmutableList.of());
    }

    @Override
    public CelTypeProvider getTypeProvider() {
        return this.celTypeProvider;
    }

    @Override
    public CelCheckerBuilder toCheckerBuilder() {
        return new Builder(this.checkerBuilder);
    }

    @Override
    public void accept(EnvVisitor envVisitor) {
        Errors errors = new Errors("", "");
        Env env = this.getEnv(errors);
        for (int i = env.scopeDepth(); i >= 0; --i) {
            Env.DeclGroup declGroup = env.getDeclGroup(i);
            TreeSet<String> names = new TreeSet<String>();
            names.addAll(declGroup.getIdents().keySet());
            names.addAll(declGroup.getFunctions().keySet());
            for (String name : names) {
                CelIdentDecl ident = declGroup.getIdent(name);
                CelFunctionDecl func = declGroup.getFunction(name);
                ArrayList<Decl> decls = new ArrayList<Decl>();
                if (ident != null) {
                    decls.add(CelIdentDecl.celIdentToDecl(ident));
                }
                if (func != null) {
                    decls.add(CelFunctionDecl.celFunctionDeclToDecl(func));
                }
                envVisitor.visitDecl(name, decls);
            }
        }
    }

    private Env getEnv(Errors errors) {
        Env env = this.standardEnvironmentEnabled ? Env.standard(errors, this.typeProvider, this.celOptions) : (this.overriddenStandardDeclarations != null ? Env.standard(this.overriddenStandardDeclarations, errors, this.typeProvider, this.celOptions) : Env.unconfigured(errors, this.typeProvider, this.celOptions));
        this.identDeclarations.forEach(env::add);
        this.functionDeclarations.forEach(env::add);
        return env;
    }

    public static CelCheckerBuilder newBuilder() {
        return new Builder();
    }

    private CelCheckerLegacyImpl(CelOptions celOptions, String container, ImmutableSet<CelIdentDecl> identDeclarations, ImmutableSet<CelFunctionDecl> functionDeclarations, Optional<CelType> expectedResultType, TypeProvider typeProvider, CelTypeProvider celTypeProvider, boolean standardEnvironmentEnabled, CelStandardDeclarations overriddenStandardDeclarations, Builder checkerBuilder) {
        this.celOptions = celOptions;
        this.container = container;
        this.identDeclarations = identDeclarations;
        this.functionDeclarations = functionDeclarations;
        this.expectedResultType = expectedResultType;
        this.typeProvider = typeProvider;
        this.celTypeProvider = celTypeProvider;
        this.standardEnvironmentEnabled = standardEnvironmentEnabled;
        this.overriddenStandardDeclarations = overriddenStandardDeclarations;
        this.checkerBuilder = new Builder(checkerBuilder);
    }

    private static ImmutableList<CelIssue> errorsToIssues(Errors errors) {
        ImmutableList<Errors.Error> errorList = errors.getErrors();
        CelIssue.Builder issueBuilder = CelIssue.newBuilder().setSeverity(CelIssue.Severity.ERROR);
        return errorList.stream().map(e -> {
            Errors.SourceLocation loc = errors.getPositionLocation(e.position());
            CelSourceLocation newLoc = CelSourceLocation.of(loc.line(), loc.column() - 1);
            return issueBuilder.setExprId(e.exprId()).setMessage(e.rawMessage()).setSourceLocation(newLoc).build();
        }).collect(ImmutableList.toImmutableList());
    }

    public static final class Builder
    implements CelCheckerBuilder {
        private final ImmutableSet.Builder<CelIdentDecl> identDeclarations;
        private final ImmutableSet.Builder<CelFunctionDecl> functionDeclarations;
        private final ImmutableSet.Builder<ProtoTypeMask> protoTypeMasks;
        private final ImmutableSet.Builder<Descriptors.Descriptor> messageTypes;
        private final ImmutableSet.Builder<Descriptors.FileDescriptor> fileTypes;
        private final ImmutableSet.Builder<CelCheckerLibrary> celCheckerLibraries;
        private CelOptions celOptions;
        private String container;
        private CelType expectedResultType;
        private TypeProvider customTypeProvider;
        private CelTypeProvider celTypeProvider;
        private boolean standardEnvironmentEnabled;
        private CelStandardDeclarations standardDeclarations;

        @Override
        public CelCheckerBuilder setOptions(CelOptions celOptions) {
            this.celOptions = Preconditions.checkNotNull(celOptions);
            return this;
        }

        @Override
        public CelCheckerBuilder setContainer(String container) {
            Preconditions.checkNotNull(container);
            this.container = container;
            return this;
        }

        @Override
        public CelCheckerBuilder addDeclarations(Decl ... declarations) {
            Preconditions.checkNotNull(declarations);
            return this.addDeclarations(Arrays.asList(declarations));
        }

        @Override
        public CelCheckerBuilder addDeclarations(Iterable<Decl> declarations) {
            Preconditions.checkNotNull(declarations);
            block4: for (Decl decl : declarations) {
                switch (decl.getDeclKindCase()) {
                    case IDENT: {
                        CelIdentDecl.Builder identBuilder = CelIdentDecl.newBuilder().setName(decl.getName()).setType(CelProtoTypes.typeToCelType(decl.getIdent().getType())).setDoc(decl.getIdent().getDoc());
                        if (decl.getIdent().hasValue()) {
                            identBuilder.setConstant(CelExprConverter.exprConstantToCelConstant(decl.getIdent().getValue()));
                        }
                        this.identDeclarations.add((Object)identBuilder.build());
                        continue block4;
                    }
                    case FUNCTION: {
                        this.addFunctionDeclarations(CelFunctionDecl.newFunctionDeclaration(decl.getName(), decl.getFunction().getOverloadsList().stream().map(CelOverloadDecl::overloadToCelOverload).collect(ImmutableList.toImmutableList())));
                        continue block4;
                    }
                }
                throw new IllegalArgumentException("unexpected decl kind: " + decl.getDeclKindCase());
            }
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public CelCheckerBuilder addFunctionDeclarations(CelFunctionDecl ... celFunctionDecls) {
            Preconditions.checkNotNull(celFunctionDecls);
            return this.addFunctionDeclarations(Arrays.asList(celFunctionDecls));
        }

        @Override
        public CelCheckerBuilder addFunctionDeclarations(Iterable<CelFunctionDecl> celFunctionDecls) {
            Preconditions.checkNotNull(celFunctionDecls);
            this.functionDeclarations.addAll((Iterable)celFunctionDecls);
            return this;
        }

        @Override
        public CelCheckerBuilder addVarDeclarations(CelVarDecl ... celVarDecls) {
            Preconditions.checkNotNull(celVarDecls);
            return this.addVarDeclarations(Arrays.asList(celVarDecls));
        }

        @Override
        public CelCheckerBuilder addVarDeclarations(Iterable<CelVarDecl> celVarDecls) {
            Preconditions.checkNotNull(celVarDecls);
            for (CelVarDecl celVarDecl : celVarDecls) {
                this.identDeclarations.add((Object)CelIdentDecl.newIdentDeclaration(celVarDecl.name(), celVarDecl.type()));
            }
            return this;
        }

        @Override
        public CelCheckerBuilder addProtoTypeMasks(ProtoTypeMask ... typeMasks) {
            Preconditions.checkNotNull(typeMasks);
            return this.addProtoTypeMasks(Arrays.asList(typeMasks));
        }

        @Override
        public CelCheckerBuilder addProtoTypeMasks(Iterable<ProtoTypeMask> typeMasks) {
            Preconditions.checkNotNull(typeMasks);
            this.protoTypeMasks.addAll((Iterable)typeMasks);
            return this;
        }

        @Override
        public CelCheckerBuilder setResultType(CelType resultType) {
            Preconditions.checkNotNull(resultType);
            this.expectedResultType = resultType;
            return this;
        }

        @Override
        public CelCheckerBuilder setProtoResultType(Type resultType) {
            Preconditions.checkNotNull(resultType);
            return this.setResultType(CelProtoTypes.typeToCelType(resultType));
        }

        @Override
        @Deprecated
        public CelCheckerBuilder setTypeProvider(TypeProvider typeProvider) {
            this.customTypeProvider = typeProvider;
            return this;
        }

        @Override
        public CelCheckerBuilder setTypeProvider(CelTypeProvider celTypeProvider) {
            this.celTypeProvider = celTypeProvider;
            return this;
        }

        @Override
        public CelCheckerBuilder addMessageTypes(Descriptors.Descriptor ... descriptors) {
            return this.addMessageTypes(Arrays.asList(Preconditions.checkNotNull(descriptors)));
        }

        @Override
        public CelCheckerBuilder addMessageTypes(Iterable<Descriptors.Descriptor> descriptors) {
            this.messageTypes.addAll((Iterable)Preconditions.checkNotNull(descriptors));
            return this;
        }

        @Override
        public CelCheckerBuilder addFileTypes(Descriptors.FileDescriptor ... fileDescriptors) {
            return this.addFileTypes(Arrays.asList(Preconditions.checkNotNull(fileDescriptors)));
        }

        @Override
        public CelCheckerBuilder addFileTypes(Iterable<Descriptors.FileDescriptor> fileDescriptors) {
            this.fileTypes.addAll((Iterable)Preconditions.checkNotNull(fileDescriptors));
            return this;
        }

        @Override
        public CelCheckerBuilder addFileTypes(DescriptorProtos.FileDescriptorSet fileDescriptorSet) {
            Preconditions.checkNotNull(fileDescriptorSet);
            return this.addFileTypes(CelDescriptorUtil.getFileDescriptorsFromFileDescriptorSet(fileDescriptorSet));
        }

        @Override
        public CelCheckerBuilder setStandardEnvironmentEnabled(boolean value) {
            this.standardEnvironmentEnabled = value;
            return this;
        }

        @Override
        public CelCheckerBuilder setStandardDeclarations(CelStandardDeclarations standardDeclarations) {
            this.standardDeclarations = Preconditions.checkNotNull(standardDeclarations);
            return this;
        }

        @Override
        public CelCheckerBuilder addLibraries(CelCheckerLibrary ... libraries) {
            Preconditions.checkNotNull(libraries);
            return this.addLibraries(Arrays.asList(libraries));
        }

        @Override
        public CelCheckerBuilder addLibraries(Iterable<? extends CelCheckerLibrary> libraries) {
            Preconditions.checkNotNull(libraries);
            this.celCheckerLibraries.addAll(libraries);
            return this;
        }

        @VisibleForTesting
        ImmutableSet.Builder<CelFunctionDecl> getFunctionDecls() {
            return this.functionDeclarations;
        }

        @VisibleForTesting
        ImmutableSet.Builder<CelIdentDecl> getIdentDecls() {
            return this.identDeclarations;
        }

        @VisibleForTesting
        ImmutableSet.Builder<ProtoTypeMask> getProtoTypeMasks() {
            return this.protoTypeMasks;
        }

        @VisibleForTesting
        ImmutableSet.Builder<Descriptors.Descriptor> getMessageTypes() {
            return this.messageTypes;
        }

        @VisibleForTesting
        ImmutableSet.Builder<Descriptors.FileDescriptor> getFileTypes() {
            return this.fileTypes;
        }

        @VisibleForTesting
        ImmutableSet.Builder<CelCheckerLibrary> getCheckerLibraries() {
            return this.celCheckerLibraries;
        }

        @Override
        @CheckReturnValue
        public CelCheckerLegacyImpl build() {
            if (this.standardEnvironmentEnabled && this.standardDeclarations != null) {
                throw new IllegalArgumentException("setStandardEnvironmentEnabled must be set to false to override standard declarations.");
            }
            this.celCheckerLibraries.build().forEach(celLibrary -> celLibrary.setCheckerOptions(this));
            ImmutableCollection fileTypeSet = this.fileTypes.build();
            ImmutableCollection messageTypeSet = this.messageTypes.build();
            if (!messageTypeSet.isEmpty()) {
                fileTypeSet = ((ImmutableSet.Builder)((ImmutableSet.Builder)new ImmutableSet.Builder().addAll((Iterable)fileTypeSet)).addAll((Iterable)messageTypeSet.stream().map(Descriptors.Descriptor::getFile).collect(ImmutableSet.toImmutableSet()))).build();
            }
            CelTypeProvider messageTypeProvider = new ProtoMessageTypeProvider(CelDescriptorUtil.getAllDescriptorsFromFileDescriptor(fileTypeSet, this.celOptions.resolveTypeDependencies()));
            if (this.celTypeProvider != null && fileTypeSet.isEmpty()) {
                messageTypeProvider = this.celTypeProvider;
            } else if (this.celTypeProvider != null) {
                messageTypeProvider = new CelTypeProvider.CombinedCelTypeProvider(ImmutableList.of(this.celTypeProvider, messageTypeProvider));
            }
            ImmutableCollection identDeclarationSet = this.identDeclarations.build();
            ImmutableCollection protoTypeMaskSet = this.protoTypeMasks.build();
            if (!protoTypeMaskSet.isEmpty()) {
                ProtoTypeMaskTypeProvider protoTypeMaskTypeProvider = new ProtoTypeMaskTypeProvider(messageTypeProvider, (ImmutableSet<ProtoTypeMask>)protoTypeMaskSet);
                identDeclarationSet = ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll((Iterable)identDeclarationSet)).addAll(protoTypeMaskTypeProvider.computeDeclsFromProtoTypeMasks())).build();
                messageTypeProvider = protoTypeMaskTypeProvider;
            }
            TypeProvider legacyProvider = new TypeProviderLegacyImpl(messageTypeProvider);
            if (this.customTypeProvider != null) {
                legacyProvider = new TypeProvider.CombinedTypeProvider(ImmutableList.of(this.customTypeProvider, legacyProvider));
            }
            return new CelCheckerLegacyImpl(this.celOptions, this.container, (ImmutableSet)identDeclarationSet, (ImmutableSet)this.functionDeclarations.build(), Optional.fromNullable(this.expectedResultType), legacyProvider, messageTypeProvider, this.standardEnvironmentEnabled, this.standardDeclarations, this);
        }

        private Builder() {
            this.celOptions = CelOptions.newBuilder().build();
            this.identDeclarations = ImmutableSet.builder();
            this.functionDeclarations = ImmutableSet.builder();
            this.fileTypes = ImmutableSet.builder();
            this.messageTypes = ImmutableSet.builder();
            this.protoTypeMasks = ImmutableSet.builder();
            this.celCheckerLibraries = ImmutableSet.builder();
            this.container = "";
        }

        private Builder(Builder builder) {
            this.celOptions = builder.celOptions;
            this.celTypeProvider = builder.celTypeProvider;
            this.container = builder.container;
            this.customTypeProvider = builder.customTypeProvider;
            this.expectedResultType = builder.expectedResultType;
            this.standardEnvironmentEnabled = builder.standardEnvironmentEnabled;
            this.functionDeclarations = Builder.deepCopy(builder.functionDeclarations);
            this.identDeclarations = Builder.deepCopy(builder.identDeclarations);
            this.fileTypes = Builder.deepCopy(builder.fileTypes);
            this.messageTypes = Builder.deepCopy(builder.messageTypes);
            this.protoTypeMasks = Builder.deepCopy(builder.protoTypeMasks);
            this.celCheckerLibraries = Builder.deepCopy(builder.celCheckerLibraries);
        }

        private static <T> ImmutableSet.Builder<T> deepCopy(ImmutableSet.Builder<T> builderToCopy) {
            ImmutableSet.Builder newBuilder = ImmutableSet.builder();
            newBuilder.addAll((Iterable)builderToCopy.build());
            return newBuilder;
        }
    }
}

