/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.Immutable;
import dev.cel.common.AutoValue_CelAbstractSyntaxTree;
import dev.cel.common.CelSource;
import dev.cel.common.annotations.Internal;
import dev.cel.common.ast.CelConstant;
import dev.cel.common.ast.CelExpr;
import dev.cel.common.ast.CelReference;
import dev.cel.common.types.CelType;
import dev.cel.common.types.SimpleType;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;

@Immutable
@AutoValue
public abstract class CelAbstractSyntaxTree {
    abstract CelSource celSource();

    abstract CelExpr celExpr();

    abstract ImmutableMap<Long, CelReference> references();

    abstract ImmutableMap<Long, CelType> types();

    public static CelAbstractSyntaxTree newParsedAst(CelExpr celExpr, CelSource celSource) {
        return new AutoValue_CelAbstractSyntaxTree(celSource, celExpr, ImmutableMap.of(), ImmutableMap.of());
    }

    @Internal
    public static CelAbstractSyntaxTree newCheckedAst(CelExpr celExpr, CelSource celSource, Map<Long, CelReference> references, Map<Long, CelType> types) {
        return new AutoValue_CelAbstractSyntaxTree(celSource, celExpr, ImmutableMap.copyOf(references), ImmutableMap.copyOf(types));
    }

    public CelExpr getExpr() {
        return this.celExpr();
    }

    public boolean isChecked() {
        return !this.types().isEmpty();
    }

    public CelType getResultType() {
        return this.isChecked() ? this.getType(this.getExpr().id()).get() : SimpleType.DYN;
    }

    public CelSource getSource() {
        return this.celSource();
    }

    public Optional<CelType> getType(long exprId) {
        return Optional.ofNullable(this.types().get(exprId));
    }

    public ImmutableMap<Long, CelType> getTypeMap() {
        return this.types();
    }

    public Optional<CelReference> getReference(long exprId) {
        return Optional.ofNullable(this.references().get(exprId));
    }

    public ImmutableMap<Long, CelReference> getReferenceMap() {
        return this.references();
    }

    public CelReference getReferenceOrThrow(long exprId) {
        return this.getReference(exprId).orElseThrow(() -> new NoSuchElementException("Expr Id not found: " + exprId));
    }

    Optional<CelConstant> findEnumValue(long exprId) {
        CelReference ref = this.references().get(exprId);
        return ref != null ? ref.value() : Optional.empty();
    }

    Optional<ImmutableList<String>> findOverloadIDs(long exprId) {
        CelReference ref = this.references().get(exprId);
        return ref != null && !ref.value().isPresent() ? Optional.of(ref.overloadIds()) : Optional.empty();
    }
}

