/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common;

import com.google.auto.value.AutoValue;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.Immutable;
import dev.cel.common.AutoValue_CelIssue;
import dev.cel.common.CelSourceLocation;
import dev.cel.common.Source;
import dev.cel.common.internal.SafeStringFormatter;
import java.util.Collection;
import java.util.Optional;
import java.util.PrimitiveIterator;

@Immutable
@AutoValue
public abstract class CelIssue {
    private static final Joiner JOINER = Joiner.on('\n');
    private static final char DOT = '.';
    private static final char HAT = '^';
    private static final char WIDE_DOT = '\uff0e';
    private static final char WIDE_HAT = '\uff3e';

    CelIssue() {
    }

    public abstract Severity getSeverity();

    public abstract CelSourceLocation getSourceLocation();

    public abstract String getMessage();

    public abstract long getExprId();

    public static Builder newBuilder() {
        return new AutoValue_CelIssue.Builder();
    }

    public static CelIssue formatError(long exprId, CelSourceLocation sourceLocation, String message) {
        return CelIssue.newBuilder().setExprId(exprId).setSeverity(Severity.ERROR).setSourceLocation(sourceLocation).setMessage(message).build();
    }

    public static CelIssue formatError(CelSourceLocation sourceLocation, String message) {
        return CelIssue.formatError(0L, sourceLocation, message);
    }

    public static CelIssue formatError(int line, int column, String message) {
        return CelIssue.formatError(CelSourceLocation.of(line, column), message);
    }

    public static String toDisplayString(Collection<CelIssue> issues, Source source2) {
        return JOINER.join(issues.stream().map(iss -> iss.toDisplayString(source2)).collect(ImmutableList.toImmutableList()));
    }

    public String toDisplayString(Source source2) {
        Optional<String> optionalSnippet;
        String result = SafeStringFormatter.format("%s: %s:%d:%d: %s", new Object[]{this.getSeverity(), source2.getDescription(), this.getSourceLocation().getLine(), this.getSourceLocation().getColumn() + 1, this.getMessage()});
        if (!CelSourceLocation.NONE.equals(this.getSourceLocation()) && (optionalSnippet = source2.getSnippet(this.getSourceLocation().getLine())).isPresent()) {
            StringBuilder builder = new StringBuilder();
            String snippet = optionalSnippet.get().replace('\t', ' ');
            builder.append(result).append("\n | ").append(snippet).append("\n | ");
            PrimitiveIterator.OfInt codePoints = snippet.codePoints().iterator();
            for (int index = 0; index < this.getSourceLocation().getColumn() && codePoints.hasNext(); ++index) {
                int codePoint = codePoints.nextInt();
                if (codePoint > 127) {
                    builder.append('\uff0e');
                    continue;
                }
                builder.append('.');
            }
            if (codePoints.hasNext() && codePoints.nextInt() > 127) {
                builder.append('\uff3e');
            } else {
                builder.append('^');
            }
            result = builder.toString();
        }
        return result;
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setSeverity(Severity var1);

        public abstract Builder setSourceLocation(CelSourceLocation var1);

        public abstract Builder setMessage(String var1);

        public abstract Builder setExprId(long var1);

        @CheckReturnValue
        public abstract CelIssue build();
    }

    public static enum Severity {
        ERROR,
        WARNING,
        INFORMATION,
        DEPRECATED;

    }
}

