/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.cel.common.CelSource;
import dev.cel.common.ast.CelExpr;
import dev.cel.common.ast.CelMutableExpr;
import dev.cel.common.ast.CelMutableExprConverter;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class CelMutableSource {
    private String description;
    private final Map<Long, CelMutableExpr> macroCalls;
    private final Set<CelSource.Extension> extensions;

    @CanIgnoreReturnValue
    public CelMutableSource addMacroCalls(long exprId, CelMutableExpr expr) {
        this.macroCalls.put(exprId, Preconditions.checkNotNull(CelMutableExpr.newInstance(expr)));
        return this;
    }

    @CanIgnoreReturnValue
    public CelMutableSource addAllMacroCalls(Map<Long, CelMutableExpr> macroCalls) {
        this.macroCalls.putAll(macroCalls);
        return this;
    }

    @CanIgnoreReturnValue
    public CelMutableSource addAllExtensions(Collection<? extends CelSource.Extension> extensions) {
        Preconditions.checkNotNull(extensions);
        this.extensions.addAll(extensions);
        return this;
    }

    @CanIgnoreReturnValue
    public CelMutableSource setDescription(String description) {
        this.description = Preconditions.checkNotNull(description);
        return this;
    }

    @CanIgnoreReturnValue
    public CelMutableSource clearMacroCall(long exprId) {
        this.macroCalls.remove(exprId);
        return this;
    }

    @CanIgnoreReturnValue
    public CelMutableSource clearMacroCalls() {
        this.macroCalls.clear();
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<Long, CelMutableExpr> getMacroCalls() {
        return this.macroCalls;
    }

    public Set<CelSource.Extension> getExtensions() {
        return this.extensions;
    }

    public CelSource toCelSource() {
        return CelSource.newBuilder().setDescription(this.description).addAllExtensions(this.extensions).addAllMacroCalls((Map<Long, CelExpr>)this.macroCalls.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, v -> CelMutableExprConverter.fromMutableExpr((CelMutableExpr)v.getValue())))).build();
    }

    public static CelMutableSource newInstance() {
        return new CelMutableSource("", new HashMap<Long, CelMutableExpr>(), new HashSet<CelSource.Extension>());
    }

    public static CelMutableSource fromCelSource(CelSource source2) {
        return new CelMutableSource(source2.getDescription(), source2.getMacroCalls().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> CelMutableExprConverter.fromCelExpr((CelExpr)v.getValue()), (prev, next) -> {
            throw new IllegalStateException("Unexpected source collision at ID: " + prev.id());
        }, HashMap::new)), source2.getExtensions());
    }

    CelMutableSource(String description, Map<Long, CelMutableExpr> macroCalls, Set<CelSource.Extension> extensions) {
        this.description = Preconditions.checkNotNull(description);
        this.macroCalls = Preconditions.checkNotNull(macroCalls);
        this.extensions = Preconditions.checkNotNull(extensions);
    }
}

