/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Immutable;
import com.google.errorprone.annotations.InlineMe;
import dev.cel.common.CelAbstractSyntaxTree;
import dev.cel.common.CelIssue;
import dev.cel.common.CelSource;
import dev.cel.common.CelValidationException;
import dev.cel.common.annotations.Internal;
import java.util.Comparator;
import org.jspecify.annotations.Nullable;

@Immutable
public final class CelValidationResult {
    private final @Nullable Throwable failure;
    private final @Nullable CelAbstractSyntaxTree ast;
    private final CelSource source;
    private final ImmutableList<CelIssue> issues;
    private final boolean hasError;

    @Internal
    public CelValidationResult(CelSource source2, ImmutableList<CelIssue> issues) {
        this(null, source2, issues, null);
    }

    @Internal
    public CelValidationResult(CelSource source2, Throwable failure, ImmutableList<CelIssue> issues) {
        this(null, source2, issues, failure);
    }

    @Internal
    public CelValidationResult(CelAbstractSyntaxTree ast, ImmutableList<CelIssue> issues) {
        this(ast, ast.getSource(), issues, null);
    }

    private CelValidationResult(@Nullable CelAbstractSyntaxTree ast, CelSource source2, ImmutableList<CelIssue> issues, @Nullable Throwable failure) {
        this.ast = ast;
        this.source = source2;
        this.issues = ImmutableList.sortedCopyOf(Comparator.comparing(CelIssue::getSourceLocation), issues);
        this.hasError = issues.stream().anyMatch(CelValidationResult::issueIsError) || failure != null;
        this.failure = failure;
    }

    @CanIgnoreReturnValue
    public CelAbstractSyntaxTree getAst() throws CelValidationException {
        if (this.hasError) {
            if (this.failure != null) {
                throw new CelValidationException(this.source, this.getErrors(), this.failure.getMessage(), this.failure);
            }
            throw new CelValidationException(this.source, this.getErrors());
        }
        return this.ast;
    }

    public CelSource getSource() {
        return this.source;
    }

    public boolean hasError() {
        return this.hasError;
    }

    public ImmutableList<CelIssue> getErrors() {
        return this.issues.stream().filter(CelValidationResult::issueIsError).collect(ImmutableList.toImmutableList());
    }

    public ImmutableList<CelIssue> getAllIssues() {
        return this.issues;
    }

    public String getIssueString() {
        return CelIssue.toDisplayString(this.issues, this.source);
    }

    @Deprecated
    @InlineMe(replacement="this.getIssueString()")
    public String getDebugString() {
        return this.getIssueString();
    }

    public String getErrorString() {
        return CelIssue.toDisplayString(this.getErrors(), this.source);
    }

    private static boolean issueIsError(CelIssue iss) {
        return iss.getSeverity() == CelIssue.Severity.ERROR;
    }
}

