/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.ast;

import com.google.api.expr.v1alpha1.Constant;
import com.google.api.expr.v1alpha1.Expr;
import com.google.api.expr.v1alpha1.Reference;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.UnsignedLong;
import dev.cel.common.ast.CelConstant;
import dev.cel.common.ast.CelExpr;
import dev.cel.common.ast.CelReference;
import java.util.Map;
import java.util.Optional;

public final class CelExprV1Alpha1Converter {
    private CelExprV1Alpha1Converter() {
    }

    public static Expr fromCelExpr(CelExpr celExpr) {
        CelExpr.ExprKind celExprKind = celExpr.exprKind();
        Expr.Builder expr = CelExprV1Alpha1Converter.newExprBuilder(celExpr);
        switch (celExprKind.getKind()) {
            case CONSTANT: {
                return expr.setConstExpr(CelExprV1Alpha1Converter.celConstantToExprConstant(celExprKind.constant())).build();
            }
            case IDENT: {
                return expr.setIdentExpr(Expr.Ident.newBuilder().setName(celExprKind.ident().name())).build();
            }
            case SELECT: {
                CelExpr.CelSelect celSelect = celExprKind.select();
                return expr.setSelectExpr(Expr.Select.newBuilder().setField(celSelect.field()).setOperand(CelExprV1Alpha1Converter.fromCelExpr(celSelect.operand())).setTestOnly(celSelect.testOnly())).build();
            }
            case CALL: {
                CelExpr.CelCall celCall = celExprKind.call();
                Expr.Call.Builder callBuilder = Expr.Call.newBuilder().setFunction(celCall.function()).addAllArgs(CelExprV1Alpha1Converter.fromCelExprList(celCall.args()));
                celCall.target().ifPresent(target -> callBuilder.setTarget(CelExprV1Alpha1Converter.fromCelExpr(target)));
                return expr.setCallExpr(callBuilder).build();
            }
            case LIST: {
                CelExpr.CelList celList = celExprKind.list();
                return expr.setListExpr(Expr.CreateList.newBuilder().addAllElements(CelExprV1Alpha1Converter.fromCelExprList(celList.elements())).addAllOptionalIndices((Iterable)celList.optionalIndices())).build();
            }
            case STRUCT: {
                return expr.setStructExpr(CelExprV1Alpha1Converter.celStructToExprStruct(celExprKind.struct())).build();
            }
            case MAP: {
                return expr.setStructExpr(CelExprV1Alpha1Converter.celMapToExprStruct(celExprKind.map())).build();
            }
            case COMPREHENSION: {
                CelExpr.CelComprehension celComprehension = celExprKind.comprehension();
                return expr.setComprehensionExpr(Expr.Comprehension.newBuilder().setIterVar(celComprehension.iterVar()).setIterRange(CelExprV1Alpha1Converter.fromCelExpr(celComprehension.iterRange())).setAccuVar(celComprehension.accuVar()).setAccuInit(CelExprV1Alpha1Converter.fromCelExpr(celComprehension.accuInit())).setLoopCondition(CelExprV1Alpha1Converter.fromCelExpr(celComprehension.loopCondition())).setLoopStep(CelExprV1Alpha1Converter.fromCelExpr(celComprehension.loopStep())).setResult(CelExprV1Alpha1Converter.fromCelExpr(celComprehension.result()))).build();
            }
            case NOT_SET: {
                return expr.build();
            }
        }
        throw new IllegalArgumentException("Unexpected expression kind case: " + (Object)((Object)celExpr.exprKind().getKind()));
    }

    public static CelExpr fromExpr(Expr expr) {
        switch (expr.getExprKindCase()) {
            case CONST_EXPR: {
                return CelExpr.ofConstant(expr.getId(), CelExprV1Alpha1Converter.exprConstantToCelConstant(expr.getConstExpr()));
            }
            case IDENT_EXPR: {
                return CelExpr.ofIdent(expr.getId(), expr.getIdentExpr().getName());
            }
            case SELECT_EXPR: {
                Expr.Select selectExpr = expr.getSelectExpr();
                return CelExpr.ofSelect(expr.getId(), CelExprV1Alpha1Converter.fromExpr(selectExpr.getOperand()), selectExpr.getField(), selectExpr.getTestOnly());
            }
            case CALL_EXPR: {
                Expr.Call callExpr = expr.getCallExpr();
                return CelExpr.ofCall(expr.getId(), callExpr.hasTarget() ? Optional.of(CelExprV1Alpha1Converter.fromExpr(callExpr.getTarget())) : Optional.empty(), callExpr.getFunction(), CelExprV1Alpha1Converter.fromExprList(callExpr.getArgsList()));
            }
            case LIST_EXPR: {
                Expr.CreateList createListExpr = expr.getListExpr();
                return CelExpr.ofList(expr.getId(), CelExprV1Alpha1Converter.fromExprList(createListExpr.getElementsList()), ImmutableList.copyOf(createListExpr.getOptionalIndicesList()));
            }
            case STRUCT_EXPR: {
                return CelExprV1Alpha1Converter.exprStructToCelStruct(expr.getId(), expr.getStructExpr());
            }
            case COMPREHENSION_EXPR: {
                Expr.Comprehension comprehensionExpr = expr.getComprehensionExpr();
                return CelExpr.ofComprehension(expr.getId(), comprehensionExpr.getIterVar(), CelExprV1Alpha1Converter.fromExpr(comprehensionExpr.getIterRange()), comprehensionExpr.getAccuVar(), CelExprV1Alpha1Converter.fromExpr(comprehensionExpr.getAccuInit()), CelExprV1Alpha1Converter.fromExpr(comprehensionExpr.getLoopCondition()), CelExprV1Alpha1Converter.fromExpr(comprehensionExpr.getLoopStep()), CelExprV1Alpha1Converter.fromExpr(comprehensionExpr.getResult()));
            }
            case EXPRKIND_NOT_SET: {
                return CelExpr.ofNotSet(expr.getId());
            }
        }
        throw new IllegalArgumentException("Unexpected expression kind case: " + expr.getExprKindCase());
    }

    private static ImmutableList<CelExpr> fromExprList(Iterable<Expr> exprList) {
        ImmutableList.Builder celExprListBuilder = ImmutableList.builder();
        for (Expr expr : exprList) {
            celExprListBuilder.add(CelExprV1Alpha1Converter.fromExpr(expr));
        }
        return celExprListBuilder.build();
    }

    public static CelReference exprReferenceToCelReference(Reference reference) {
        CelReference.Builder builder = CelReference.newBuilder().setName(reference.getName()).addOverloadIds(reference.getOverloadIdList());
        if (reference.hasValue()) {
            builder.setValue(CelExprV1Alpha1Converter.exprConstantToCelConstant(reference.getValue()));
        }
        return builder.build();
    }

    public static CelConstant exprConstantToCelConstant(Constant constExpr) {
        switch (constExpr.getConstantKindCase()) {
            case CONSTANTKIND_NOT_SET: {
                return CelConstant.ofNotSet();
            }
            case NULL_VALUE: {
                return CelConstant.ofValue(constExpr.getNullValue());
            }
            case BOOL_VALUE: {
                return CelConstant.ofValue(constExpr.getBoolValue());
            }
            case INT64_VALUE: {
                return CelConstant.ofValue(constExpr.getInt64Value());
            }
            case UINT64_VALUE: {
                return CelConstant.ofValue(UnsignedLong.fromLongBits(constExpr.getUint64Value()));
            }
            case DOUBLE_VALUE: {
                return CelConstant.ofValue(constExpr.getDoubleValue());
            }
            case STRING_VALUE: {
                return CelConstant.ofValue(constExpr.getStringValue());
            }
            case BYTES_VALUE: {
                return CelConstant.ofValue(constExpr.getBytesValue());
            }
            case DURATION_VALUE: {
                return CelConstant.ofValue(constExpr.getDurationValue());
            }
            case TIMESTAMP_VALUE: {
                return CelConstant.ofValue(constExpr.getTimestampValue());
            }
        }
        throw new IllegalStateException("unsupported constant case: " + constExpr.getConstantKindCase());
    }

    private static CelExpr exprStructToCelStruct(long id, Expr.CreateStruct structExpr) {
        if (!structExpr.getMessageName().isEmpty()) {
            ImmutableList.Builder entries = ImmutableList.builder();
            for (Expr.CreateStruct.Entry structExprEntry : structExpr.getEntriesList()) {
                if (!structExprEntry.getKeyKindCase().equals((Object)Expr.CreateStruct.Entry.KeyKindCase.FIELD_KEY)) {
                    throw new IllegalArgumentException("Unexpected struct key kind case: " + structExprEntry.getKeyKindCase());
                }
                entries.add(CelExpr.ofStructEntry(structExprEntry.getId(), structExprEntry.getFieldKey(), CelExprV1Alpha1Converter.fromExpr(structExprEntry.getValue()), structExprEntry.getOptionalEntry()));
            }
            return CelExpr.ofStruct(id, structExpr.getMessageName(), (ImmutableList<CelExpr.CelStruct.Entry>)entries.build());
        }
        ImmutableList.Builder entries = ImmutableList.builder();
        for (Expr.CreateStruct.Entry mapExprEntry : structExpr.getEntriesList()) {
            if (!mapExprEntry.getKeyKindCase().equals((Object)Expr.CreateStruct.Entry.KeyKindCase.MAP_KEY)) {
                throw new IllegalArgumentException("Unexpected map key kind case: " + mapExprEntry.getKeyKindCase());
            }
            entries.add(CelExpr.ofMapEntry(mapExprEntry.getId(), CelExprV1Alpha1Converter.fromExpr(mapExprEntry.getMapKey()), CelExprV1Alpha1Converter.fromExpr(mapExprEntry.getValue()), mapExprEntry.getOptionalEntry()));
        }
        return CelExpr.ofMap(id, (ImmutableList<CelExpr.CelMap.Entry>)entries.build());
    }

    private static Expr.Builder newExprBuilder(CelExpr expr) {
        return Expr.newBuilder().setId(expr.id());
    }

    public static Constant celConstantToExprConstant(CelConstant celConstant) {
        switch (celConstant.getKind()) {
            case NOT_SET: {
                return Constant.getDefaultInstance();
            }
            case NULL_VALUE: {
                return Constant.newBuilder().setNullValue(celConstant.nullValue()).build();
            }
            case BOOLEAN_VALUE: {
                return Constant.newBuilder().setBoolValue(celConstant.booleanValue()).build();
            }
            case INT64_VALUE: {
                return Constant.newBuilder().setInt64Value(celConstant.int64Value()).build();
            }
            case UINT64_VALUE: {
                return Constant.newBuilder().setUint64Value(celConstant.uint64Value().longValue()).build();
            }
            case DOUBLE_VALUE: {
                return Constant.newBuilder().setDoubleValue(celConstant.doubleValue()).build();
            }
            case STRING_VALUE: {
                return Constant.newBuilder().setStringValue(celConstant.stringValue()).build();
            }
            case BYTES_VALUE: {
                return Constant.newBuilder().setBytesValue(celConstant.bytesValue()).build();
            }
            case DURATION_VALUE: {
                return Constant.newBuilder().setDurationValue(celConstant.durationValue()).build();
            }
            case TIMESTAMP_VALUE: {
                return Constant.newBuilder().setTimestampValue(celConstant.timestampValue()).build();
            }
        }
        throw new IllegalStateException("unsupported constant case: " + (Object)((Object)celConstant.getKind()));
    }

    private static Expr.CreateStruct celStructToExprStruct(CelExpr.CelStruct celStruct) {
        ImmutableList.Builder entries = ImmutableList.builder();
        for (CelExpr.CelStruct.Entry celStructExprEntry : celStruct.entries()) {
            entries.add(Expr.CreateStruct.Entry.newBuilder().setId(celStructExprEntry.id()).setFieldKey(celStructExprEntry.fieldKey()).setValue(CelExprV1Alpha1Converter.fromCelExpr(celStructExprEntry.value())).setOptionalEntry(celStructExprEntry.optionalEntry()).build());
        }
        return Expr.CreateStruct.newBuilder().setMessageName(celStruct.messageName()).addAllEntries((Iterable)entries.build()).build();
    }

    private static Expr.CreateStruct celMapToExprStruct(CelExpr.CelMap celMap) {
        ImmutableList.Builder entries = ImmutableList.builder();
        for (CelExpr.CelMap.Entry celMapEntry : celMap.entries()) {
            Expr.CreateStruct.Entry exprMapEntry = Expr.CreateStruct.Entry.newBuilder().setId(celMapEntry.id()).setMapKey(CelExprV1Alpha1Converter.fromCelExpr(celMapEntry.key())).setValue(CelExprV1Alpha1Converter.fromCelExpr(celMapEntry.value())).setOptionalEntry(celMapEntry.optionalEntry()).build();
            entries.add(exprMapEntry);
        }
        return Expr.CreateStruct.newBuilder().addAllEntries((Iterable)entries.build()).build();
    }

    private static ImmutableList<Expr> fromCelExprList(Iterable<CelExpr> celExprList) {
        ImmutableList.Builder celExprListBuilder = ImmutableList.builder();
        for (CelExpr celExpr : celExprList) {
            celExprListBuilder.add(CelExprV1Alpha1Converter.fromCelExpr(celExpr));
        }
        return celExprListBuilder.build();
    }

    public static Reference celReferenceToExprReference(CelReference reference) {
        Reference.Builder builder = Reference.newBuilder().setName(reference.name()).addAllOverloadId(reference.overloadIds());
        reference.value().ifPresent(celConstant -> builder.setValue(CelExprV1Alpha1Converter.celConstantToExprConstant(celConstant)));
        return builder.build();
    }

    public static ImmutableMap<Long, CelExpr> exprMacroCallsToCelExprMacroCalls(Map<Long, Expr> macroCalls) {
        return macroCalls.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, v -> CelExprV1Alpha1Converter.fromExpr((Expr)v.getValue())));
    }
}

