/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.ast;

import com.google.common.collect.ImmutableList;
import dev.cel.common.ast.CelExpr;
import dev.cel.common.ast.CelMutableExpr;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public final class CelMutableExprConverter {
    public static CelMutableExpr fromCelExpr(CelExpr celExpr) {
        CelExpr.ExprKind celExprKind = celExpr.exprKind();
        switch (celExprKind.getKind()) {
            case CONSTANT: {
                return CelMutableExpr.ofConstant(celExpr.id(), celExpr.constant());
            }
            case IDENT: {
                return CelMutableExpr.ofIdent(celExpr.id(), celExpr.ident().name());
            }
            case SELECT: {
                CelExpr.CelSelect select = celExpr.select();
                CelMutableExpr operand = CelMutableExprConverter.fromCelExpr(select.operand());
                return CelMutableExpr.ofSelect(celExpr.id(), CelMutableExpr.CelMutableSelect.create(operand, select.field(), select.testOnly()));
            }
            case CALL: {
                CelExpr.CelCall celCall = celExprKind.call();
                List args = celCall.args().stream().map(CelMutableExprConverter::fromCelExpr).collect(Collectors.toCollection(ArrayList::new));
                CelMutableExpr.CelMutableCall mutableCall = celCall.target().isPresent() ? CelMutableExpr.CelMutableCall.create(CelMutableExprConverter.fromCelExpr(celCall.target().get()), celCall.function(), args) : CelMutableExpr.CelMutableCall.create(celCall.function(), args);
                return CelMutableExpr.ofCall(celExpr.id(), mutableCall);
            }
            case LIST: {
                CelExpr.CelList createList = celExpr.list();
                return CelMutableExpr.ofList(celExpr.id(), CelMutableExpr.CelMutableList.create(CelMutableExprConverter.fromCelExprList(createList.elements()), createList.optionalIndices()));
            }
            case STRUCT: {
                return CelMutableExpr.ofStruct(celExpr.id(), CelMutableExprConverter.fromCelStructToMutableStruct(celExpr.struct()));
            }
            case MAP: {
                return CelMutableExpr.ofMap(celExpr.id(), CelMutableExprConverter.fromCelMapToMutableMap(celExpr.map()));
            }
            case COMPREHENSION: {
                CelExpr.CelComprehension celComprehension = celExprKind.comprehension();
                CelMutableExpr.CelMutableComprehension mutableComprehension = CelMutableExpr.CelMutableComprehension.create(celComprehension.iterVar(), CelMutableExprConverter.fromCelExpr(celComprehension.iterRange()), celComprehension.accuVar(), CelMutableExprConverter.fromCelExpr(celComprehension.accuInit()), CelMutableExprConverter.fromCelExpr(celComprehension.loopCondition()), CelMutableExprConverter.fromCelExpr(celComprehension.loopStep()), CelMutableExprConverter.fromCelExpr(celComprehension.result()));
                return CelMutableExpr.ofComprehension(celExpr.id(), mutableComprehension);
            }
            case NOT_SET: {
                return CelMutableExpr.ofNotSet(celExpr.id());
            }
        }
        throw new IllegalArgumentException("Unexpected expression kind case: " + (Object)((Object)celExpr.exprKind().getKind()));
    }

    private static List<CelMutableExpr> fromCelExprList(Iterable<CelExpr> celExprList) {
        ArrayList<CelMutableExpr> mutableExprList = new ArrayList<CelMutableExpr>();
        for (CelExpr celExpr : celExprList) {
            mutableExprList.add(CelMutableExprConverter.fromCelExpr(celExpr));
        }
        return mutableExprList;
    }

    private static CelMutableExpr.CelMutableStruct fromCelStructToMutableStruct(CelExpr.CelStruct celStruct) {
        ArrayList<CelMutableExpr.CelMutableStruct.Entry> entries = new ArrayList<CelMutableExpr.CelMutableStruct.Entry>();
        for (CelExpr.CelStruct.Entry celStructExprEntry : celStruct.entries()) {
            entries.add(CelMutableExpr.CelMutableStruct.Entry.create(celStructExprEntry.id(), celStructExprEntry.fieldKey(), CelMutableExprConverter.fromCelExpr(celStructExprEntry.value()), celStructExprEntry.optionalEntry()));
        }
        return CelMutableExpr.CelMutableStruct.create(celStruct.messageName(), entries);
    }

    private static CelMutableExpr.CelMutableMap fromCelMapToMutableMap(CelExpr.CelMap celMap) {
        ArrayList<CelMutableExpr.CelMutableMap.Entry> entries = new ArrayList<CelMutableExpr.CelMutableMap.Entry>();
        for (CelExpr.CelMap.Entry celMapExprEntry : celMap.entries()) {
            entries.add(CelMutableExpr.CelMutableMap.Entry.create(celMapExprEntry.id(), CelMutableExprConverter.fromCelExpr(celMapExprEntry.key()), CelMutableExprConverter.fromCelExpr(celMapExprEntry.value()), celMapExprEntry.optionalEntry()));
        }
        return CelMutableExpr.CelMutableMap.create(entries);
    }

    public static CelExpr fromMutableExpr(CelMutableExpr mutableExpr) {
        long id = mutableExpr.id();
        switch (mutableExpr.getKind()) {
            case CONSTANT: {
                return CelExpr.ofConstant(id, mutableExpr.constant());
            }
            case IDENT: {
                return CelExpr.ofIdent(id, mutableExpr.ident().name());
            }
            case SELECT: {
                CelMutableExpr.CelMutableSelect select = mutableExpr.select();
                CelExpr operand = CelMutableExprConverter.fromMutableExpr(select.operand());
                return CelExpr.ofSelect(id, operand, select.field(), select.testOnly());
            }
            case CALL: {
                CelMutableExpr.CelMutableCall mutableCall = mutableExpr.call();
                ImmutableList<CelExpr> args = mutableCall.args().stream().map(CelMutableExprConverter::fromMutableExpr).collect(ImmutableList.toImmutableList());
                Optional<CelExpr> targetExpr = mutableCall.target().map(CelMutableExprConverter::fromMutableExpr);
                return CelExpr.ofCall(id, targetExpr, mutableCall.function(), args);
            }
            case LIST: {
                CelMutableExpr.CelMutableList mutableList = mutableExpr.list();
                return CelExpr.ofList(id, CelMutableExprConverter.fromMutableExprList(mutableList.elements()), ImmutableList.copyOf(mutableList.optionalIndices()));
            }
            case STRUCT: {
                CelMutableExpr.CelMutableStruct mutableStruct = mutableExpr.struct();
                return CelExpr.newBuilder().setId(id).setStruct(CelMutableExprConverter.fromMutableStructToCelStruct(mutableStruct)).build();
            }
            case MAP: {
                CelMutableExpr.CelMutableMap mutableMap = mutableExpr.map();
                return CelExpr.newBuilder().setId(id).setMap(CelMutableExprConverter.fromMutableMapToCelMap(mutableMap)).build();
            }
            case COMPREHENSION: {
                CelMutableExpr.CelMutableComprehension mutableComprehension = mutableExpr.comprehension();
                return CelExpr.ofComprehension(id, mutableComprehension.iterVar(), CelMutableExprConverter.fromMutableExpr(mutableComprehension.iterRange()), mutableComprehension.accuVar(), CelMutableExprConverter.fromMutableExpr(mutableComprehension.accuInit()), CelMutableExprConverter.fromMutableExpr(mutableComprehension.loopCondition()), CelMutableExprConverter.fromMutableExpr(mutableComprehension.loopStep()), CelMutableExprConverter.fromMutableExpr(mutableComprehension.result()));
            }
            case NOT_SET: {
                return CelExpr.ofNotSet(id);
            }
        }
        throw new IllegalArgumentException("Unexpected expression kind case: " + (Object)((Object)mutableExpr.getKind()));
    }

    private static ImmutableList<CelExpr> fromMutableExprList(Iterable<CelMutableExpr> mutableExprList) {
        ImmutableList.Builder celExprList = ImmutableList.builder();
        for (CelMutableExpr mutableExpr : mutableExprList) {
            celExprList.add(CelMutableExprConverter.fromMutableExpr(mutableExpr));
        }
        return celExprList.build();
    }

    private static CelExpr.CelStruct fromMutableStructToCelStruct(CelMutableExpr.CelMutableStruct mutableStruct) {
        ArrayList<CelExpr.CelStruct.Entry> entries = new ArrayList<CelExpr.CelStruct.Entry>();
        for (CelMutableExpr.CelMutableStruct.Entry mutableStructEntry : mutableStruct.entries()) {
            entries.add(CelExpr.ofStructEntry(mutableStructEntry.id(), mutableStructEntry.fieldKey(), CelMutableExprConverter.fromMutableExpr(mutableStructEntry.value()), mutableStructEntry.optionalEntry()));
        }
        return CelExpr.CelStruct.newBuilder().setMessageName(mutableStruct.messageName()).addEntries(entries).build();
    }

    private static CelExpr.CelMap fromMutableMapToCelMap(CelMutableExpr.CelMutableMap mutableMap) {
        ArrayList<CelExpr.CelMap.Entry> entries = new ArrayList<CelExpr.CelMap.Entry>();
        for (CelMutableExpr.CelMutableMap.Entry mutableMapEntry : mutableMap.entries()) {
            entries.add(CelExpr.ofMapEntry(mutableMapEntry.id(), CelMutableExprConverter.fromMutableExpr(mutableMapEntry.key()), CelMutableExprConverter.fromMutableExpr(mutableMapEntry.value()), mutableMapEntry.optionalEntry()));
        }
        return CelExpr.CelMap.newBuilder().addEntries(entries).build();
    }

    private CelMutableExprConverter() {
    }
}

