/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.ast;

import dev.cel.common.annotations.Internal;
import dev.cel.common.ast.CelConstant;
import dev.cel.common.ast.CelExpr;
import java.util.Optional;

@Internal
public interface Expression {
    public long id();

    public CelExpr.ExprKind.Kind getKind();

    public CelConstant constant();

    public Ident ident();

    public <E extends Expression> Call<E> call();

    public <E extends Expression> List<E> list();

    public <E extends Expression> Select<E> select();

    public <E extends Expression> Struct<Struct.Entry<E>> struct();

    public <E extends Expression> Map<Map.Entry<E>> map();

    public <E extends Expression> Comprehension<E> comprehension();

    public static interface Comprehension<E extends Expression> {
        public String iterVar();

        public E iterRange();

        public String accuVar();

        public E accuInit();

        public E loopCondition();

        public E loopStep();

        public E result();
    }

    public static interface Map<E extends Entry<?>> {
        public java.util.List<E> entries();

        public static interface Entry<T extends Expression> {
            public long id();

            public T key();

            public T value();

            public boolean optionalEntry();
        }
    }

    public static interface Struct<E extends Entry<?>> {
        public String messageName();

        public java.util.List<E> entries();

        public static interface Entry<T extends Expression> {
            public long id();

            public String fieldKey();

            public T value();

            public boolean optionalEntry();
        }
    }

    public static interface Select<E extends Expression> {
        public E operand();

        public String field();

        public boolean testOnly();
    }

    public static interface List<E extends Expression> {
        public java.util.List<E> elements();

        public java.util.List<Integer> optionalIndices();
    }

    public static interface Call<E extends Expression> {
        public Optional<E> target();

        public String function();

        public java.util.List<E> args();
    }

    public static interface Ident {
        public String name();
    }
}

