/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.formats;

import com.google.common.collect.ImmutableMap;
import dev.cel.common.formats.CelFileSource;
import dev.cel.common.internal.CelCodePointArray;
import java.util.Map;

final class AutoValue_CelFileSource
extends CelFileSource {
    private final CelCodePointArray content;
    private final String description;
    private final ImmutableMap<Long, Integer> positionsMap;

    private AutoValue_CelFileSource(CelCodePointArray content, String description, ImmutableMap<Long, Integer> positionsMap) {
        this.content = content;
        this.description = description;
        this.positionsMap = positionsMap;
    }

    @Override
    public CelCodePointArray getContent() {
        return this.content;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public ImmutableMap<Long, Integer> getPositionsMap() {
        return this.positionsMap;
    }

    public String toString() {
        return "CelFileSource{content=" + this.content + ", description=" + this.description + ", positionsMap=" + this.positionsMap + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CelFileSource) {
            CelFileSource that = (CelFileSource)o;
            return this.content.equals(that.getContent()) && this.description.equals(that.getDescription()) && this.positionsMap.equals(that.getPositionsMap());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.content.hashCode();
        h$ *= 1000003;
        h$ ^= this.description.hashCode();
        h$ *= 1000003;
        return h$ ^= this.positionsMap.hashCode();
    }

    @Override
    public CelFileSource.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends CelFileSource.Builder {
        private CelCodePointArray content;
        private String description;
        private ImmutableMap<Long, Integer> positionsMap;

        Builder() {
        }

        Builder(CelFileSource source2) {
            this.content = source2.getContent();
            this.description = source2.getDescription();
            this.positionsMap = source2.getPositionsMap();
        }

        @Override
        public CelFileSource.Builder setContent(CelCodePointArray content) {
            if (content == null) {
                throw new NullPointerException("Null content");
            }
            this.content = content;
            return this;
        }

        @Override
        public CelFileSource.Builder setDescription(String description) {
            if (description == null) {
                throw new NullPointerException("Null description");
            }
            this.description = description;
            return this;
        }

        @Override
        public CelFileSource.Builder setPositionsMap(Map<Long, Integer> positionsMap) {
            this.positionsMap = ImmutableMap.copyOf(positionsMap);
            return this;
        }

        @Override
        public CelFileSource build() {
            if (this.content == null || this.description == null || this.positionsMap == null) {
                StringBuilder missing = new StringBuilder();
                if (this.content == null) {
                    missing.append(" content");
                }
                if (this.description == null) {
                    missing.append(" description");
                }
                if (this.positionsMap == null) {
                    missing.append(" positionsMap");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_CelFileSource(this.content, this.description, this.positionsMap);
        }
    }
}

