/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.internal;

import com.google.common.primitives.UnsignedLong;
import com.google.errorprone.annotations.CheckReturnValue;
import dev.cel.common.annotations.Internal;

@CheckReturnValue
@Internal
public final class ComparisonFunctions {
    private static final UnsignedLong UINT_TO_INT_MAX = UnsignedLong.valueOf(Long.MAX_VALUE);
    private static final double DOUBLE_TO_INT_MAX = 9.223372036854776E18;
    private static final double DOUBLE_TO_INT_MIN = -9.223372036854776E18;
    private static final double DOUBLE_TO_UINT_MAX = UnsignedLong.MAX_VALUE.doubleValue();

    public static int compareDoubleInt(double d, long l) {
        if (d < -9.223372036854776E18) {
            return -1;
        }
        if (d > 9.223372036854776E18) {
            return 1;
        }
        return Double.compare(d, l);
    }

    public static int compareIntDouble(long l, double d) {
        return -ComparisonFunctions.compareDoubleInt(d, l);
    }

    public static int compareDoubleUint(double d, UnsignedLong ul) {
        if (d < 0.0) {
            return -1;
        }
        if (d > DOUBLE_TO_UINT_MAX) {
            return 1;
        }
        return Double.compare(d, ul.doubleValue());
    }

    public static int compareUintDouble(UnsignedLong ul, double d) {
        return -ComparisonFunctions.compareDoubleUint(d, ul);
    }

    public static int compareIntUint(long l, UnsignedLong ul) {
        if (l < 0L || ul.compareTo(UINT_TO_INT_MAX) >= 0) {
            return -1;
        }
        return Long.compare(l, ul.longValue());
    }

    public static int compareUintInt(UnsignedLong ul, long l) {
        return -ComparisonFunctions.compareIntUint(l, ul);
    }

    public static boolean numericEquals(Number x, Number y) {
        if (x instanceof Double) {
            if (y instanceof Double) {
                return !Double.isNaN((Double)x) && !Double.isNaN((Double)y) && x.equals(y);
            }
            if (y instanceof Long) {
                return ComparisonFunctions.compareDoubleInt((Double)x, (Long)y) == 0;
            }
            if (y instanceof UnsignedLong) {
                return ComparisonFunctions.compareDoubleUint((Double)x, (UnsignedLong)y) == 0;
            }
        }
        if (x instanceof Long) {
            if (y instanceof Long) {
                return x.equals(y);
            }
            if (y instanceof Double) {
                return ComparisonFunctions.compareIntDouble((Long)x, (Double)y) == 0;
            }
            if (y instanceof UnsignedLong) {
                return ComparisonFunctions.compareIntUint((Long)x, (UnsignedLong)y) == 0;
            }
        }
        if (x instanceof UnsignedLong) {
            if (y instanceof UnsignedLong) {
                return x.equals(y);
            }
            if (y instanceof Double) {
                return ComparisonFunctions.compareUintDouble((UnsignedLong)x, (Double)y) == 0;
            }
            if (y instanceof Long) {
                return ComparisonFunctions.compareUintInt((UnsignedLong)x, (Long)y) == 0;
            }
        }
        return false;
    }

    private ComparisonFunctions() {
    }
}

