/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.errorprone.annotations.Immutable;
import com.google.protobuf.Any;
import com.google.protobuf.BoolValue;
import com.google.protobuf.BytesValue;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DoubleValue;
import com.google.protobuf.Duration;
import com.google.protobuf.Empty;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.FieldMask;
import com.google.protobuf.FloatValue;
import com.google.protobuf.Int32Value;
import com.google.protobuf.Int64Value;
import com.google.protobuf.ListValue;
import com.google.protobuf.StringValue;
import com.google.protobuf.Struct;
import com.google.protobuf.Timestamp;
import com.google.protobuf.UInt32Value;
import com.google.protobuf.UInt64Value;
import com.google.protobuf.Value;
import dev.cel.common.CelDescriptors;
import dev.cel.common.annotations.Internal;
import dev.cel.common.internal.CelDescriptorPool;
import dev.cel.common.internal.WellKnownProto;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;

@Immutable
@Internal
public final class DefaultDescriptorPool
implements CelDescriptorPool {
    private static final ImmutableMap<WellKnownProto, Descriptors.Descriptor> WELL_KNOWN_PROTO_TO_DESCRIPTORS = ImmutableMap.builder().put(WellKnownProto.ANY_VALUE, Any.getDescriptor()).put(WellKnownProto.BOOL_VALUE, BoolValue.getDescriptor()).put(WellKnownProto.BYTES_VALUE, BytesValue.getDescriptor()).put(WellKnownProto.DOUBLE_VALUE, DoubleValue.getDescriptor()).put(WellKnownProto.DURATION, Duration.getDescriptor()).put(WellKnownProto.FLOAT_VALUE, FloatValue.getDescriptor()).put(WellKnownProto.INT32_VALUE, Int32Value.getDescriptor()).put(WellKnownProto.INT64_VALUE, Int64Value.getDescriptor()).put(WellKnownProto.STRING_VALUE, StringValue.getDescriptor()).put(WellKnownProto.TIMESTAMP, Timestamp.getDescriptor()).put(WellKnownProto.UINT32_VALUE, UInt32Value.getDescriptor()).put(WellKnownProto.UINT64_VALUE, UInt64Value.getDescriptor()).put(WellKnownProto.JSON_LIST_VALUE, ListValue.getDescriptor()).put(WellKnownProto.JSON_STRUCT_VALUE, Struct.getDescriptor()).put(WellKnownProto.JSON_VALUE, Value.getDescriptor()).put(WellKnownProto.EMPTY, Empty.getDescriptor()).put(WellKnownProto.FIELD_MASK, FieldMask.getDescriptor()).buildOrThrow();
    private static final ImmutableMap<String, Descriptors.Descriptor> WELL_KNOWN_TYPE_NAME_TO_DESCRIPTORS = Arrays.stream(WellKnownProto.values()).collect(ImmutableMap.toImmutableMap(WellKnownProto::typeName, WELL_KNOWN_PROTO_TO_DESCRIPTORS::get));
    public static final DefaultDescriptorPool INSTANCE = new DefaultDescriptorPool(WELL_KNOWN_TYPE_NAME_TO_DESCRIPTORS, ImmutableMultimap.of(), ExtensionRegistry.getEmptyRegistry());
    private final ImmutableMap<String, Descriptors.Descriptor> descriptorMap;
    private final ImmutableMultimap<String, Descriptors.FieldDescriptor> extensionDescriptorMap;
    private final ExtensionRegistry extensionRegistry;

    public static DefaultDescriptorPool create(CelDescriptors celDescriptors) {
        return DefaultDescriptorPool.create(celDescriptors, ExtensionRegistry.getEmptyRegistry());
    }

    public static DefaultDescriptorPool create(CelDescriptors celDescriptors, ExtensionRegistry extensionRegistry) {
        HashMap<String, Descriptors.Descriptor> descriptorMap = new HashMap<String, Descriptors.Descriptor>(WELL_KNOWN_TYPE_NAME_TO_DESCRIPTORS);
        for (Descriptors.Descriptor descriptor : celDescriptors.messageTypeDescriptors()) {
            descriptorMap.putIfAbsent(descriptor.getFullName(), descriptor);
        }
        return new DefaultDescriptorPool(ImmutableMap.copyOf(descriptorMap), celDescriptors.extensionDescriptors(), extensionRegistry);
    }

    @Override
    public Optional<Descriptors.Descriptor> findDescriptor(String name) {
        return Optional.ofNullable(this.descriptorMap.get(name));
    }

    @Override
    public Optional<Descriptors.FieldDescriptor> findExtensionDescriptor(Descriptors.Descriptor containingDescriptor, String fieldName) {
        String typeName = containingDescriptor.getFullName();
        Collection fieldDescriptors = this.extensionDescriptorMap.get((Object)typeName);
        return fieldDescriptors.stream().filter(d -> d.getFullName().equals(fieldName)).findFirst();
    }

    @Override
    public ExtensionRegistry getExtensionRegistry() {
        return this.extensionRegistry;
    }

    private DefaultDescriptorPool(ImmutableMap<String, Descriptors.Descriptor> descriptorMap, ImmutableMultimap<String, Descriptors.FieldDescriptor> extensionDescriptorMap, ExtensionRegistry extensionRegistry) {
        this.descriptorMap = Preconditions.checkNotNull(descriptorMap);
        this.extensionDescriptorMap = Preconditions.checkNotNull(extensionDescriptorMap);
        this.extensionRegistry = Preconditions.checkNotNull(extensionRegistry);
    }
}

