/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.internal;

import com.google.auto.value.AutoValue;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.ImmutableIntArray;
import com.google.errorprone.annotations.Immutable;
import dev.cel.common.annotations.Internal;
import dev.cel.common.internal.AutoValue_Errors_SourceLocation;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import org.jspecify.annotations.Nullable;

@Internal
public final class Errors {
    private static final String NEWLINE = System.lineSeparator();
    private static final Splitter LINE_SPLITTER = Splitter.on(NEWLINE);
    private final List<Error> errors = new ArrayList<Error>();
    private final Deque<Context> context = new ArrayDeque<Context>();

    public Errors(String description, @Nullable String source2) {
        this.enterContext(description, source2);
    }

    public void enterContext(String description, @Nullable String source2) {
        this.context.addFirst(new Context(Preconditions.checkNotNull(description), source2));
    }

    public void exitContext() {
        Preconditions.checkState(!this.context.isEmpty(), "cannot exit top-level error context");
        this.context.removeFirst();
    }

    public ImmutableIntArray getLineOffsets() {
        return this.context.peekFirst().getLineOffsets();
    }

    public String getContent() {
        return this.context.peekFirst().source;
    }

    public String getDescription() {
        return this.context.peek().description;
    }

    public String getLocationAt(int position) {
        Context current = this.context.peekFirst();
        SourceLocation location = current.getPositionLocation(position);
        int line = location.line();
        int column = location.column();
        return String.format("%s:%d:%d", current.description, line, column);
    }

    public int getLocationPosition(int line, int column) {
        ImmutableIntArray lineOffsets = this.getLineOffsets();
        if (line == 1) {
            return column - 1;
        }
        if (line > 1 && line - 1 < lineOffsets.length()) {
            return lineOffsets.get(line - 2) + column - 1;
        }
        return -1;
    }

    public SourceLocation getPositionLocation(int position) {
        Context current = this.context.peekFirst();
        return current.getPositionLocation(position);
    }

    public Optional<String> getSnippet(int line) {
        Context current = this.context.peekFirst();
        return current.getSnippet(line);
    }

    public int getErrorCount() {
        return this.errors.size();
    }

    public ImmutableList<Error> getErrors() {
        return ImmutableList.copyOf(this.errors);
    }

    public String getAllErrorsAsString() {
        return Joiner.on(NEWLINE).join(this.errors);
    }

    @Deprecated
    public void reportError(int position, String message, Object ... args) {
        this.reportError(0L, position, message, args);
    }

    public void reportError(long exprId, int position, String message, Object ... args) {
        if (args.length > 0) {
            message = String.format(message, args);
        }
        this.errors.add(new Error(exprId, this.context.peekFirst(), position, message));
    }

    @Immutable
    private static class Context {
        private final String description;
        private final @Nullable String source;
        private final ImmutableIntArray codePoints;
        private final ImmutableIntArray linePositions;

        private Context(String description, @Nullable String source2) {
            this.description = description;
            this.source = source2;
            this.codePoints = source2 == null ? ImmutableIntArray.of() : ImmutableIntArray.copyOf(source2.codePoints().toArray());
            ImmutableIntArray.Builder linePositionsBuilder = ImmutableIntArray.builder();
            if (source2 != null) {
                int linePosition = 0;
                for (String line : LINE_SPLITTER.split(source2)) {
                    linePositionsBuilder.add(linePosition += (int)(line.codePoints().count() + 1L));
                }
            }
            this.linePositions = linePositionsBuilder.build();
        }

        private ImmutableIntArray getLineOffsets() {
            return this.linePositions;
        }

        private SourceLocation getPositionLocation(int position) {
            int line = 1;
            for (int index = 0; index < this.linePositions.length() && this.linePositions.get(index) <= position; ++index) {
                ++line;
            }
            if (line == 1) {
                return SourceLocation.of(line, position + 1);
            }
            int lineStartPosition = this.linePositions.get(line - 2);
            return SourceLocation.of(line, position - lineStartPosition + 1);
        }

        private Optional<String> getSnippet(int line) {
            if (this.source == null) {
                return Optional.empty();
            }
            if (line - 1 < this.linePositions.length()) {
                int lineStart = this.linePositions.length() == 1 || line == 1 ? 0 : this.linePositions.get(line - 2);
                int lineEnd = this.linePositions.get(line - 1);
                return Optional.of(new String(this.codePoints.toArray(), lineStart, lineEnd - lineStart - 1));
            }
            return Optional.empty();
        }
    }

    @Immutable
    @AutoValue
    public static abstract class SourceLocation {
        public abstract int line();

        public abstract int column();

        public static SourceLocation of(int line, int column) {
            return new AutoValue_Errors_SourceLocation(line, column);
        }
    }

    @Immutable
    public static class Error {
        private final Context context;
        private final int position;
        private final String message;
        private final long exprId;

        private Error(long exprId, Context context, int position, String message) {
            this.exprId = exprId;
            this.context = context;
            this.position = position;
            this.message = message;
        }

        public int position() {
            return this.position;
        }

        public String rawMessage() {
            return this.message;
        }

        public long exprId() {
            return this.exprId;
        }

        public String toDisplayString(@Nullable ErrorFormatter formatter) {
            String marker = formatter != null ? formatter.formatError("ERROR") : "ERROR";
            SourceLocation location = this.context.getPositionLocation(this.position);
            Optional sourceLine = this.context.getSnippet(location.line());
            if (!sourceLine.isPresent()) {
                return String.format("%s: %s:%s: %s", marker, this.context.description, this.position, this.message);
            }
            int line = location.line();
            int column = location.column();
            StringBuilder result = new StringBuilder(String.format("%s: %s:%s:%s: %s", marker, this.context.description, line, column, this.message));
            result.append(NEWLINE);
            result.append("  | ");
            result.append(((String)sourceLine.get()).replace("%", "%%"));
            result.append(NEWLINE);
            result.append("  | ");
            result.append(Strings.repeat(".", column - 1));
            result.append("^");
            return result.toString();
        }

        public String toString() {
            return this.toDisplayString(null);
        }
    }

    public static interface ErrorFormatter {
        public String formatError(String var1);
    }
}

