/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.internal;

import com.google.common.base.CaseFormat;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.io.Files;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import dev.cel.common.annotations.Internal;
import java.util.ArrayDeque;

@Internal
public final class ProtoJavaQualifiedNames {
    private static final int SAFE_RECURSE_LIMIT = 50;

    public static String getFullyQualifiedJavaClassName(Descriptors.Descriptor descriptor) {
        return ProtoJavaQualifiedNames.getFullyQualifiedJavaClassNameImpl(descriptor);
    }

    private static String getFullyQualifiedJavaClassNameImpl(Descriptors.GenericDescriptor descriptor) {
        StringBuilder fullClassName = new StringBuilder();
        fullClassName.append(ProtoJavaQualifiedNames.getJavaPackageName(descriptor.getFile())).append(".");
        String javaOuterClass = ProtoJavaQualifiedNames.getJavaOuterClassName(descriptor.getFile());
        if (!Strings.isNullOrEmpty(javaOuterClass)) {
            fullClassName.append(javaOuterClass).append("$");
        }
        ArrayDeque<String> classNames = new ArrayDeque<String>();
        Descriptors.GenericDescriptor d = descriptor;
        int recurseCount = 0;
        while (d != null) {
            classNames.push(d.getName());
            d = d instanceof Descriptors.EnumDescriptor ? ((Descriptors.EnumDescriptor)d).getContainingType() : ((Descriptors.Descriptor)d).getContainingType();
            if (++recurseCount < 50) continue;
            throw new IllegalStateException(String.format("Recursion limit of %d hit while inspecting descriptor: %s", 50, descriptor.getFullName()));
        }
        Joiner.on("$").appendTo(fullClassName, (Iterable<? extends Object>)classNames);
        return fullClassName.toString();
    }

    public static String getJavaPackageName(Descriptors.FileDescriptor fileDescriptor) {
        DescriptorProtos.FileOptions options = fileDescriptor.getFile().getOptions();
        StringBuilder javaPackageName = new StringBuilder();
        if (options.hasJavaPackage()) {
            javaPackageName.append(options.getJavaPackage());
        } else {
            javaPackageName.append(fileDescriptor.getPackage());
        }
        return javaPackageName.toString();
    }

    private static String getJavaOuterClassName(Descriptors.FileDescriptor descriptor) {
        DescriptorProtos.FileOptions options = descriptor.getOptions();
        if (options.getJavaMultipleFiles()) {
            return "";
        }
        if (options.hasJavaOuterClassname()) {
            return options.getJavaOuterClassname();
        }
        String protoFileNameWithoutExtension = Files.getNameWithoutExtension(descriptor.getFile().getFullName());
        String outerClassName = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, protoFileNameWithoutExtension);
        if (ProtoJavaQualifiedNames.hasConflictingClassName(descriptor.getFile(), outerClassName)) {
            outerClassName = outerClassName + "OuterClass";
        }
        return outerClassName;
    }

    private static boolean hasConflictingClassName(Descriptors.FileDescriptor file, String name) {
        for (Descriptors.EnumDescriptor enumDesc : file.getEnumTypes()) {
            if (!name.equals(enumDesc.getName())) continue;
            return true;
        }
        for (Descriptors.ServiceDescriptor serviceDesc : file.getServices()) {
            if (!name.equals(serviceDesc.getName())) continue;
            return true;
        }
        for (Descriptors.Descriptor messageDesc : file.getMessageTypes()) {
            if (!name.equals(messageDesc.getName())) continue;
            return true;
        }
        return false;
    }

    private ProtoJavaQualifiedNames() {
    }
}

