/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.internal;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import com.google.protobuf.Message;
import dev.cel.common.internal.CelDescriptorPool;
import dev.cel.common.internal.DefaultDescriptorPool;
import java.util.Optional;

@Immutable
@FunctionalInterface
public interface ProtoMessageFactory {
    public Optional<Message.Builder> newBuilder(String var1);

    default public CelDescriptorPool getDescriptorPool() {
        return DefaultDescriptorPool.INSTANCE;
    }

    @Immutable
    public static final class CombinedMessageFactory
    implements ProtoMessageFactory {
        private final ImmutableList<ProtoMessageFactory> messageFactories;

        public CombinedMessageFactory(Iterable<ProtoMessageFactory> messageFactories) {
            this.messageFactories = ImmutableList.copyOf(messageFactories);
        }

        @Override
        public Optional<Message.Builder> newBuilder(String messageName) {
            for (ProtoMessageFactory messageFactory : this.messageFactories) {
                Optional<Message.Builder> builder = messageFactory.newBuilder(messageName);
                if (!builder.isPresent()) continue;
                return builder;
            }
            return Optional.empty();
        }
    }
}

