/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.navigation;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import dev.cel.common.ast.CelExpr;
import dev.cel.common.ast.Expression;
import dev.cel.common.navigation.CelNavigableExprVisitor;
import dev.cel.common.navigation.TraversalOrder;
import java.util.Optional;
import java.util.stream.Stream;

abstract class BaseNavigableExpr<E extends Expression> {
    BaseNavigableExpr() {
    }

    public abstract E expr();

    public long id() {
        return this.expr().id();
    }

    public abstract <T extends BaseNavigableExpr<E>> Optional<T> parent();

    public abstract int depth();

    public abstract long maxId();

    public abstract int height();

    public <T extends BaseNavigableExpr<E>> Stream<T> allNodes() {
        return this.allNodes(TraversalOrder.POST_ORDER);
    }

    public <T extends BaseNavigableExpr<E>> Stream<T> allNodes(TraversalOrder traversalOrder) {
        return CelNavigableExprVisitor.collect(this, traversalOrder);
    }

    public <T extends BaseNavigableExpr<E>> Stream<T> descendants() {
        return this.descendants(TraversalOrder.POST_ORDER);
    }

    public <T extends BaseNavigableExpr<E>> Stream<T> descendants(TraversalOrder traversalOrder) {
        return CelNavigableExprVisitor.collect(this, traversalOrder).filter(node -> node.depth() > this.depth());
    }

    public <T extends BaseNavigableExpr<E>> Stream<T> children() {
        return this.children(TraversalOrder.POST_ORDER);
    }

    public <T extends BaseNavigableExpr<E>> Stream<T> children(TraversalOrder traversalOrder) {
        return CelNavigableExprVisitor.collect(this, this.depth() + 1, traversalOrder).filter(node -> node.depth() > this.depth());
    }

    public CelExpr.ExprKind.Kind getKind() {
        return this.expr().getKind();
    }

    public abstract <T extends BaseNavigableExpr<E>> Builder<E, T> builderFromInstance();

    static interface Builder<E extends Expression, T extends BaseNavigableExpr<E>> {
        public E expr();

        public int depth();

        default public CelExpr.ExprKind.Kind getKind() {
            return this.expr().getKind();
        }

        @CanIgnoreReturnValue
        public Builder<E, T> setExpr(E var1);

        @CanIgnoreReturnValue
        public Builder<E, T> setParent(T var1);

        @CanIgnoreReturnValue
        public Builder<E, T> setDepth(int var1);

        @CanIgnoreReturnValue
        public Builder<E, T> setHeight(int var1);

        @CanIgnoreReturnValue
        public Builder<E, T> setMaxId(long var1);

        @CheckReturnValue
        public T build();
    }
}

