/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.types;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.Empty;
import com.google.protobuf.NullValue;
import dev.cel.common.types.CelKind;
import dev.cel.common.types.CelType;
import dev.cel.common.types.CelTypes;
import dev.cel.common.types.ListType;
import dev.cel.common.types.MapType;
import dev.cel.common.types.NullableType;
import dev.cel.common.types.OpaqueType;
import dev.cel.common.types.OptionalType;
import dev.cel.common.types.SimpleType;
import dev.cel.common.types.StructTypeReference;
import dev.cel.common.types.TypeParamType;
import dev.cel.common.types.TypeType;
import dev.cel.common.types.UnspecifiedType;
import dev.cel.expr.Type;

public final class CelProtoTypes {
    public static final Type ERROR = Type.newBuilder().setError(Empty.getDefaultInstance()).build();
    public static final Type DYN = Type.newBuilder().setDyn(Empty.getDefaultInstance()).build();
    public static final Type NULL_TYPE = Type.newBuilder().setNull(NullValue.NULL_VALUE).build();
    public static final Type BOOL = CelProtoTypes.create(Type.PrimitiveType.BOOL);
    public static final Type BYTES = CelProtoTypes.create(Type.PrimitiveType.BYTES);
    public static final Type STRING = CelProtoTypes.create(Type.PrimitiveType.STRING);
    public static final Type DOUBLE = CelProtoTypes.create(Type.PrimitiveType.DOUBLE);
    public static final Type UINT64 = CelProtoTypes.create(Type.PrimitiveType.UINT64);
    public static final Type INT64 = CelProtoTypes.create(Type.PrimitiveType.INT64);
    public static final Type ANY = CelProtoTypes.create(Type.WellKnownType.ANY);
    public static final Type TIMESTAMP = CelProtoTypes.create(Type.WellKnownType.TIMESTAMP);
    public static final Type DURATION = CelProtoTypes.create(Type.WellKnownType.DURATION);
    private static final ImmutableMap<CelKind, Type> SIMPLE_CEL_KIND_TO_TYPE = ImmutableMap.builder().put(CelKind.ERROR, ERROR).put(CelKind.DYN, DYN).put(CelKind.ANY, ANY).put(CelKind.BOOL, BOOL).put(CelKind.BYTES, BYTES).put(CelKind.DOUBLE, DOUBLE).put(CelKind.DURATION, DURATION).put(CelKind.INT, INT64).put(CelKind.NULL_TYPE, NULL_TYPE).put(CelKind.STRING, STRING).put(CelKind.TIMESTAMP, TIMESTAMP).put(CelKind.UINT, UINT64).buildOrThrow();
    private static final ImmutableMap<Type, CelType> PROTOBUF_TYPE_TO_CEL_TYPE_MAP = ImmutableMap.builder().put(BOOL, SimpleType.BOOL).put(BYTES, SimpleType.BYTES).put(DOUBLE, SimpleType.DOUBLE).put(INT64, SimpleType.INT).put(STRING, SimpleType.STRING).put(UINT64, SimpleType.UINT).put(ANY, SimpleType.ANY).put(DURATION, SimpleType.DURATION).put(TIMESTAMP, SimpleType.TIMESTAMP).put(DYN, SimpleType.DYN).put(NULL_TYPE, SimpleType.NULL_TYPE).put(ERROR, SimpleType.ERROR).buildOrThrow();

    public static Type create(Type.PrimitiveType type) {
        return Type.newBuilder().setPrimitive(type).build();
    }

    public static Type create(Type.WellKnownType type) {
        return Type.newBuilder().setWellKnown(type).build();
    }

    public static Type create(Type target) {
        return Type.newBuilder().setType(target).build();
    }

    public static Type createList(Type elemType) {
        return Type.newBuilder().setListType(Type.ListType.newBuilder().setElemType(elemType)).build();
    }

    public static Type createMap(Type keyType, Type valueType) {
        return Type.newBuilder().setMapType(Type.MapType.newBuilder().setKeyType(keyType).setValueType(valueType)).build();
    }

    public static Type createMessage(String messageName) {
        return Type.newBuilder().setMessageType(messageName).build();
    }

    public static Type createTypeParam(String name) {
        return Type.newBuilder().setTypeParam(name).build();
    }

    public static Type createWrapper(Type.PrimitiveType primitive) {
        return Type.newBuilder().setWrapper(primitive).build();
    }

    public static Type createWrapper(Type type) {
        Preconditions.checkArgument(type.getTypeKindCase() == Type.TypeKindCase.PRIMITIVE);
        return CelProtoTypes.createWrapper(type.getPrimitive());
    }

    public static Type createOptionalType(Type paramType) {
        return Type.newBuilder().setAbstractType(Type.AbstractType.newBuilder().setName("optional_type").addParameterTypes(paramType).build()).build();
    }

    public static boolean isOptionalType(Type type) {
        return type.hasAbstractType() && type.getAbstractType().getName().equals("optional_type");
    }

    public static String format(Type type) {
        return CelTypes.format(CelProtoTypes.typeToCelType(type), false);
    }

    public static Type celTypeToType(CelType celType) {
        Type type = SIMPLE_CEL_KIND_TO_TYPE.get((Object)celType.kind());
        if (type != null) {
            if (celType instanceof NullableType) {
                return CelProtoTypes.createWrapper(type);
            }
            return type;
        }
        switch (celType.kind()) {
            case UNSPECIFIED: {
                return Type.getDefaultInstance();
            }
            case LIST: {
                ListType listType = (ListType)celType;
                if (listType.hasElemType()) {
                    return CelProtoTypes.createList(CelProtoTypes.celTypeToType(listType.elemType()));
                }
                return Type.newBuilder().setListType(Type.ListType.getDefaultInstance()).build();
            }
            case MAP: {
                MapType mapType = (MapType)celType;
                return CelProtoTypes.createMap(CelProtoTypes.celTypeToType(mapType.keyType()), CelProtoTypes.celTypeToType(mapType.valueType()));
            }
            case OPAQUE: {
                if (celType.name().equals("function")) {
                    Type.FunctionType.Builder functionBuilder = Type.FunctionType.newBuilder();
                    if (!celType.parameters().isEmpty()) {
                        functionBuilder.setResultType(CelProtoTypes.celTypeToType((CelType)celType.parameters().get(0))).addAllArgTypes(celType.parameters().stream().skip(1L).map(CelProtoTypes::celTypeToType).collect(ImmutableList.toImmutableList()));
                    }
                    return Type.newBuilder().setFunction(functionBuilder).build();
                }
                return Type.newBuilder().setAbstractType(Type.AbstractType.newBuilder().setName(celType.name()).addAllParameterTypes(celType.parameters().stream().map(CelProtoTypes::celTypeToType).collect(ImmutableList.toImmutableList()))).build();
            }
            case STRUCT: {
                return CelProtoTypes.createMessage(celType.name());
            }
            case TYPE: {
                TypeType typeType = (TypeType)celType;
                return CelProtoTypes.create(CelProtoTypes.celTypeToType(typeType.type()));
            }
            case TYPE_PARAM: {
                return CelProtoTypes.createTypeParam(celType.name());
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported type: %s", celType));
    }

    public static CelType typeToCelType(Type type) {
        CelType celType = PROTOBUF_TYPE_TO_CEL_TYPE_MAP.get(type);
        if (celType != null) {
            return celType;
        }
        switch (type.getTypeKindCase()) {
            case TYPEKIND_NOT_SET: {
                return UnspecifiedType.create();
            }
            case WRAPPER: {
                return NullableType.create(CelProtoTypes.typeToCelType(CelProtoTypes.create(type.getWrapper())));
            }
            case MESSAGE_TYPE: {
                return StructTypeReference.create(type.getMessageType());
            }
            case LIST_TYPE: {
                Type.ListType listType = type.getListType();
                if (listType.hasElemType()) {
                    return ListType.create(CelProtoTypes.typeToCelType(listType.getElemType()));
                }
                return ListType.create();
            }
            case MAP_TYPE: {
                Type.MapType mapType = type.getMapType();
                return MapType.create(CelProtoTypes.typeToCelType(mapType.getKeyType()), CelProtoTypes.typeToCelType(mapType.getValueType()));
            }
            case TYPE_PARAM: {
                return TypeParamType.create(type.getTypeParam());
            }
            case ABSTRACT_TYPE: {
                Type.AbstractType abstractType = type.getAbstractType();
                ImmutableList<CelType> params = abstractType.getParameterTypesList().stream().map(CelProtoTypes::typeToCelType).collect(ImmutableList.toImmutableList());
                if (abstractType.getName().equals("optional_type")) {
                    return OptionalType.create((CelType)params.get(0));
                }
                return OpaqueType.create(abstractType.getName(), params);
            }
            case TYPE: {
                return TypeType.create(CelProtoTypes.typeToCelType(type.getType()));
            }
            case FUNCTION: {
                Type.FunctionType functionType = type.getFunction();
                return CelTypes.createFunctionType(CelProtoTypes.typeToCelType(functionType.getResultType()), functionType.getArgTypesList().stream().map(CelProtoTypes::typeToCelType).collect(ImmutableList.toImmutableList()));
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported type: %s", type));
    }

    private CelProtoTypes() {
    }
}

