/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.types;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.Immutable;
import dev.cel.common.annotations.Internal;
import dev.cel.common.types.AutoValue_ListType;
import dev.cel.common.types.CelKind;
import dev.cel.common.types.CelType;

@CheckReturnValue
@Immutable
@AutoValue
public abstract class ListType
extends CelType {
    @Override
    public abstract CelKind kind();

    @Override
    public abstract String name();

    @Override
    public abstract ImmutableList<CelType> parameters();

    @Override
    public CelType withParameters(ImmutableList<CelType> parameters) {
        Preconditions.checkArgument(parameters.size() == 1);
        return ListType.create((CelType)parameters.get(0));
    }

    public boolean hasElemType() {
        return !this.parameters().isEmpty();
    }

    public CelType elemType() {
        return (CelType)this.parameters().get(0);
    }

    @Internal
    public static ListType create() {
        return new AutoValue_ListType(CelKind.LIST, "list", ImmutableList.of());
    }

    public static ListType create(CelType elemType) {
        return new AutoValue_ListType(CelKind.LIST, "list", ImmutableList.of(elemType));
    }
}

