/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.types;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.Immutable;
import dev.cel.common.types.AutoValue_MapType;
import dev.cel.common.types.CelKind;
import dev.cel.common.types.CelType;

@CheckReturnValue
@Immutable
@AutoValue
public abstract class MapType
extends CelType {
    @Override
    public abstract CelKind kind();

    @Override
    public abstract String name();

    @Override
    public abstract ImmutableList<CelType> parameters();

    @Override
    public CelType withParameters(ImmutableList<CelType> parameters) {
        Preconditions.checkArgument(this.parameters().size() == 2);
        return MapType.create((CelType)parameters.get(0), (CelType)parameters.get(1));
    }

    public CelType keyType() {
        return (CelType)this.parameters().get(0);
    }

    public CelType valueType() {
        return (CelType)this.parameters().get(1);
    }

    public static MapType create(CelType keyType, CelType valueType) {
        return new AutoValue_MapType(CelKind.MAP, "map", ImmutableList.of(keyType, valueType));
    }
}

