/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.types;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.Immutable;
import dev.cel.common.types.AutoValue_TypeType;
import dev.cel.common.types.CelKind;
import dev.cel.common.types.CelType;

@CheckReturnValue
@Immutable
@AutoValue
public abstract class TypeType
extends CelType {
    @Override
    public CelKind kind() {
        return CelKind.TYPE;
    }

    @Override
    public String name() {
        return "type";
    }

    public String containingTypeName() {
        CelType containingType = this.type();
        if (containingType.kind() == CelKind.DYN) {
            return "type";
        }
        return containingType.name();
    }

    @Override
    public abstract ImmutableList<CelType> parameters();

    public CelType type() {
        return (CelType)this.parameters().get(0);
    }

    @Override
    public CelType withParameters(ImmutableList<CelType> parameters) {
        Preconditions.checkArgument(parameters.size() == 1);
        return TypeType.create((CelType)parameters.get(0));
    }

    public static TypeType create(CelType type) {
        return new AutoValue_TypeType(ImmutableList.of(type));
    }
}

