/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.values;

import com.google.errorprone.annotations.Immutable;
import dev.cel.common.types.CelType;
import dev.cel.common.types.SimpleType;
import dev.cel.common.values.CelValue;

@Immutable
public final class DoubleValue
extends CelValue {
    private final double value;

    @Override
    public Double value() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    @Override
    public boolean isZeroValue() {
        return this.value() == 0.0;
    }

    @Override
    public CelType celType() {
        return SimpleType.DOUBLE;
    }

    public static DoubleValue create(double value) {
        return new DoubleValue(value);
    }

    public int hashCode() {
        int h2 = 1;
        h2 *= 1000003;
        return h2 ^= Double.hashCode(this.value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DoubleValue)) {
            return false;
        }
        return Double.doubleToLongBits(((DoubleValue)o).doubleValue()) == Double.doubleToLongBits(this.doubleValue());
    }

    private DoubleValue(double value) {
        this.value = value;
    }
}

