/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.values;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.Immutable;
import com.google.protobuf.Any;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MapEntry;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MessageLiteOrBuilder;
import com.google.protobuf.MessageOrBuilder;
import dev.cel.common.annotations.Internal;
import dev.cel.common.internal.CelDescriptorPool;
import dev.cel.common.internal.DynamicProto;
import dev.cel.common.internal.WellKnownProto;
import dev.cel.common.values.BaseProtoCelValueConverter;
import dev.cel.common.values.CelValue;
import dev.cel.common.values.IntValue;
import dev.cel.common.values.NullValue;
import dev.cel.common.values.ProtoMessageValue;
import dev.cel.common.values.UintValue;
import java.util.HashMap;
import java.util.List;

@Immutable
@Internal
public final class ProtoCelValueConverter
extends BaseProtoCelValueConverter {
    private final CelDescriptorPool celDescriptorPool;
    private final DynamicProto dynamicProto;

    public static ProtoCelValueConverter newInstance(CelDescriptorPool celDescriptorPool, DynamicProto dynamicProto) {
        return new ProtoCelValueConverter(celDescriptorPool, dynamicProto);
    }

    @Override
    public CelValue fromProtoMessageToCelValue(MessageLite msg) {
        return this.fromDescriptorMessageToCelValue((MessageOrBuilder)((Object)msg));
    }

    public CelValue fromDescriptorMessageToCelValue(MessageOrBuilder message) {
        WellKnownProto wellKnownProto;
        Preconditions.checkNotNull(message);
        if (message instanceof DynamicMessage) {
            message = this.dynamicProto.maybeAdaptDynamicMessage((DynamicMessage)message);
        }
        if ((wellKnownProto = (WellKnownProto)WellKnownProto.getByTypeName(message.getDescriptorForType().getFullName()).orElse(null)) == null) {
            return ProtoMessageValue.create((Message)message, this.celDescriptorPool, this);
        }
        return this.fromWellKnownProtoToCelValue(message, wellKnownProto);
    }

    @Override
    protected CelValue fromWellKnownProtoToCelValue(MessageLiteOrBuilder msg, WellKnownProto wellKnownProto) {
        MessageOrBuilder message = (MessageOrBuilder)msg;
        switch (wellKnownProto) {
            case ANY_VALUE: {
                Message unpackedMessage;
                try {
                    unpackedMessage = this.dynamicProto.unpack((Any)message);
                }
                catch (InvalidProtocolBufferException e) {
                    throw new IllegalStateException("Unpacking failed for message: " + message.getDescriptorForType().getFullName(), e);
                }
                return this.fromProtoMessageToCelValue(unpackedMessage);
            }
        }
        return super.fromWellKnownProtoToCelValue(message, wellKnownProto);
    }

    @Override
    public CelValue fromJavaObjectToCelValue(Object value) {
        if (value instanceof Descriptors.EnumValueDescriptor) {
            return IntValue.create(((Descriptors.EnumValueDescriptor)value).getNumber());
        }
        return super.fromJavaObjectToCelValue(value);
    }

    public CelValue fromProtoMessageFieldToCelValue(Message message, Descriptors.FieldDescriptor fieldDescriptor) {
        Preconditions.checkNotNull(message);
        Preconditions.checkNotNull(fieldDescriptor);
        Object result = message.getField(fieldDescriptor);
        switch (fieldDescriptor.getType()) {
            case MESSAGE: {
                if (WellKnownProto.isWrapperType(fieldDescriptor.getMessageType().getFullName()) && !message.hasField(fieldDescriptor)) {
                    return NullValue.NULL_VALUE;
                }
                if (fieldDescriptor.isMapField()) {
                    HashMap map = new HashMap();
                    for (Object entry : (List)result) {
                        Object mapValue;
                        Object mapKey;
                        if (entry instanceof MapEntry) {
                            MapEntry mapEntry = (MapEntry)entry;
                            mapKey = mapEntry.getKey();
                            mapValue = mapEntry.getValue();
                        } else if (entry instanceof DynamicMessage) {
                            DynamicMessage dynamicMessage = (DynamicMessage)entry;
                            Descriptors.FieldDescriptor keyFieldDescriptor = fieldDescriptor.getMessageType().findFieldByNumber(1);
                            Descriptors.FieldDescriptor valueFieldDescriptor = fieldDescriptor.getMessageType().findFieldByNumber(2);
                            mapKey = dynamicMessage.getField(keyFieldDescriptor);
                            mapValue = dynamicMessage.getField(valueFieldDescriptor);
                        } else {
                            throw new IllegalStateException("Unexpected map field type: " + entry);
                        }
                        map.put(mapKey, mapValue);
                    }
                    return this.fromJavaObjectToCelValue(map);
                }
                return this.fromDescriptorMessageToCelValue((MessageOrBuilder)result);
            }
            case UINT32: {
                return UintValue.create(((Integer)result).intValue());
            }
            case UINT64: {
                return UintValue.create((Long)result);
            }
        }
        return this.fromJavaObjectToCelValue(result);
    }

    private ProtoCelValueConverter(CelDescriptorPool celDescriptorPool, DynamicProto dynamicProto) {
        Preconditions.checkNotNull(celDescriptorPool);
        Preconditions.checkNotNull(dynamicProto);
        this.celDescriptorPool = celDescriptorPool;
        this.dynamicProto = dynamicProto;
    }
}

