/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.extensions;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import com.google.protobuf.ByteString;
import dev.cel.checker.CelCheckerBuilder;
import dev.cel.common.CelFunctionDecl;
import dev.cel.common.CelOverloadDecl;
import dev.cel.common.types.SimpleType;
import dev.cel.compiler.CelCompilerLibrary;
import dev.cel.runtime.CelFunctionBinding;
import dev.cel.runtime.CelRuntimeBuilder;
import dev.cel.runtime.CelRuntimeLibrary;
import java.util.Base64;

@Immutable
public class CelEncoderExtensions
implements CelCompilerLibrary,
CelRuntimeLibrary {
    private static final Base64.Encoder BASE64_ENCODER = Base64.getEncoder();
    private static final Base64.Decoder BASE64_DECODER = Base64.getDecoder();
    private final ImmutableSet<Function> functions = ImmutableSet.copyOf(Function.values());

    @Override
    public void setCheckerOptions(CelCheckerBuilder checkerBuilder) {
        this.functions.forEach(function -> checkerBuilder.addFunctionDeclarations(((Function)function).functionDecl));
    }

    @Override
    public void setRuntimeOptions(CelRuntimeBuilder runtimeBuilder) {
        this.functions.forEach(function -> runtimeBuilder.addFunctionBindings(((Function)function).functionBindings));
    }

    static enum Function {
        DECODE(CelFunctionDecl.newFunctionDeclaration("base64.decode", CelOverloadDecl.newGlobalOverload("base64_decode_string", SimpleType.BYTES, SimpleType.STRING)), ImmutableSet.of(CelFunctionBinding.from("base64_decode_string", String.class, str -> ByteString.copyFrom(BASE64_DECODER.decode((String)str))))),
        ENCODE(CelFunctionDecl.newFunctionDeclaration("base64.encode", CelOverloadDecl.newGlobalOverload("base64_encode_bytes", SimpleType.STRING, SimpleType.BYTES)), ImmutableSet.of(CelFunctionBinding.from("base64_encode_bytes", ByteString.class, bytes -> BASE64_ENCODER.encodeToString(bytes.toByteArray()))));

        private final CelFunctionDecl functionDecl;
        private final ImmutableSet<CelFunctionBinding> functionBindings;

        String getFunction() {
            return this.functionDecl.name();
        }

        private Function(CelFunctionDecl functionDecl, ImmutableSet<CelFunctionBinding> functionBindings) {
            this.functionDecl = functionDecl;
            this.functionBindings = functionBindings;
        }
    }
}

