/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.extensions;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import dev.cel.common.CelOptions;
import dev.cel.extensions.CelBindingsExtensions;
import dev.cel.extensions.CelEncoderExtensions;
import dev.cel.extensions.CelListsExtensions;
import dev.cel.extensions.CelMathExtensions;
import dev.cel.extensions.CelProtoExtensions;
import dev.cel.extensions.CelRegexExtensions;
import dev.cel.extensions.CelSetsExtensions;
import dev.cel.extensions.CelStringExtensions;
import dev.cel.extensions.SetsFunction;
import java.util.Arrays;
import java.util.Set;

public final class CelExtensions {
    private static final CelStringExtensions STRING_EXTENSIONS_ALL = new CelStringExtensions();
    private static final CelProtoExtensions PROTO_EXTENSIONS = new CelProtoExtensions();
    private static final CelBindingsExtensions BINDINGS_EXTENSIONS = new CelBindingsExtensions();
    private static final CelEncoderExtensions ENCODER_EXTENSIONS = new CelEncoderExtensions();
    private static final CelListsExtensions LISTS_EXTENSIONS_ALL = new CelListsExtensions();
    private static final CelRegexExtensions REGEX_EXTENSIONS = new CelRegexExtensions();

    public static CelStringExtensions strings() {
        return STRING_EXTENSIONS_ALL;
    }

    public static CelStringExtensions strings(CelStringExtensions.Function ... functions) {
        return CelExtensions.strings(ImmutableSet.copyOf(functions));
    }

    public static CelStringExtensions strings(Set<CelStringExtensions.Function> functions) {
        return new CelStringExtensions(functions);
    }

    public static CelProtoExtensions protos() {
        return PROTO_EXTENSIONS;
    }

    public static CelMathExtensions math(CelOptions celOptions) {
        return new CelMathExtensions(celOptions);
    }

    public static CelMathExtensions math(CelOptions celOptions, CelMathExtensions.Function ... functions) {
        return CelExtensions.math(celOptions, ImmutableSet.copyOf(functions));
    }

    public static CelMathExtensions math(CelOptions celOptions, Set<CelMathExtensions.Function> functions) {
        return new CelMathExtensions(celOptions, functions);
    }

    public static CelBindingsExtensions bindings() {
        return BINDINGS_EXTENSIONS;
    }

    public static CelEncoderExtensions encoders() {
        return ENCODER_EXTENSIONS;
    }

    public static CelSetsExtensions sets(CelOptions celOptions) {
        return new CelSetsExtensions(celOptions);
    }

    public static CelSetsExtensions sets(CelOptions celOptions, SetsFunction ... functions) {
        return CelExtensions.sets(celOptions, ImmutableSet.copyOf(functions));
    }

    public static CelSetsExtensions sets(CelOptions celOptions, Set<SetsFunction> functions) {
        return new CelSetsExtensions(celOptions, functions);
    }

    public static CelListsExtensions lists() {
        return LISTS_EXTENSIONS_ALL;
    }

    public static CelListsExtensions lists(CelListsExtensions.Function ... functions) {
        return CelExtensions.lists(ImmutableSet.copyOf(functions));
    }

    public static CelListsExtensions lists(Set<CelListsExtensions.Function> functions) {
        return new CelListsExtensions(functions);
    }

    public static CelRegexExtensions regex() {
        return REGEX_EXTENSIONS;
    }

    public static ImmutableSet<String> getAllFunctionNames() {
        return Streams.concat(Arrays.stream(CelMathExtensions.Function.values()).map(CelMathExtensions.Function::getFunction), Arrays.stream(CelStringExtensions.Function.values()).map(CelStringExtensions.Function::getFunction), Arrays.stream(SetsFunction.values()).map(SetsFunction::getFunction), Arrays.stream(CelEncoderExtensions.Function.values()).map(CelEncoderExtensions.Function::getFunction), Arrays.stream(CelListsExtensions.Function.values()).map(CelListsExtensions.Function::getFunction), Arrays.stream(CelRegexExtensions.Function.values()).map(CelRegexExtensions.Function::getFunction)).collect(ImmutableSet.toImmutableSet());
    }

    private CelExtensions() {
    }
}

