/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.extensions;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.common.primitives.UnsignedLong;
import com.google.protobuf.ByteString;
import com.google.protobuf.Duration;
import com.google.protobuf.Message;
import com.google.protobuf.NullValue;
import com.google.protobuf.Timestamp;
import dev.cel.checker.CelCheckerBuilder;
import dev.cel.common.CelFunctionDecl;
import dev.cel.common.CelIssue;
import dev.cel.common.CelOptions;
import dev.cel.common.CelOverloadDecl;
import dev.cel.common.CelVarDecl;
import dev.cel.common.ast.CelExpr;
import dev.cel.common.types.CelType;
import dev.cel.common.types.ListType;
import dev.cel.common.types.MapType;
import dev.cel.common.types.OptionalType;
import dev.cel.common.types.SimpleType;
import dev.cel.common.types.TypeParamType;
import dev.cel.common.types.TypeType;
import dev.cel.compiler.CelCompilerLibrary;
import dev.cel.parser.CelMacro;
import dev.cel.parser.CelMacroExprFactory;
import dev.cel.parser.CelParserBuilder;
import dev.cel.parser.Operator;
import dev.cel.runtime.CelFunctionBinding;
import dev.cel.runtime.CelInternalRuntimeLibrary;
import dev.cel.runtime.CelRuntimeBuilder;
import dev.cel.runtime.RuntimeEquality;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class CelOptionalLibrary
implements CelCompilerLibrary,
CelInternalRuntimeLibrary {
    public static final CelOptionalLibrary INSTANCE = new CelOptionalLibrary();
    private static final String UNUSED_ITER_VAR = "#unused";

    @Override
    public void setParserOptions(CelParserBuilder parserBuilder) {
        if (!parserBuilder.getOptions().enableOptionalSyntax()) {
            parserBuilder.setOptions(parserBuilder.getOptions().toBuilder().enableOptionalSyntax(true).build());
        }
        parserBuilder.addMacros(CelMacro.newReceiverMacro("optMap", 2, CelOptionalLibrary::expandOptMap));
        parserBuilder.addMacros(CelMacro.newReceiverMacro("optFlatMap", 2, CelOptionalLibrary::expandOptFlatMap));
    }

    @Override
    public void setCheckerOptions(CelCheckerBuilder checkerBuilder) {
        TypeParamType paramTypeK = TypeParamType.create("K");
        TypeParamType paramTypeV = TypeParamType.create("V");
        OptionalType optionalTypeV = OptionalType.create(paramTypeV);
        ListType listTypeV = ListType.create(paramTypeV);
        MapType mapTypeKv = MapType.create(paramTypeK, paramTypeV);
        checkerBuilder.addVarDeclarations(CelVarDecl.newVarDeclaration("optional_type", TypeType.create(optionalTypeV)));
        checkerBuilder.addFunctionDeclarations(CelFunctionDecl.newFunctionDeclaration(Function.OPTIONAL_OF.getFunction(), CelOverloadDecl.newGlobalOverload("optional_of", (CelType)optionalTypeV, paramTypeV)), CelFunctionDecl.newFunctionDeclaration(Function.OPTIONAL_OF_NON_ZERO_VALUE.getFunction(), CelOverloadDecl.newGlobalOverload("optional_ofNonZeroValue", (CelType)optionalTypeV, paramTypeV)), CelFunctionDecl.newFunctionDeclaration(Function.OPTIONAL_NONE.getFunction(), CelOverloadDecl.newGlobalOverload("optional_none", (CelType)optionalTypeV, new CelType[0])), CelFunctionDecl.newFunctionDeclaration(Function.VALUE.getFunction(), CelOverloadDecl.newMemberOverload("optional_value", (CelType)paramTypeV, optionalTypeV)), CelFunctionDecl.newFunctionDeclaration(Function.HAS_VALUE.getFunction(), CelOverloadDecl.newMemberOverload("optional_hasValue", SimpleType.BOOL, optionalTypeV)), CelFunctionDecl.newFunctionDeclaration(Function.OPTIONAL_UNWRAP.getFunction(), CelOverloadDecl.newGlobalOverload("optional_unwrap_list", (CelType)listTypeV, ListType.create(optionalTypeV))), CelFunctionDecl.newFunctionDeclaration("or", CelOverloadDecl.newMemberOverload("optional_or_optional", (CelType)optionalTypeV, optionalTypeV, optionalTypeV)), CelFunctionDecl.newFunctionDeclaration("orValue", CelOverloadDecl.newMemberOverload("optional_orValue_value", (CelType)paramTypeV, optionalTypeV, paramTypeV)), CelFunctionDecl.newFunctionDeclaration(Operator.OPTIONAL_SELECT.getFunction(), CelOverloadDecl.newGlobalOverload("select_optional_field", (CelType)optionalTypeV, SimpleType.DYN, SimpleType.STRING)), CelFunctionDecl.newFunctionDeclaration(Operator.OPTIONAL_INDEX.getFunction(), CelOverloadDecl.newGlobalOverload("list_optindex_optional_int", (CelType)optionalTypeV, listTypeV, SimpleType.INT), CelOverloadDecl.newGlobalOverload("optional_list_optindex_optional_int", (CelType)optionalTypeV, OptionalType.create(listTypeV), SimpleType.INT), CelOverloadDecl.newGlobalOverload("map_optindex_optional_value", (CelType)optionalTypeV, mapTypeKv, paramTypeK), CelOverloadDecl.newGlobalOverload("optional_map_optindex_optional_value", (CelType)optionalTypeV, OptionalType.create(mapTypeKv), paramTypeK)), CelFunctionDecl.newFunctionDeclaration(Operator.INDEX.getFunction(), CelOverloadDecl.newGlobalOverload("optional_list_index_int", (CelType)optionalTypeV, OptionalType.create(listTypeV), SimpleType.INT), CelOverloadDecl.newGlobalOverload("optional_map_index_value", (CelType)optionalTypeV, OptionalType.create(mapTypeKv), paramTypeK)));
    }

    @Override
    public void setRuntimeOptions(CelRuntimeBuilder runtimeBuilder) {
        throw new UnsupportedOperationException("Unsupported");
    }

    @Override
    public void setRuntimeOptions(CelRuntimeBuilder runtimeBuilder, RuntimeEquality runtimeEquality, CelOptions celOptions) {
        CelFunctionBinding[] celFunctionBindingArray = new CelFunctionBinding[13];
        celFunctionBindingArray[0] = CelFunctionBinding.from("optional_of", Object.class, Optional::of);
        celFunctionBindingArray[1] = CelFunctionBinding.from("optional_ofNonZeroValue", Object.class, val -> {
            if (CelOptionalLibrary.isZeroValue(val)) {
                return Optional.empty();
            }
            return Optional.of(val);
        });
        celFunctionBindingArray[2] = CelFunctionBinding.from("optional_unwrap_list", Collection.class, CelOptionalLibrary::elideOptionalCollection);
        celFunctionBindingArray[3] = CelFunctionBinding.from("optional_none", ImmutableList.of(), val -> Optional.empty());
        celFunctionBindingArray[4] = CelFunctionBinding.from("optional_value", Object.class, val -> ((Optional)val).get());
        celFunctionBindingArray[5] = CelFunctionBinding.from("optional_hasValue", Object.class, val -> ((Optional)val).isPresent());
        celFunctionBindingArray[6] = CelFunctionBinding.from("select_optional_field", Map.class, String.class, runtimeEquality::findInMap);
        celFunctionBindingArray[7] = CelFunctionBinding.from("map_optindex_optional_value", Map.class, Object.class, runtimeEquality::findInMap);
        celFunctionBindingArray[8] = CelFunctionBinding.from("optional_map_optindex_optional_value", Optional.class, Object.class, (optionalMap, key) -> CelOptionalLibrary.indexOptionalMap(optionalMap, key, runtimeEquality));
        celFunctionBindingArray[9] = CelFunctionBinding.from("optional_map_index_value", Optional.class, Object.class, (optionalMap, key) -> CelOptionalLibrary.indexOptionalMap(optionalMap, key, runtimeEquality));
        celFunctionBindingArray[10] = CelFunctionBinding.from("optional_list_index_int", Optional.class, Long.class, CelOptionalLibrary::indexOptionalList);
        celFunctionBindingArray[11] = CelFunctionBinding.from("list_optindex_optional_int", List.class, Long.class, (list, index) -> {
            int castIndex = Ints.checkedCast(index);
            if (castIndex < 0 || castIndex >= list.size()) {
                return Optional.empty();
            }
            return Optional.of(list.get(castIndex));
        });
        celFunctionBindingArray[12] = CelFunctionBinding.from("optional_list_optindex_optional_int", Optional.class, Long.class, CelOptionalLibrary::indexOptionalList);
        runtimeBuilder.addFunctionBindings(celFunctionBindingArray);
    }

    private static ImmutableList<Object> elideOptionalCollection(Collection<Optional<Object>> list) {
        return list.stream().filter(Optional::isPresent).map(Optional::get).collect(ImmutableList.toImmutableList());
    }

    private static boolean isZeroValue(Object val) {
        if (val instanceof Boolean) {
            return (Boolean)val == false;
        }
        if (val instanceof Long) {
            return (Long)val == 0L;
        }
        if (val instanceof Double) {
            return (Double)val == 0.0;
        }
        if (val instanceof String) {
            return ((String)val).isEmpty();
        }
        if (val instanceof UnsignedLong) {
            return val.equals(UnsignedLong.ZERO);
        }
        if (val instanceof Collection) {
            return ((Collection)val).isEmpty();
        }
        if (val instanceof Map) {
            return ((Map)val).isEmpty();
        }
        if (val instanceof ByteString) {
            return ((ByteString)val).size() == 0;
        }
        if (val instanceof Duration) {
            return val.equals(((Duration)val).getDefaultInstanceForType());
        }
        if (val instanceof Timestamp) {
            return val.equals(((Timestamp)val).getDefaultInstanceForType());
        }
        if (val instanceof Message) {
            return val.equals(((Message)val).getDefaultInstanceForType());
        }
        return val instanceof NullValue;
    }

    private static Optional<CelExpr> expandOptMap(CelMacroExprFactory exprFactory, CelExpr target, ImmutableList<CelExpr> arguments) {
        Preconditions.checkNotNull(exprFactory);
        Preconditions.checkNotNull(target);
        Preconditions.checkArgument(arguments.size() == 2);
        CelExpr varIdent = Preconditions.checkNotNull((CelExpr)arguments.get(0));
        if (varIdent.exprKind().getKind() != CelExpr.ExprKind.Kind.IDENT) {
            return Optional.of(exprFactory.reportError(CelIssue.formatError(exprFactory.getSourceLocation(varIdent), "optMap() variable name must be a simple identifier")));
        }
        CelExpr mapExpr = Preconditions.checkNotNull((CelExpr)arguments.get(1));
        String varName = varIdent.ident().name();
        return Optional.of(exprFactory.newGlobalCall(Operator.CONDITIONAL.getFunction(), exprFactory.newReceiverCall(Function.HAS_VALUE.getFunction(), target, new CelExpr[0]), exprFactory.newGlobalCall(Function.OPTIONAL_OF.getFunction(), exprFactory.fold(UNUSED_ITER_VAR, exprFactory.newList(new CelExpr[0]), varName, exprFactory.newReceiverCall(Function.VALUE.getFunction(), exprFactory.copy(target), new CelExpr[0]), exprFactory.newBoolLiteral(true), exprFactory.newIdentifier(varName), mapExpr)), exprFactory.newGlobalCall(Function.OPTIONAL_NONE.getFunction(), new CelExpr[0])));
    }

    private static Optional<CelExpr> expandOptFlatMap(CelMacroExprFactory exprFactory, CelExpr target, ImmutableList<CelExpr> arguments) {
        Preconditions.checkNotNull(exprFactory);
        Preconditions.checkNotNull(target);
        Preconditions.checkArgument(arguments.size() == 2);
        CelExpr varIdent = Preconditions.checkNotNull((CelExpr)arguments.get(0));
        if (varIdent.exprKind().getKind() != CelExpr.ExprKind.Kind.IDENT) {
            return Optional.of(exprFactory.reportError(CelIssue.formatError(exprFactory.getSourceLocation(varIdent), "optFlatMap() variable name must be a simple identifier")));
        }
        CelExpr mapExpr = Preconditions.checkNotNull((CelExpr)arguments.get(1));
        String varName = varIdent.ident().name();
        return Optional.of(exprFactory.newGlobalCall(Operator.CONDITIONAL.getFunction(), exprFactory.newReceiverCall(Function.HAS_VALUE.getFunction(), target, new CelExpr[0]), exprFactory.fold(UNUSED_ITER_VAR, exprFactory.newList(new CelExpr[0]), varName, exprFactory.newReceiverCall(Function.VALUE.getFunction(), exprFactory.copy(target), new CelExpr[0]), exprFactory.newBoolLiteral(true), exprFactory.newIdentifier(varName), mapExpr), exprFactory.newGlobalCall(Function.OPTIONAL_NONE.getFunction(), new CelExpr[0])));
    }

    private static Object indexOptionalMap(Optional<?> optionalMap, Object key, RuntimeEquality runtimeEquality) {
        if (!optionalMap.isPresent()) {
            return Optional.empty();
        }
        Map map = (Map)optionalMap.get();
        return runtimeEquality.findInMap(map, key);
    }

    private static Object indexOptionalList(Optional<?> optionalList, long index) {
        if (!optionalList.isPresent()) {
            return Optional.empty();
        }
        List list = (List)optionalList.get();
        int castIndex = Ints.checkedCast(index);
        if (castIndex < 0 || castIndex >= list.size()) {
            return Optional.empty();
        }
        return Optional.of(list.get(castIndex));
    }

    private CelOptionalLibrary() {
    }

    public static enum Function {
        VALUE("value"),
        HAS_VALUE("hasValue"),
        OPTIONAL_NONE("optional.none"),
        OPTIONAL_OF("optional.of"),
        OPTIONAL_UNWRAP("optional.unwrap"),
        OPTIONAL_OF_NON_ZERO_VALUE("optional.ofNonZeroValue"),
        OR("or"),
        OR_VALUE("orValue");

        private final String functionName;

        public String getFunction() {
            return this.functionName;
        }

        private Function(String functionName) {
            this.functionName = functionName;
        }
    }
}

