/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.extensions;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import com.google.re2j.Matcher;
import com.google.re2j.Pattern;
import com.google.re2j.PatternSyntaxException;
import dev.cel.checker.CelCheckerBuilder;
import dev.cel.common.CelFunctionDecl;
import dev.cel.common.CelOverloadDecl;
import dev.cel.common.types.CelType;
import dev.cel.common.types.ListType;
import dev.cel.common.types.OptionalType;
import dev.cel.common.types.SimpleType;
import dev.cel.compiler.CelCompilerLibrary;
import dev.cel.runtime.CelFunctionBinding;
import dev.cel.runtime.CelRuntimeBuilder;
import dev.cel.runtime.CelRuntimeLibrary;
import java.util.Optional;
import java.util.Set;

@Immutable
final class CelRegexExtensions
implements CelCompilerLibrary,
CelRuntimeLibrary {
    private static final String REGEX_REPLACE_FUNCTION = "regex.replace";
    private static final String REGEX_EXTRACT_FUNCTION = "regex.extract";
    private static final String REGEX_EXTRACT_ALL_FUNCTION = "regex.extractAll";
    private final ImmutableSet<Function> functions;

    CelRegexExtensions() {
        this.functions = ImmutableSet.copyOf(Function.values());
    }

    CelRegexExtensions(Set<Function> functions) {
        this.functions = ImmutableSet.copyOf(functions);
    }

    @Override
    public void setCheckerOptions(CelCheckerBuilder checkerBuilder) {
        this.functions.forEach(function -> checkerBuilder.addFunctionDeclarations(((Function)function).functionDecl));
    }

    @Override
    public void setRuntimeOptions(CelRuntimeBuilder runtimeBuilder) {
        this.functions.forEach(function -> runtimeBuilder.addFunctionBindings(((Function)function).functionBindings));
    }

    private static Pattern compileRegexPattern(String regex) {
        try {
            return Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("Failed to compile regex: " + regex, e);
        }
    }

    private static String replace(String target, String regex, String replaceStr) {
        return CelRegexExtensions.replaceN(target, regex, replaceStr, -1L);
    }

    private static String replaceN(String target, String regex, String replaceStr, long replaceCount) {
        if (replaceCount == 0L) {
            return target;
        }
        if (replaceCount < 0L) {
            replaceCount = -1L;
        }
        Pattern pattern = CelRegexExtensions.compileRegexPattern(regex);
        Matcher matcher = pattern.matcher(target);
        StringBuffer sb = new StringBuffer();
        int counter = 0;
        while (matcher.find() && (replaceCount == -1L || (long)counter < replaceCount)) {
            String processedReplacement = CelRegexExtensions.replaceStrValidator(matcher, replaceStr);
            matcher.appendReplacement(sb, Matcher.quoteReplacement(processedReplacement));
            ++counter;
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static String replaceStrValidator(Matcher matcher, String replacement) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < replacement.length(); ++i) {
            char nextChar;
            char c = replacement.charAt(i);
            if (c != '\\') {
                sb.append(c);
                continue;
            }
            if (i + 1 >= replacement.length()) {
                throw new IllegalArgumentException("Invalid replacement string: \\ not allowed at end");
            }
            if (Character.isDigit(nextChar = replacement.charAt(++i))) {
                int groupCount;
                int groupNum = Character.digit(nextChar, 10);
                if (groupNum > (groupCount = matcher.groupCount())) {
                    throw new IllegalArgumentException("Replacement string references group " + groupNum + " but regex has only " + groupCount + " group(s)");
                }
                String groupValue = matcher.group(groupNum);
                if (groupValue == null) continue;
                sb.append(groupValue);
                continue;
            }
            if (nextChar == '\\') {
                sb.append('\\');
                continue;
            }
            throw new IllegalArgumentException("Invalid replacement string: \\ must be followed by a digit");
        }
        return sb.toString();
    }

    private static Optional<String> extract(String target, String regex) {
        Pattern pattern = CelRegexExtensions.compileRegexPattern(regex);
        Matcher matcher = pattern.matcher(target);
        if (!matcher.find()) {
            return Optional.empty();
        }
        int groupCount = matcher.groupCount();
        if (groupCount > 1) {
            throw new IllegalArgumentException("Regular expression has more than one capturing group: " + regex);
        }
        String result = groupCount == 1 ? matcher.group(1) : matcher.group(0);
        return Optional.ofNullable(result);
    }

    private static ImmutableList<String> extractAll(String target, String regex) {
        boolean hasOneGroup;
        Pattern pattern = CelRegexExtensions.compileRegexPattern(regex);
        Matcher matcher = pattern.matcher(target);
        if (matcher.groupCount() > 1) {
            throw new IllegalArgumentException("Regular expression has more than one capturing group: " + regex);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        boolean bl = hasOneGroup = matcher.groupCount() == 1;
        while (matcher.find()) {
            if (hasOneGroup) {
                String group2 = matcher.group(1);
                if (group2 == null) continue;
                builder.add(group2);
                continue;
            }
            builder.add(matcher.group(0));
        }
        return builder.build();
    }

    static enum Function {
        REPLACE(CelFunctionDecl.newFunctionDeclaration("regex.replace", CelOverloadDecl.newGlobalOverload("regex_replaceAll_string_string_string", "Replaces all the matched values using the given replace string.", SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING), CelOverloadDecl.newGlobalOverload("regex_replaceCount_string_string_string_int", "Replaces the given number of matched values using the given replace string.", SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.INT)), ImmutableSet.of(CelFunctionBinding.from("regex_replaceAll_string_string_string", ImmutableList.of(String.class, String.class, String.class), args -> {
            String target = (String)args[0];
            String pattern = (String)args[1];
            String replaceStr = (String)args[2];
            return CelRegexExtensions.replace(target, pattern, replaceStr);
        }), CelFunctionBinding.from("regex_replaceCount_string_string_string_int", ImmutableList.of(String.class, String.class, String.class, Long.class), args -> {
            String target = (String)args[0];
            String pattern = (String)args[1];
            String replaceStr = (String)args[2];
            long count = (Long)args[3];
            return CelRegexExtensions.replaceN(target, pattern, replaceStr, count);
        }))),
        EXTRACT(CelFunctionDecl.newFunctionDeclaration("regex.extract", CelOverloadDecl.newGlobalOverload("regex_extract_string_string", "Returns the first substring that matches the regex.", (CelType)OptionalType.create(SimpleType.STRING), SimpleType.STRING, SimpleType.STRING)), ImmutableSet.of(CelFunctionBinding.from("regex_extract_string_string", String.class, String.class, (x$0, x$1) -> CelRegexExtensions.access$100(x$0, x$1)))),
        EXTRACTALL(CelFunctionDecl.newFunctionDeclaration("regex.extractAll", CelOverloadDecl.newGlobalOverload("regex_extractAll_string_string", "Returns an array of all substrings that match the regex.", (CelType)ListType.create(SimpleType.STRING), SimpleType.STRING, SimpleType.STRING)), ImmutableSet.of(CelFunctionBinding.from("regex_extractAll_string_string", String.class, String.class, (x$0, x$1) -> CelRegexExtensions.access$000(x$0, x$1))));

        private final CelFunctionDecl functionDecl;
        private final ImmutableSet<CelFunctionBinding> functionBindings;

        String getFunction() {
            return this.functionDecl.name();
        }

        private Function(CelFunctionDecl functionDecl, ImmutableSet<CelFunctionBinding> functionBindings) {
            this.functionDecl = functionDecl;
            this.functionBindings = functionBindings;
        }
    }
}

