/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.optimizer;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.cel.common.annotations.Internal;
import dev.cel.common.ast.CelExprIdGeneratorFactory;
import dev.cel.common.ast.CelMutableExpr;
import java.util.List;

@Internal
final class MutableExprVisitor {
    private final CelMutableExpr newExpr;
    private final CelExprIdGeneratorFactory.ExprIdGenerator celExprIdGenerator;
    private final long iterationLimit;
    private int iterationCount;
    private long exprIdToReplace;

    static MutableExprVisitor newInstance(CelExprIdGeneratorFactory.ExprIdGenerator idGenerator, CelMutableExpr newExpr, long exprIdToReplace, long iterationLimit) {
        return new MutableExprVisitor(idGenerator, newExpr, exprIdToReplace, iterationLimit * 2L);
    }

    CelMutableExpr visit(CelMutableExpr root) {
        if ((long)(++this.iterationCount) > this.iterationLimit) {
            throw new IllegalStateException("Max iteration count reached.");
        }
        if (root.id() == this.exprIdToReplace) {
            this.exprIdToReplace = Integer.MIN_VALUE;
            this.newExpr.setId(root.id());
            return this.visit(this.newExpr);
        }
        root.setId(this.celExprIdGenerator.generate(root.id()));
        switch (root.getKind()) {
            case SELECT: {
                return this.visit(root, root.select());
            }
            case CALL: {
                return this.visit(root, root.call());
            }
            case LIST: {
                return this.visit(root, root.list());
            }
            case STRUCT: {
                return this.visit(root, root.struct());
            }
            case MAP: {
                return this.visit(root, root.map());
            }
            case COMPREHENSION: {
                return this.visit(root, root.comprehension());
            }
            case CONSTANT: 
            case IDENT: 
            case NOT_SET: {
                return root;
            }
        }
        throw new IllegalArgumentException("unexpected root kind: " + (Object)((Object)root.getKind()));
    }

    @CanIgnoreReturnValue
    private CelMutableExpr visit(CelMutableExpr expr, CelMutableExpr.CelMutableSelect select) {
        select.setOperand(this.visit(select.operand()));
        return expr;
    }

    @CanIgnoreReturnValue
    private CelMutableExpr visit(CelMutableExpr expr, CelMutableExpr.CelMutableCall call) {
        if (call.target().isPresent()) {
            call.setTarget(this.visit(call.target().get()));
        }
        List<CelMutableExpr> argsBuilders = call.args();
        for (int i = 0; i < argsBuilders.size(); ++i) {
            CelMutableExpr arg = argsBuilders.get(i);
            call.setArg(i, this.visit(arg));
        }
        return expr;
    }

    @CanIgnoreReturnValue
    private CelMutableExpr visit(CelMutableExpr expr, CelMutableExpr.CelMutableStruct struct) {
        List<CelMutableExpr.CelMutableStruct.Entry> entries = struct.entries();
        for (CelMutableExpr.CelMutableStruct.Entry entry : entries) {
            entry.setId(this.celExprIdGenerator.generate(entry.id()));
            entry.setValue(this.visit(entry.value()));
        }
        return expr;
    }

    @CanIgnoreReturnValue
    private CelMutableExpr visit(CelMutableExpr expr, CelMutableExpr.CelMutableMap map) {
        List<CelMutableExpr.CelMutableMap.Entry> entriesBuilders = map.entries();
        for (CelMutableExpr.CelMutableMap.Entry entry : entriesBuilders) {
            entry.setId(this.celExprIdGenerator.generate(entry.id()));
            entry.setKey(this.visit(entry.key()));
            entry.setValue(this.visit(entry.value()));
        }
        return expr;
    }

    @CanIgnoreReturnValue
    private CelMutableExpr visit(CelMutableExpr expr, CelMutableExpr.CelMutableList list) {
        List<CelMutableExpr> elementsBuilders = list.elements();
        for (int i = 0; i < elementsBuilders.size(); ++i) {
            CelMutableExpr elem = elementsBuilders.get(i);
            list.setElement(i, this.visit(elem));
        }
        return expr;
    }

    @CanIgnoreReturnValue
    private CelMutableExpr visit(CelMutableExpr expr, CelMutableExpr.CelMutableComprehension comprehension) {
        comprehension.setIterRange(this.visit(comprehension.iterRange()));
        comprehension.setAccuInit(this.visit(comprehension.accuInit()));
        comprehension.setLoopCondition(this.visit(comprehension.loopCondition()));
        comprehension.setLoopStep(this.visit(comprehension.loopStep()));
        comprehension.setResult(this.visit(comprehension.result()));
        return expr;
    }

    private MutableExprVisitor(CelExprIdGeneratorFactory.ExprIdGenerator celExprIdGenerator, CelMutableExpr newExpr, long exprId, long iterationLimit) {
        Preconditions.checkState(iterationLimit > 0L);
        this.iterationLimit = iterationLimit;
        this.celExprIdGenerator = celExprIdGenerator;
        this.newExpr = newExpr;
        this.exprIdToReplace = exprId;
    }
}

