/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.optimizer.optimizers;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.cel.bundle.Cel;
import dev.cel.bundle.CelBuilder;
import dev.cel.common.CelAbstractSyntaxTree;
import dev.cel.common.CelFunctionDecl;
import dev.cel.common.CelMutableAst;
import dev.cel.common.CelMutableSource;
import dev.cel.common.CelOverloadDecl;
import dev.cel.common.CelSource;
import dev.cel.common.CelValidationException;
import dev.cel.common.CelVarDecl;
import dev.cel.common.ast.CelExpr;
import dev.cel.common.ast.CelMutableExpr;
import dev.cel.common.ast.CelMutableExprConverter;
import dev.cel.common.navigation.CelNavigableExpr;
import dev.cel.common.navigation.CelNavigableMutableAst;
import dev.cel.common.navigation.CelNavigableMutableExpr;
import dev.cel.common.navigation.TraversalOrder;
import dev.cel.common.types.CelType;
import dev.cel.common.types.ListType;
import dev.cel.common.types.SimpleType;
import dev.cel.optimizer.AstMutator;
import dev.cel.optimizer.CelAstOptimizer;
import dev.cel.optimizer.optimizers.AutoValue_SubexpressionOptimizer_SubexpressionOptimizerOptions;
import dev.cel.optimizer.optimizers.DefaultOptimizerConstants;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class SubexpressionOptimizer
implements CelAstOptimizer {
    private static final SubexpressionOptimizer INSTANCE = new SubexpressionOptimizer(SubexpressionOptimizerOptions.newBuilder().build());
    private static final String BIND_IDENTIFIER_PREFIX = "@r";
    private static final String MANGLED_COMPREHENSION_ITER_VAR_PREFIX = "@it";
    private static final String MANGLED_COMPREHENSION_ACCU_VAR_PREFIX = "@ac";
    private static final String CEL_BLOCK_FUNCTION = "cel.@block";
    private static final String BLOCK_INDEX_PREFIX = "@index";
    private static final CelSource.Extension CEL_BLOCK_AST_EXTENSION_TAG = CelSource.Extension.create("cel_block", CelSource.Extension.Version.of(1L, 1L), CelSource.Extension.Component.COMPONENT_RUNTIME);
    private final SubexpressionOptimizerOptions cseOptions;
    private final AstMutator astMutator;
    private final ImmutableSet<String> cseEliminableFunctions;

    public static SubexpressionOptimizer getInstance() {
        return INSTANCE;
    }

    public static SubexpressionOptimizer newInstance(SubexpressionOptimizerOptions cseOptions) {
        return new SubexpressionOptimizer(cseOptions);
    }

    @Override
    public CelAstOptimizer.OptimizationResult optimize(CelAbstractSyntaxTree ast, Cel cel) {
        CelAstOptimizer.OptimizationResult result = this.cseOptions.enableCelBlock() ? this.optimizeUsingCelBlock(ast, cel) : this.optimizeUsingCelBind(ast);
        SubexpressionOptimizer.verifyOptimizedAstCorrectness(result.optimizedAst());
        return result;
    }

    private CelAstOptimizer.OptimizationResult optimizeUsingCelBlock(CelAbstractSyntaxTree ast, Cel cel) {
        CelNavigableMutableAst navAst;
        List<CelMutableExpr> cseCandidates;
        int iterCount;
        CelMutableAst astToModify = CelMutableAst.fromCelAst(ast);
        if (!this.cseOptions.populateMacroCalls()) {
            astToModify.source().clearMacroCalls();
        }
        AstMutator.MangledComprehensionAst mangledComprehensionAst = this.astMutator.mangleComprehensionIdentifierNames(astToModify, MANGLED_COMPREHENSION_ITER_VAR_PREFIX, MANGLED_COMPREHENSION_ACCU_VAR_PREFIX, false);
        astToModify = mangledComprehensionAst.mutableAst();
        CelMutableSource sourceToModify = astToModify.source();
        int blockIdentifierIndex = 0;
        ArrayList<CelMutableExpr> subexpressions = new ArrayList<CelMutableExpr>();
        for (iterCount = 0; iterCount < this.cseOptions.iterationLimit() && !(cseCandidates = this.getCseCandidates(navAst = CelNavigableMutableAst.fromAst(astToModify))).isEmpty(); ++iterCount) {
            subexpressions.add(cseCandidates.get(0));
            String blockIdentifier = BLOCK_INDEX_PREFIX + blockIdentifierIndex++;
            for (CelMutableExpr cseCandidate : cseCandidates) {
                ++iterCount;
                astToModify = this.astMutator.replaceSubtree(navAst, CelNavigableMutableAst.fromAst(CelMutableAst.of(CelMutableExpr.ofIdent(blockIdentifier), navAst.getAst().source())), cseCandidate.id());
                sourceToModify.addAllMacroCalls(astToModify.source().getMacroCalls());
                astToModify = CelMutableAst.of(astToModify.expr(), sourceToModify);
            }
        }
        if (iterCount >= this.cseOptions.iterationLimit()) {
            throw new IllegalStateException("Max iteration count reached.");
        }
        if (iterCount == 0) {
            return CelAstOptimizer.OptimizationResult.create(astToModify.toParsedAst());
        }
        ImmutableList.Builder newVarDecls = ImmutableList.builder();
        mangledComprehensionAst.mangledComprehensionMap().forEach((name, type) -> {
            type.iterVarType().ifPresent(iterVarType -> newVarDecls.add(CelVarDecl.newVarDeclaration(name.iterVarName(), iterVarType)));
            newVarDecls.add(CelVarDecl.newVarDeclaration(name.resultName(), type.resultType()));
        });
        newVarDecls.addAll(SubexpressionOptimizer.newBlockIndexVariableDeclarations(cel, (ImmutableList<CelVarDecl>)newVarDecls.build(), subexpressions));
        astToModify = this.astMutator.wrapAstWithNewCelBlock(CEL_BLOCK_FUNCTION, astToModify, subexpressions);
        astToModify = this.astMutator.renumberIdsConsecutively(astToModify);
        CelAbstractSyntaxTree optimizedAst = SubexpressionOptimizer.tagAstExtension(astToModify.toParsedAst());
        return CelAstOptimizer.OptimizationResult.create(optimizedAst, (ImmutableList<CelVarDecl>)newVarDecls.build(), ImmutableList.of(SubexpressionOptimizer.newCelBlockFunctionDecl(ast.getResultType())));
    }

    @VisibleForTesting
    static void verifyOptimizedAstCorrectness(CelAbstractSyntaxTree ast) {
        CelNavigableExpr celNavigableExpr = CelNavigableExpr.fromExpr(ast.getExpr());
        ImmutableList allCelBlocks = celNavigableExpr.allNodes().map(rec$ -> (CelExpr)((CelNavigableExpr)rec$).expr()).filter(expr -> expr.callOrDefault().function().equals(CEL_BLOCK_FUNCTION)).collect(ImmutableList.toImmutableList());
        if (allCelBlocks.isEmpty()) {
            return;
        }
        CelExpr celBlockExpr = (CelExpr)allCelBlocks.get(0);
        Verify.verify(allCelBlocks.size() == 1, "Expected 1 cel.block function to be present but found %s", allCelBlocks.size());
        Verify.verify(((CelExpr)celNavigableExpr.expr()).equals(celBlockExpr), "Expected cel.block to be present at root", new Object[0]);
        CelExpr.CelCall celBlockCall = celBlockExpr.call();
        List subexprs = ((CelExpr)celBlockCall.args().get(0)).list().elements();
        for (int i = 0; i < ((AbstractCollection)((Object)subexprs)).size(); ++i) {
            SubexpressionOptimizer.verifyBlockIndex((CelExpr)subexprs.get(i), i);
        }
        CelExpr blockResult = (CelExpr)celBlockCall.args().get(1);
        SubexpressionOptimizer.verifyBlockIndex(blockResult, ((AbstractCollection)((Object)subexprs)).size());
        boolean resultHasAtLeastOneBlockIndex = CelNavigableExpr.fromExpr(blockResult).allNodes().map(rec$ -> (CelExpr)((CelNavigableExpr)rec$).expr()).anyMatch(expr -> expr.identOrDefault().name().startsWith(BLOCK_INDEX_PREFIX));
        Verify.verify(resultHasAtLeastOneBlockIndex, "Expected at least one reference of index in cel.block result", new Object[0]);
    }

    private static void verifyBlockIndex(CelExpr celExpr, int maxIndexValue) {
        boolean areAllIndicesValid = CelNavigableExpr.fromExpr(celExpr).allNodes().map(rec$ -> (CelExpr)((CelNavigableExpr)rec$).expr()).filter(expr -> expr.identOrDefault().name().startsWith(BLOCK_INDEX_PREFIX)).map(CelExpr::ident).allMatch(blockIdent -> Integer.parseInt(blockIdent.name().substring(BLOCK_INDEX_PREFIX.length())) < maxIndexValue);
        Verify.verify(areAllIndicesValid, "Illegal block index found. The index value must be less than %s. Expr: %s", maxIndexValue, (Object)celExpr);
    }

    private static CelAbstractSyntaxTree tagAstExtension(CelAbstractSyntaxTree ast) {
        CelSource.Builder celSourceBuilder = ast.getSource().toBuilder().addAllExtensions(CEL_BLOCK_AST_EXTENSION_TAG);
        return CelAbstractSyntaxTree.newParsedAst(ast.getExpr(), celSourceBuilder.build());
    }

    private static ImmutableList<CelVarDecl> newBlockIndexVariableDeclarations(Cel cel, ImmutableList<CelVarDecl> mangledVarDecls, List<CelMutableExpr> subexpressions) {
        CelBuilder celBuilder = cel.toCelBuilder().setResultType(SimpleType.DYN);
        celBuilder.addVarDeclarations(mangledVarDecls);
        ImmutableList.Builder varDeclBuilder = ImmutableList.builder();
        for (int i = 0; i < subexpressions.size(); ++i) {
            CelMutableExpr subexpression = subexpressions.get(i);
            CelAbstractSyntaxTree subAst = CelAbstractSyntaxTree.newParsedAst(CelMutableExprConverter.fromMutableExpr(subexpression), CelSource.newBuilder().build());
            try {
                subAst = celBuilder.build().check(subAst).getAst();
            }
            catch (CelValidationException e) {
                throw new IllegalStateException("Failed to type-check subexpression", e);
            }
            CelVarDecl indexVar = CelVarDecl.newVarDeclaration(BLOCK_INDEX_PREFIX + i, subAst.getResultType());
            celBuilder.addVarDeclarations(indexVar);
            varDeclBuilder.add(indexVar);
        }
        return varDeclBuilder.build();
    }

    private CelAstOptimizer.OptimizationResult optimizeUsingCelBind(CelAbstractSyntaxTree ast) {
        CelNavigableMutableAst navAst;
        List<CelMutableExpr> cseCandidates;
        int iterCount;
        CelMutableAst astToModify = CelMutableAst.fromCelAst(ast);
        if (!this.cseOptions.populateMacroCalls()) {
            astToModify.source().clearMacroCalls();
        }
        astToModify = this.astMutator.mangleComprehensionIdentifierNames(astToModify, MANGLED_COMPREHENSION_ITER_VAR_PREFIX, MANGLED_COMPREHENSION_ACCU_VAR_PREFIX, true).mutableAst();
        CelMutableSource sourceToModify = astToModify.source();
        int bindIdentifierIndex = 0;
        for (iterCount = 0; iterCount < this.cseOptions.iterationLimit() && !(cseCandidates = this.getCseCandidates(navAst = CelNavigableMutableAst.fromAst(astToModify))).isEmpty(); ++iterCount) {
            String bindIdentifier = BIND_IDENTIFIER_PREFIX + bindIdentifierIndex;
            ++bindIdentifierIndex;
            for (CelMutableExpr cseCandidate : cseCandidates) {
                ++iterCount;
                astToModify = this.astMutator.replaceSubtree(astToModify, CelMutableExpr.ofIdent(bindIdentifier), cseCandidate.id());
            }
            CelNavigableMutableExpr lca = SubexpressionOptimizer.getLca(navAst, bindIdentifier);
            CelMutableExpr subexpressionToBind = cseCandidates.get(0);
            astToModify.source().addAllMacroCalls(sourceToModify.getMacroCalls());
            astToModify = this.astMutator.replaceSubtreeWithNewBindMacro(astToModify, bindIdentifier, subexpressionToBind, (CelMutableExpr)lca.expr(), lca.id(), this.cseOptions.populateMacroCalls());
            sourceToModify = astToModify.source();
        }
        if (iterCount >= this.cseOptions.iterationLimit()) {
            throw new IllegalStateException("Max iteration count reached.");
        }
        if (iterCount == 0) {
            return CelAstOptimizer.OptimizationResult.create(astToModify.toParsedAst());
        }
        astToModify = this.astMutator.renumberIdsConsecutively(astToModify);
        return CelAstOptimizer.OptimizationResult.create(astToModify.toParsedAst());
    }

    private static CelNavigableMutableExpr getLca(CelNavigableMutableAst navAst, String boundIdentifier) {
        CelNavigableMutableExpr root = navAst.getRoot();
        ImmutableList allNodesWithIdentifier = root.allNodes().filter(node -> node.getKind().equals((Object)CelExpr.ExprKind.Kind.IDENT) && ((CelMutableExpr)node.expr()).ident().name().equals(boundIdentifier)).collect(ImmutableList.toImmutableList());
        if (allNodesWithIdentifier.size() < 2) {
            throw new IllegalStateException("Expected at least 2 bound identifiers to be present.");
        }
        CelNavigableMutableExpr lca = root;
        long lcaAncestorCount = 0L;
        HashMap<Long, Long> ancestors = new HashMap<Long, Long>();
        for (CelNavigableMutableExpr navigableExpr : allNodesWithIdentifier) {
            Optional<CelNavigableMutableExpr> maybeParent = Optional.of(navigableExpr);
            while (maybeParent.isPresent()) {
                CelNavigableMutableExpr parent = maybeParent.get();
                if (!ancestors.containsKey(parent.id())) {
                    ancestors.put(parent.id(), 1L);
                    continue;
                }
                long ancestorCount = (Long)ancestors.get(parent.id());
                if (lcaAncestorCount < ancestorCount || lcaAncestorCount == ancestorCount && lca.depth() < parent.depth()) {
                    lca = parent;
                    lcaAncestorCount = ancestorCount;
                }
                ancestors.put(parent.id(), ancestorCount + 1L);
                maybeParent = parent.parent();
            }
        }
        return lca;
    }

    private List<CelMutableExpr> getCseCandidates(CelNavigableMutableAst navAst) {
        if (this.cseOptions.enableCelBlock() && this.cseOptions.subexpressionMaxRecursionDepth() > 0) {
            return this.getCseCandidatesWithRecursionDepth(navAst, this.cseOptions.subexpressionMaxRecursionDepth());
        }
        return this.getCseCandidatesWithCommonSubexpr(navAst);
    }

    private List<CelMutableExpr> getCseCandidatesWithRecursionDepth(CelNavigableMutableAst navAst, int recursionLimit) {
        Preconditions.checkArgument(recursionLimit > 0);
        Set<CelMutableExpr> ineligibleExprs = SubexpressionOptimizer.getIneligibleExprsFromComprehensionBranches(navAst);
        ImmutableList<CelNavigableMutableExpr> descendants = navAst.getRoot().descendants(TraversalOrder.PRE_ORDER).filter(node -> this.canEliminate((CelNavigableMutableExpr)node, ineligibleExprs)).filter(node -> node.height() <= recursionLimit).sorted(Comparator.comparingInt(rec$ -> ((CelNavigableMutableExpr)rec$).height()).reversed()).collect(ImmutableList.toImmutableList());
        if (descendants.isEmpty()) {
            return new ArrayList<CelMutableExpr>();
        }
        List<CelMutableExpr> cseCandidates = this.getCseCandidatesWithCommonSubexpr(descendants);
        if (!cseCandidates.isEmpty()) {
            return cseCandidates;
        }
        boolean astHasMoreExtractableSubexprs = navAst.getRoot().allNodes(TraversalOrder.POST_ORDER).filter(node -> node.height() > recursionLimit).anyMatch(node -> this.canEliminate((CelNavigableMutableExpr)node, ineligibleExprs));
        if (astHasMoreExtractableSubexprs) {
            cseCandidates.add((CelMutableExpr)((CelNavigableMutableExpr)descendants.get(0)).expr());
            return cseCandidates;
        }
        return new ArrayList<CelMutableExpr>();
    }

    private List<CelMutableExpr> getCseCandidatesWithCommonSubexpr(CelNavigableMutableAst navAst) {
        Set<CelMutableExpr> ineligibleExprs = SubexpressionOptimizer.getIneligibleExprsFromComprehensionBranches(navAst);
        ImmutableList<CelNavigableMutableExpr> allNodes = navAst.getRoot().allNodes(TraversalOrder.PRE_ORDER).filter(node -> this.canEliminate((CelNavigableMutableExpr)node, ineligibleExprs)).collect(ImmutableList.toImmutableList());
        return this.getCseCandidatesWithCommonSubexpr(allNodes);
    }

    private List<CelMutableExpr> getCseCandidatesWithCommonSubexpr(ImmutableList<CelNavigableMutableExpr> allNodes) {
        CelMutableExpr normalizedCseCandidate = null;
        HashSet<CelMutableExpr> semanticallyEqualNodes = new HashSet<CelMutableExpr>();
        for (CelNavigableMutableExpr node : allNodes) {
            CelMutableExpr normalizedExpr = this.normalizeForEquality((CelMutableExpr)node.expr());
            if (semanticallyEqualNodes.contains(normalizedExpr)) {
                normalizedCseCandidate = normalizedExpr;
                break;
            }
            semanticallyEqualNodes.add(normalizedExpr);
        }
        ArrayList<CelMutableExpr> cseCandidates = new ArrayList<CelMutableExpr>();
        if (normalizedCseCandidate == null) {
            return cseCandidates;
        }
        for (CelNavigableMutableExpr node : allNodes) {
            CelMutableExpr normalizedExpr = this.normalizeForEquality((CelMutableExpr)node.expr());
            if (!normalizedExpr.equals(normalizedCseCandidate)) continue;
            cseCandidates.add((CelMutableExpr)node.expr());
        }
        return cseCandidates;
    }

    private boolean canEliminate(CelNavigableMutableExpr navigableExpr, Set<CelMutableExpr> ineligibleExprs) {
        return !(navigableExpr.getKind().equals((Object)CelExpr.ExprKind.Kind.CONSTANT) || navigableExpr.getKind().equals((Object)CelExpr.ExprKind.Kind.IDENT) || navigableExpr.getKind().equals((Object)CelExpr.ExprKind.Kind.IDENT) && ((CelMutableExpr)navigableExpr.expr()).ident().name().startsWith(BIND_IDENTIFIER_PREFIX) || navigableExpr.getKind().equals((Object)CelExpr.ExprKind.Kind.LIST) && ((CelMutableExpr)navigableExpr.expr()).list().elements().isEmpty() || !this.containsEliminableFunctionOnly(navigableExpr) || ineligibleExprs.contains(navigableExpr.expr()) || !this.containsComprehensionIdentInSubexpr(navigableExpr));
    }

    private boolean containsComprehensionIdentInSubexpr(CelNavigableMutableExpr navExpr) {
        if (navExpr.getKind().equals((Object)CelExpr.ExprKind.Kind.COMPREHENSION)) {
            return true;
        }
        ImmutableList comprehensionIdents = navExpr.allNodes().filter(node -> node.getKind().equals((Object)CelExpr.ExprKind.Kind.IDENT) && (((CelMutableExpr)node.expr()).ident().name().startsWith(MANGLED_COMPREHENSION_ITER_VAR_PREFIX) || ((CelMutableExpr)node.expr()).ident().name().startsWith(MANGLED_COMPREHENSION_ACCU_VAR_PREFIX))).collect(ImmutableList.toImmutableList());
        if (comprehensionIdents.isEmpty()) {
            return true;
        }
        for (CelNavigableMutableExpr ident : comprehensionIdents) {
            CelNavigableMutableExpr parent = ident.parent().orElse(null);
            while (parent != null) {
                if (parent.getKind().equals((Object)CelExpr.ExprKind.Kind.COMPREHENSION)) {
                    return false;
                }
                parent = parent.parent().orElse(null);
            }
        }
        return true;
    }

    private static Set<CelMutableExpr> getIneligibleExprsFromComprehensionBranches(CelNavigableMutableAst navAst) {
        HashSet<CelMutableExpr> ineligibleExprs = new HashSet<CelMutableExpr>();
        navAst.getRoot().allNodes().filter(node -> node.getKind().equals((Object)CelExpr.ExprKind.Kind.COMPREHENSION)).forEach(node -> {
            Set nodes = Streams.concat(CelNavigableMutableExpr.fromExpr(((CelMutableExpr)node.expr()).comprehension().accuInit()).allNodes(), CelNavigableMutableExpr.fromExpr(((CelMutableExpr)node.expr()).comprehension().loopCondition()).allNodes()).map(rec$ -> (CelMutableExpr)((CelNavigableMutableExpr)rec$).expr()).collect(Collectors.toCollection(HashSet::new));
            ineligibleExprs.addAll(nodes);
        });
        return ineligibleExprs;
    }

    private boolean containsEliminableFunctionOnly(CelNavigableMutableExpr navigableExpr) {
        return navigableExpr.allNodes().allMatch(node -> {
            if (node.getKind().equals((Object)CelExpr.ExprKind.Kind.CALL)) {
                return this.cseEliminableFunctions.contains(((CelMutableExpr)node.expr()).call().function());
            }
            return true;
        });
    }

    private CelMutableExpr normalizeForEquality(CelMutableExpr mutableExpr) {
        CelMutableExpr copiedExpr = CelMutableExpr.newInstance(mutableExpr);
        return this.astMutator.clearExprIds(copiedExpr);
    }

    @VisibleForTesting
    static CelFunctionDecl newCelBlockFunctionDecl(CelType resultType) {
        return CelFunctionDecl.newFunctionDeclaration(CEL_BLOCK_FUNCTION, CelOverloadDecl.newGlobalOverload("cel_block_list", resultType, ListType.create(SimpleType.DYN), resultType));
    }

    private SubexpressionOptimizer(SubexpressionOptimizerOptions cseOptions) {
        this.cseOptions = cseOptions;
        this.astMutator = AstMutator.newInstance(cseOptions.iterationLimit());
        this.cseEliminableFunctions = ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(DefaultOptimizerConstants.CEL_CANONICAL_FUNCTIONS)).addAll(cseOptions.eliminableFunctions())).build();
    }

    @AutoValue
    public static abstract class SubexpressionOptimizerOptions {
        public abstract int iterationLimit();

        public abstract boolean populateMacroCalls();

        public abstract boolean enableCelBlock();

        public abstract int subexpressionMaxRecursionDepth();

        public abstract ImmutableSet<String> eliminableFunctions();

        abstract Builder toBuilder();

        public static Builder newBuilder() {
            return new AutoValue_SubexpressionOptimizer_SubexpressionOptimizerOptions.Builder().iterationLimit(500).populateMacroCalls(false).enableCelBlock(false).subexpressionMaxRecursionDepth(0);
        }

        SubexpressionOptimizerOptions() {
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder iterationLimit(int var1);

            public abstract Builder populateMacroCalls(boolean var1);

            public abstract Builder enableCelBlock(boolean var1);

            public abstract Builder subexpressionMaxRecursionDepth(int var1);

            abstract ImmutableSet.Builder<String> eliminableFunctionsBuilder();

            @CanIgnoreReturnValue
            public Builder addEliminableFunctions(Iterable<String> functions) {
                Preconditions.checkNotNull(functions);
                this.eliminableFunctionsBuilder().addAll((Iterable)functions);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder addEliminableFunctions(String ... functions) {
                return this.addEliminableFunctions(Arrays.asList(functions));
            }

            public abstract SubexpressionOptimizerOptions build();

            Builder() {
            }
        }
    }
}

