/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.parser;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.Immutable;
import dev.cel.common.CelOptions;
import dev.cel.common.CelSource;
import dev.cel.common.CelValidationResult;
import dev.cel.common.annotations.Internal;
import dev.cel.parser.CelMacro;
import dev.cel.parser.CelParser;
import dev.cel.parser.CelParserBuilder;
import dev.cel.parser.CelParserLibrary;
import dev.cel.parser.CelStandardMacro;
import dev.cel.parser.Parser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@Immutable
@Internal
public final class CelParserImpl
implements CelParser {
    private final ImmutableMap<String, CelMacro> macros;
    private final CelOptions options;
    private final Builder parserBuilder;

    public static CelParserBuilder newBuilder() {
        return new Builder().setOptions(CelOptions.DEFAULT);
    }

    @Override
    public CelValidationResult parse(String expression, String description) {
        return this.parse(CelSource.newBuilder(expression).setDescription(description).build());
    }

    @Override
    public CelValidationResult parse(CelSource source2) {
        return Parser.parse(this, source2, this.getOptions());
    }

    @Override
    public CelParserBuilder toParserBuilder() {
        return new Builder(this.parserBuilder);
    }

    Optional<CelMacro> findMacro(String key) {
        return Optional.ofNullable(this.macros.get(key));
    }

    public CelOptions getOptions() {
        return this.options;
    }

    private CelParserImpl(ImmutableMap<String, CelMacro> macros, CelOptions options, Builder parserBuilder) {
        this.macros = macros;
        this.options = options;
        this.parserBuilder = new Builder(parserBuilder);
    }

    public static final class Builder
    implements CelParserBuilder {
        private final List<CelStandardMacro> standardMacros;
        private final Map<String, CelMacro> macros;
        private final ImmutableSet.Builder<CelParserLibrary> celParserLibraries;
        private CelOptions options;

        @Override
        public CelParserBuilder setStandardMacros(CelStandardMacro ... macros) {
            Preconditions.checkNotNull(macros);
            return this.setStandardMacros(Arrays.asList(macros));
        }

        @Override
        public CelParserBuilder setStandardMacros(Iterable<CelStandardMacro> macros) {
            Preconditions.checkNotNull(macros);
            this.standardMacros.clear();
            Iterables.addAll(this.standardMacros, macros);
            return this;
        }

        @Override
        public CelParserBuilder addMacros(CelMacro ... macros) {
            Preconditions.checkNotNull(macros);
            return this.addMacros(Arrays.asList(macros));
        }

        @Override
        public CelParserBuilder addMacros(Iterable<CelMacro> macros) {
            Preconditions.checkNotNull(macros);
            for (CelMacro m4 : macros) {
                CelMacro macro = Preconditions.checkNotNull(m4);
                this.macros.put(macro.getKey(), macro);
            }
            return this;
        }

        @Override
        public CelParserBuilder addLibraries(CelParserLibrary ... libraries) {
            Preconditions.checkNotNull(libraries);
            return this.addLibraries(Arrays.asList(libraries));
        }

        @Override
        public CelParserBuilder addLibraries(Iterable<? extends CelParserLibrary> libraries) {
            Preconditions.checkNotNull(libraries);
            this.celParserLibraries.addAll(libraries);
            return this;
        }

        @Override
        public Builder setOptions(CelOptions options) {
            this.options = Preconditions.checkNotNull(options);
            return this;
        }

        @Override
        public CelOptions getOptions() {
            return this.options;
        }

        @VisibleForTesting
        List<CelStandardMacro> getStandardMacros() {
            return this.standardMacros;
        }

        @VisibleForTesting
        Map<String, CelMacro> getMacros() {
            return this.macros;
        }

        @VisibleForTesting
        ImmutableSet.Builder<CelParserLibrary> getParserLibraries() {
            return this.celParserLibraries;
        }

        @Override
        @CheckReturnValue
        public CelParserImpl build() {
            ImmutableCollection parserLibrarySet = this.celParserLibraries.build();
            parserLibrarySet.forEach(celLibrary -> celLibrary.setParserOptions(this));
            ImmutableMap.Builder<String, CelMacro> builder = ImmutableMap.builder();
            builder.putAll(this.macros);
            this.standardMacros.stream().map(CelStandardMacro::getDefinition).forEach(celMacro -> builder.put(celMacro.getKey(), (CelMacro)celMacro));
            return new CelParserImpl(builder.buildOrThrow(), Preconditions.checkNotNull(this.options), this);
        }

        private Builder() {
            this.macros = new HashMap<String, CelMacro>();
            this.celParserLibraries = ImmutableSet.builder();
            this.standardMacros = new ArrayList<CelStandardMacro>();
        }

        private Builder(Builder builder) {
            this.options = builder.options;
            this.macros = new HashMap<String, CelMacro>(builder.macros);
            this.standardMacros = new ArrayList<CelStandardMacro>(builder.standardMacros);
            this.celParserLibraries = ImmutableSet.builder();
            this.celParserLibraries.addAll((Iterable)builder.celParserLibraries.build());
        }
    }
}

