/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime;

import dev.cel.common.annotations.Internal;
import dev.cel.runtime.CelUnknownSet;
import dev.cel.runtime.DefaultInterpreter;
import dev.cel.runtime.InterpreterUtil;
import dev.cel.runtime.RuntimeUnknownResolver;
import java.util.ArrayList;
import java.util.Optional;

@Internal
class CallArgumentChecker {
    private final ArrayList<Long> exprIds = new ArrayList();
    private final RuntimeUnknownResolver resolver;
    private final boolean acceptPartial;
    private Optional<CelUnknownSet> unknowns = Optional.empty();

    private CallArgumentChecker(RuntimeUnknownResolver resolver, boolean acceptPartial) {
        this.resolver = resolver;
        this.acceptPartial = acceptPartial;
    }

    static CallArgumentChecker create(RuntimeUnknownResolver resolver) {
        return new CallArgumentChecker(resolver, false);
    }

    static CallArgumentChecker createAcceptingPartial(RuntimeUnknownResolver resolver) {
        return new CallArgumentChecker(resolver, true);
    }

    private static Optional<CelUnknownSet> mergeOptionalUnknowns(Optional<CelUnknownSet> lhs, Optional<CelUnknownSet> rhs) {
        return lhs.isPresent() ? (rhs.isPresent() ? Optional.of(lhs.get().merge(rhs.get())) : lhs) : rhs;
    }

    void checkArg(DefaultInterpreter.IntermediateResult arg) {
        Optional<CelUnknownSet> argUnknowns = this.maybeUnknownFromArg(arg);
        this.unknowns = CallArgumentChecker.mergeOptionalUnknowns(this.unknowns, argUnknowns);
        if (InterpreterUtil.isUnknown(arg.value())) {
            CelUnknownSet unknownSet = (CelUnknownSet)arg.value();
            this.exprIds.addAll(unknownSet.unknownExprIds());
        }
    }

    private Optional<CelUnknownSet> maybeUnknownFromArg(DefaultInterpreter.IntermediateResult arg) {
        CelUnknownSet celUnknownSet;
        if (arg.value() instanceof CelUnknownSet && !(celUnknownSet = (CelUnknownSet)arg.value()).attributes().isEmpty()) {
            return Optional.of((CelUnknownSet)arg.value());
        }
        if (!this.acceptPartial) {
            return this.resolver.maybePartialUnknown(arg.attribute());
        }
        return Optional.empty();
    }

    Optional<Object> maybeUnknowns() {
        if (this.unknowns.isPresent()) {
            return Optional.of(this.unknowns.get());
        }
        if (!this.exprIds.isEmpty()) {
            return Optional.of(CelUnknownSet.create(this.exprIds));
        }
        return Optional.empty();
    }
}

