/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.Immutable;
import com.google.protobuf.MessageLite;
import dev.cel.common.CelErrorCode;
import dev.cel.common.CelRuntimeException;
import dev.cel.common.annotations.Internal;
import dev.cel.common.values.BaseProtoCelValueConverter;
import dev.cel.common.values.BaseProtoMessageValueProvider;
import dev.cel.common.values.CelValue;
import dev.cel.common.values.CelValueProvider;
import dev.cel.common.values.CombinedCelValueProvider;
import dev.cel.common.values.SelectableValue;
import dev.cel.common.values.StringValue;
import dev.cel.runtime.CelUnknownSet;
import dev.cel.runtime.RuntimeTypeProvider;
import java.util.Map;
import java.util.NoSuchElementException;

@Immutable
@Internal
final class CelValueRuntimeTypeProvider
implements RuntimeTypeProvider {
    private final CelValueProvider valueProvider;
    private final BaseProtoCelValueConverter protoCelValueConverter;
    private static final BaseProtoCelValueConverter DEFAULT_CEL_VALUE_CONVERTER = new BaseProtoCelValueConverter(){

        @Override
        public CelValue fromProtoMessageToCelValue(MessageLite msg) {
            throw new UnsupportedOperationException("A value provider must be provided in the runtime to handle protobuf messages");
        }
    };

    static CelValueRuntimeTypeProvider newInstance(CelValueProvider valueProvider) {
        BaseProtoCelValueConverter converter = DEFAULT_CEL_VALUE_CONVERTER;
        if (valueProvider instanceof BaseProtoMessageValueProvider) {
            converter = ((BaseProtoMessageValueProvider)valueProvider).protoCelValueConverter();
        } else if (valueProvider instanceof CombinedCelValueProvider) {
            converter = ((CombinedCelValueProvider)valueProvider).valueProviders().stream().filter(p -> p instanceof BaseProtoMessageValueProvider).map(p -> ((BaseProtoMessageValueProvider)p).protoCelValueConverter()).findFirst().orElse(DEFAULT_CEL_VALUE_CONVERTER);
        }
        return new CelValueRuntimeTypeProvider(valueProvider, converter);
    }

    @Override
    public Object createMessage(String messageName, Map<String, Object> values2) {
        return this.unwrapCelValue(this.valueProvider.newValue(messageName, values2).orElseThrow(() -> new NoSuchElementException(String.format("cannot resolve '%s' as a message", messageName))));
    }

    @Override
    public Object selectField(Object message, String fieldName) {
        SelectableValue<CelValue> selectableValue = this.getSelectableValueOrThrow(message, fieldName);
        return this.unwrapCelValue(selectableValue.select(StringValue.create(fieldName)));
    }

    @Override
    public Object hasField(Object message, String fieldName) {
        SelectableValue<CelValue> selectableValue = this.getSelectableValueOrThrow(message, fieldName);
        return selectableValue.find(StringValue.create(fieldName)).isPresent();
    }

    private SelectableValue<CelValue> getSelectableValueOrThrow(Object obj, String fieldName) {
        CelValue convertedCelValue = obj instanceof MessageLite ? this.protoCelValueConverter.fromProtoMessageToCelValue((MessageLite)obj) : this.protoCelValueConverter.fromJavaObjectToCelValue(obj);
        if (!(convertedCelValue instanceof SelectableValue)) {
            CelValueRuntimeTypeProvider.throwInvalidFieldSelection(fieldName);
        }
        return (SelectableValue)((Object)convertedCelValue);
    }

    @Override
    public Object adapt(String messageName, Object message) {
        if (message instanceof CelUnknownSet) {
            return message;
        }
        if (message instanceof MessageLite.Builder) {
            message = ((MessageLite.Builder)message).build();
        }
        if (message instanceof MessageLite) {
            return this.unwrapCelValue(this.protoCelValueConverter.fromProtoMessageToCelValue((MessageLite)message));
        }
        return this.unwrapCelValue(this.protoCelValueConverter.fromJavaObjectToCelValue(message));
    }

    private Object unwrapCelValue(CelValue object) {
        return this.protoCelValueConverter.fromCelValueToJavaObject(object);
    }

    private static void throwInvalidFieldSelection(String fieldName) {
        throw new CelRuntimeException(new IllegalArgumentException(String.format("Error resolving field '%s'. Field selections must be performed on messages or maps.", fieldName)), CelErrorCode.ATTRIBUTE_NOT_FOUND);
    }

    private CelValueRuntimeTypeProvider(CelValueProvider valueProvider, BaseProtoCelValueConverter protoCelValueConverter) {
        this.valueProvider = Preconditions.checkNotNull(valueProvider);
        this.protoCelValueConverter = Preconditions.checkNotNull(protoCelValueConverter);
    }
}

