/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime;

import com.google.auto.value.AutoValue;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.Immutable;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import dev.cel.common.CelErrorCode;
import dev.cel.runtime.AutoValue_DefaultDispatcher_ResolvedOverloadImpl;
import dev.cel.runtime.CelEvaluationException;
import dev.cel.runtime.CelEvaluationExceptionBuilder;
import dev.cel.runtime.Dispatcher;
import dev.cel.runtime.FunctionOverload;
import dev.cel.runtime.Registrar;
import dev.cel.runtime.ResolvedOverload;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class DefaultDispatcher
implements Dispatcher,
Registrar {
    @GuardedBy(value="this")
    private final Map<String, ResolvedOverload> overloads = new HashMap<String, ResolvedOverload>();

    public static DefaultDispatcher create() {
        return new DefaultDispatcher();
    }

    @Override
    public synchronized <T> void add(String overloadId, Class<T> argType, Registrar.UnaryFunction<T> function) {
        this.overloads.put(overloadId, ResolvedOverloadImpl.of(overloadId, new Class[]{argType}, args -> function.apply(args[0])));
    }

    @Override
    public synchronized <T1, T2> void add(String overloadId, Class<T1> argType1, Class<T2> argType2, Registrar.BinaryFunction<T1, T2> function) {
        this.overloads.put(overloadId, ResolvedOverloadImpl.of(overloadId, new Class[]{argType1, argType2}, args -> function.apply(args[0], args[1])));
    }

    @Override
    public synchronized void add(String overloadId, List<Class<?>> argTypes, Registrar.Function function) {
        this.overloads.put(overloadId, ResolvedOverloadImpl.of(overloadId, argTypes.toArray(new Class[0]), (FunctionOverload)function));
    }

    @Override
    public synchronized Optional<ResolvedOverload> findOverload(String functionName, List<String> overloadIds, Object[] args) throws CelEvaluationException {
        return DefaultDispatcher.findOverload(functionName, overloadIds, this.overloads, args);
    }

    public static Optional<ResolvedOverload> findOverload(String functionName, List<String> overloadIds, Map<String, ? extends ResolvedOverload> overloads, Object[] args) throws CelEvaluationException {
        int matchingOverloadCount = 0;
        ResolvedOverload match = null;
        ArrayList<String> candidates = null;
        for (String overloadId : overloadIds) {
            ResolvedOverload overload = overloads.get(overloadId);
            if (overload == null || !overload.canHandle(args)) continue;
            if (++matchingOverloadCount > 1) {
                if (candidates == null) {
                    candidates = new ArrayList<String>();
                    candidates.add(match.getOverloadId());
                }
                candidates.add(overloadId);
            }
            match = overload;
        }
        if (matchingOverloadCount > 1) {
            throw CelEvaluationExceptionBuilder.newBuilder("Ambiguous overloads for function '%s'. Matching candidates: %s", functionName, Joiner.on(", ").join(candidates)).setErrorCode(CelErrorCode.AMBIGUOUS_OVERLOAD).build();
        }
        return Optional.ofNullable(match);
    }

    @Override
    public synchronized Dispatcher.ImmutableCopy immutableCopy() {
        return new ImmutableCopy(this.overloads);
    }

    private DefaultDispatcher() {
    }

    @Immutable
    @AutoValue
    static abstract class ResolvedOverloadImpl
    implements ResolvedOverload {
        ResolvedOverloadImpl() {
        }

        @Override
        public abstract String getOverloadId();

        public abstract ImmutableList<Class<?>> getParameterTypes();

        @Override
        public abstract FunctionOverload getDefinition();

        static ResolvedOverload of(String overloadId, Class<?>[] parameterTypes, FunctionOverload definition) {
            return ResolvedOverloadImpl.of(overloadId, ImmutableList.copyOf(parameterTypes), definition);
        }

        static ResolvedOverload of(String overloadId, ImmutableList<Class<?>> parameterTypes, FunctionOverload definition) {
            return new AutoValue_DefaultDispatcher_ResolvedOverloadImpl(overloadId, parameterTypes, definition);
        }
    }

    @Immutable
    private static final class ImmutableCopy
    implements Dispatcher.ImmutableCopy {
        private final ImmutableMap<String, ResolvedOverload> overloads;

        private ImmutableCopy(Map<String, ResolvedOverload> overloads) {
            this.overloads = ImmutableMap.copyOf(overloads);
        }

        @Override
        public Optional<ResolvedOverload> findOverload(String functionName, List<String> overloadIds, Object[] args) throws CelEvaluationException {
            return DefaultDispatcher.findOverload(functionName, overloadIds, this.overloads, args);
        }

        @Override
        public Dispatcher.ImmutableCopy immutableCopy() {
            return this;
        }
    }
}

