/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.Immutable;
import dev.cel.common.CelAbstractSyntaxTree;
import dev.cel.common.annotations.Internal;
import dev.cel.runtime.Metadata;

@Immutable
@Internal
public final class DefaultMetadata
implements Metadata {
    private final CelAbstractSyntaxTree ast;

    public DefaultMetadata(CelAbstractSyntaxTree ast) {
        this.ast = Preconditions.checkNotNull(ast);
    }

    @Override
    public String getLocation() {
        return this.ast.getSource().getDescription();
    }

    @Override
    public int getPosition(long exprId) {
        ImmutableMap<Long, Integer> positions = this.ast.getSource().getPositionsMap();
        return positions.getOrDefault(exprId, 0);
    }

    @Override
    public boolean hasPosition(long exprId) {
        return this.ast.getSource().getPositionsMap().containsKey(exprId);
    }
}

