/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime.standard;

import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Duration;
import com.google.protobuf.Timestamp;
import dev.cel.common.CelOptions;
import dev.cel.common.internal.ProtoTimeUtils;
import dev.cel.runtime.CelFunctionBinding;
import dev.cel.runtime.RuntimeEquality;
import dev.cel.runtime.standard.CelStandardFunction;
import dev.cel.runtime.standard.CelStandardOverload;
import dev.cel.runtime.standard.DateTimeHelpers;
import java.util.Arrays;

public final class GetMillisecondsFunction
extends CelStandardFunction {
    private static final GetMillisecondsFunction ALL_OVERLOADS = GetMillisecondsFunction.create(GetMillisecondsOverload.values());

    public static GetMillisecondsFunction create() {
        return ALL_OVERLOADS;
    }

    public static GetMillisecondsFunction create(GetMillisecondsOverload ... overloads) {
        return GetMillisecondsFunction.create(Arrays.asList(overloads));
    }

    public static GetMillisecondsFunction create(Iterable<GetMillisecondsOverload> overloads) {
        return new GetMillisecondsFunction(ImmutableSet.copyOf(overloads));
    }

    private GetMillisecondsFunction(ImmutableSet<CelStandardOverload> overloads) {
        super(overloads);
    }

    public static enum GetMillisecondsOverload implements CelStandardOverload
    {
        TIMESTAMP_TO_MILLISECONDS((celOptions, runtimeEquality) -> CelFunctionBinding.from("timestamp_to_milliseconds", Timestamp.class, ts -> (long)((double)DateTimeHelpers.newLocalDateTime(ts, "UTC").getNano() / 1000000.0))),
        TIMESTAMP_TO_MILLISECONDS_WITH_TZ((celOptions, runtimeEquality) -> CelFunctionBinding.from("timestamp_to_milliseconds_with_tz", Timestamp.class, String.class, (ts, tz) -> (long)((double)DateTimeHelpers.newLocalDateTime(ts, tz).getNano() / 1000000.0))),
        DURATION_TO_MILLISECONDS((celOptions, runtimeEquality) -> CelFunctionBinding.from("duration_to_milliseconds", Duration.class, arg -> ProtoTimeUtils.toMillis(arg) % java.time.Duration.ofSeconds(1L).toMillis()));

        private final CelStandardOverload.FunctionBindingCreator bindingCreator;

        @Override
        public CelFunctionBinding newFunctionBinding(CelOptions celOptions, RuntimeEquality runtimeEquality) {
            return this.bindingCreator.create(celOptions, runtimeEquality);
        }

        private GetMillisecondsOverload(CelStandardOverload.FunctionBindingCreator bindingCreator) {
            this.bindingCreator = bindingCreator;
        }
    }
}

