/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime.standard;

import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.UnsignedLong;
import com.google.protobuf.ByteString;
import com.google.protobuf.Duration;
import com.google.protobuf.Timestamp;
import dev.cel.common.CelOptions;
import dev.cel.common.internal.ComparisonFunctions;
import dev.cel.common.internal.ProtoTimeUtils;
import dev.cel.runtime.CelFunctionBinding;
import dev.cel.runtime.RuntimeEquality;
import dev.cel.runtime.RuntimeHelpers;
import dev.cel.runtime.standard.CelStandardFunction;
import dev.cel.runtime.standard.CelStandardOverload;
import java.util.Arrays;

public final class GreaterOperator
extends CelStandardFunction {
    private static final GreaterOperator ALL_OVERLOADS = GreaterOperator.create(GreaterOverload.values());

    public static GreaterOperator create() {
        return ALL_OVERLOADS;
    }

    public static GreaterOperator create(GreaterOverload ... overloads) {
        return GreaterOperator.create(Arrays.asList(overloads));
    }

    public static GreaterOperator create(Iterable<GreaterOverload> overloads) {
        return new GreaterOperator(ImmutableSet.copyOf(overloads));
    }

    private GreaterOperator(ImmutableSet<CelStandardOverload> overloads) {
        super(overloads);
    }

    public static enum GreaterOverload implements CelStandardOverload
    {
        GREATER_BOOL((celOptions, runtimeEquality) -> CelFunctionBinding.from("greater_bool", Boolean.class, Boolean.class, (x, y) -> x != false && y == false)),
        GREATER_BYTES((celOptions, runtimeEquality) -> CelFunctionBinding.from("greater_bytes", ByteString.class, ByteString.class, (x, y) -> ByteString.unsignedLexicographicalComparator().compare((ByteString)x, (ByteString)y) > 0)),
        GREATER_DOUBLE((celOptions, runtimeEquality) -> CelFunctionBinding.from("greater_double", Double.class, Double.class, (x, y) -> x > y)),
        GREATER_DURATION((celOptions, runtimeEquality) -> CelFunctionBinding.from("greater_duration", Duration.class, Duration.class, (x, y) -> ProtoTimeUtils.compare(x, y) > 0)),
        GREATER_INT64((celOptions, runtimeEquality) -> CelFunctionBinding.from("greater_int64", Long.class, Long.class, (x, y) -> x > y)),
        GREATER_STRING((celOptions, runtimeEquality) -> CelFunctionBinding.from("greater_string", String.class, String.class, (x, y) -> x.compareTo((String)y) > 0)),
        GREATER_TIMESTAMP((celOptions, runtimeEquality) -> CelFunctionBinding.from("greater_timestamp", Timestamp.class, Timestamp.class, (x, y) -> ProtoTimeUtils.compare(x, y) > 0)),
        GREATER_UINT64((celOptions, runtimeEquality) -> {
            if (celOptions.enableUnsignedLongs()) {
                return CelFunctionBinding.from("greater_uint64", UnsignedLong.class, UnsignedLong.class, (x, y) -> RuntimeHelpers.uint64CompareTo(x, y) > 0);
            }
            return CelFunctionBinding.from("greater_uint64", Long.class, Long.class, (x, y) -> RuntimeHelpers.uint64CompareTo(x, y, celOptions) > 0);
        }),
        GREATER_INT64_UINT64((celOptions, runtimeEquality) -> CelFunctionBinding.from("greater_int64_uint64", Long.class, UnsignedLong.class, (x, y) -> ComparisonFunctions.compareIntUint(x, y) == 1)),
        GREATER_UINT64_INT64((celOptions, runtimeEquality) -> CelFunctionBinding.from("greater_uint64_int64", UnsignedLong.class, Long.class, (x, y) -> ComparisonFunctions.compareUintInt(x, y) == 1)),
        GREATER_INT64_DOUBLE((celOptions, runtimeEquality) -> CelFunctionBinding.from("greater_int64_double", Long.class, Double.class, (x, y) -> ComparisonFunctions.compareIntDouble(x, y) == 1)),
        GREATER_DOUBLE_INT64((celOptions, runtimeEquality) -> CelFunctionBinding.from("greater_double_int64", Double.class, Long.class, (x, y) -> ComparisonFunctions.compareDoubleInt(x, y) == 1)),
        GREATER_UINT64_DOUBLE((celOptions, runtimeEquality) -> CelFunctionBinding.from("greater_uint64_double", UnsignedLong.class, Double.class, (x, y) -> ComparisonFunctions.compareUintDouble(x, y) == 1)),
        GREATER_DOUBLE_UINT64((celOptions, runtimeEquality) -> CelFunctionBinding.from("greater_double_uint64", Double.class, UnsignedLong.class, (x, y) -> ComparisonFunctions.compareDoubleUint(x, y) == 1));

        private final CelStandardOverload.FunctionBindingCreator bindingCreator;

        @Override
        public CelFunctionBinding newFunctionBinding(CelOptions celOptions, RuntimeEquality runtimeEquality) {
            return this.bindingCreator.create(celOptions, runtimeEquality);
        }

        private GreaterOverload(CelStandardOverload.FunctionBindingCreator bindingCreator) {
            this.bindingCreator = bindingCreator;
        }
    }
}

