/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime.standard;

import com.google.common.collect.ImmutableSet;
import dev.cel.common.CelOptions;
import dev.cel.runtime.CelFunctionBinding;
import dev.cel.runtime.RuntimeEquality;
import dev.cel.runtime.standard.CelStandardFunction;
import dev.cel.runtime.standard.CelStandardOverload;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public final class InOperator
extends CelStandardFunction {
    private static final InOperator ALL_OVERLOADS = InOperator.create(InOverload.values());

    public static InOperator create() {
        return ALL_OVERLOADS;
    }

    public static InOperator create(InOverload ... overloads) {
        return InOperator.create(Arrays.asList(overloads));
    }

    public static InOperator create(Iterable<InOverload> overloads) {
        return new InOperator(ImmutableSet.copyOf(overloads));
    }

    private InOperator(ImmutableSet<CelStandardOverload> overloads) {
        super(overloads);
    }

    public static enum InOverload implements CelStandardOverload
    {
        IN_LIST((celOptions, runtimeEquality) -> CelFunctionBinding.from("in_list", Object.class, List.class, (value, list) -> runtimeEquality.inList(list, value))),
        IN_MAP((celOptions, runtimeEquality) -> CelFunctionBinding.from("in_map", Object.class, Map.class, (key, map) -> runtimeEquality.inMap(map, key)));

        private final CelStandardOverload.FunctionBindingCreator bindingCreator;

        @Override
        public CelFunctionBinding newFunctionBinding(CelOptions celOptions, RuntimeEquality runtimeEquality) {
            return this.bindingCreator.create(celOptions, runtimeEquality);
        }

        private InOverload(CelStandardOverload.FunctionBindingCreator bindingCreator) {
            this.bindingCreator = bindingCreator;
        }
    }
}

