/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime.standard;

import com.google.common.collect.ImmutableSet;
import dev.cel.common.CelOptions;
import dev.cel.common.CelRuntimeException;
import dev.cel.runtime.CelFunctionBinding;
import dev.cel.runtime.RuntimeEquality;
import dev.cel.runtime.RuntimeHelpers;
import dev.cel.runtime.standard.ArithmeticHelpers;
import dev.cel.runtime.standard.CelStandardFunction;
import dev.cel.runtime.standard.CelStandardOverload;
import java.util.Arrays;

public final class NegateOperator
extends CelStandardFunction {
    private static final NegateOperator ALL_OVERLOADS = NegateOperator.create(NegateOverload.values());

    public static NegateOperator create() {
        return ALL_OVERLOADS;
    }

    public static NegateOperator create(NegateOverload ... overloads) {
        return NegateOperator.create(Arrays.asList(overloads));
    }

    public static NegateOperator create(Iterable<NegateOverload> overloads) {
        return new NegateOperator(ImmutableSet.copyOf(overloads));
    }

    private NegateOperator(ImmutableSet<CelStandardOverload> overloads) {
        super(overloads);
    }

    public static enum NegateOverload implements CelStandardOverload
    {
        NEGATE_INT64((celOptions, runtimeEquality) -> CelFunctionBinding.from("negate_int64", Long.class, x -> {
            try {
                return RuntimeHelpers.int64Negate(x, celOptions);
            }
            catch (ArithmeticException e) {
                throw new CelRuntimeException(e, ArithmeticHelpers.getArithmeticErrorCode(e));
            }
        })),
        NEGATE_DOUBLE((celOptions, runtimeEquality) -> CelFunctionBinding.from("negate_double", Double.class, x -> -x.doubleValue()));

        private final CelStandardOverload.FunctionBindingCreator bindingCreator;

        @Override
        public CelFunctionBinding newFunctionBinding(CelOptions celOptions, RuntimeEquality runtimeEquality) {
            return this.bindingCreator.create(celOptions, runtimeEquality);
        }

        private NegateOverload(CelStandardOverload.FunctionBindingCreator bindingCreator) {
            this.bindingCreator = bindingCreator;
        }
    }
}

