/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.validator;

import com.google.common.collect.ImmutableList;
import dev.cel.bundle.Cel;
import dev.cel.common.CelIssue;
import dev.cel.common.CelSource;
import dev.cel.common.CelSourceLocation;
import dev.cel.common.navigation.CelNavigableAst;
import java.util.Optional;

public interface CelAstValidator {
    public void validate(CelNavigableAst var1, Cel var2, IssuesFactory var3);

    public static final class IssuesFactory {
        private final ImmutableList.Builder<CelIssue> issuesBuilder;
        private final CelNavigableAst navigableAst;

        public IssuesFactory(CelNavigableAst navigableAst) {
            this.navigableAst = navigableAst;
            this.issuesBuilder = ImmutableList.builder();
        }

        public void addError(long exprId, String message) {
            this.add(exprId, message, CelIssue.Severity.ERROR);
        }

        public void addWarning(long exprId, String message) {
            this.add(exprId, message, CelIssue.Severity.WARNING);
        }

        public void addInfo(long exprId, String message) {
            this.add(exprId, message, CelIssue.Severity.INFORMATION);
        }

        private void add(long exprId, String message, CelIssue.Severity severity) {
            CelSource source2 = this.navigableAst.getAst().getSource();
            int position = Optional.ofNullable(source2.getPositionsMap().get(exprId)).orElse(-1);
            CelSourceLocation sourceLocation = CelSourceLocation.NONE;
            if (position >= 0) {
                sourceLocation = source2.getOffsetLocation(position).get();
            }
            this.issuesBuilder.add((Object)CelIssue.newBuilder().setExprId(exprId).setSeverity(severity).setMessage(message).setSourceLocation(sourceLocation).build());
        }

        public ImmutableList<CelIssue> getIssues() {
            return this.issuesBuilder.build();
        }
    }
}

