/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.validator;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import dev.cel.bundle.Cel;
import dev.cel.common.CelAbstractSyntaxTree;
import dev.cel.common.CelIssue;
import dev.cel.common.CelValidationResult;
import dev.cel.common.navigation.CelNavigableAst;
import dev.cel.validator.CelAstValidator;
import dev.cel.validator.CelValidator;
import dev.cel.validator.CelValidatorBuilder;
import java.util.Arrays;

final class CelValidatorImpl
implements CelValidator {
    private final Cel cel;
    private final ImmutableSet<CelAstValidator> astValidators;

    CelValidatorImpl(Cel cel, ImmutableSet<CelAstValidator> astValidators) {
        this.cel = cel;
        this.astValidators = astValidators;
    }

    @Override
    public CelValidationResult validate(CelAbstractSyntaxTree ast) {
        if (!ast.isChecked()) {
            throw new IllegalArgumentException("AST must be type-checked.");
        }
        ImmutableList.Builder issueBuilder = ImmutableList.builder();
        for (CelAstValidator validator : this.astValidators) {
            CelNavigableAst navigableAst = CelNavigableAst.fromAst(ast);
            CelAstValidator.IssuesFactory issuesFactory = new CelAstValidator.IssuesFactory(navigableAst);
            validator.validate(navigableAst, this.cel, issuesFactory);
            issueBuilder.addAll(issuesFactory.getIssues());
        }
        return new CelValidationResult(ast, (ImmutableList<CelIssue>)issueBuilder.build());
    }

    static Builder newBuilder(Cel cel) {
        return new Builder(cel);
    }

    static final class Builder
    implements CelValidatorBuilder {
        private final Cel cel;
        private final ImmutableSet.Builder<CelAstValidator> astValidators;

        private Builder(Cel cel) {
            this.cel = cel;
            this.astValidators = ImmutableSet.builder();
        }

        @Override
        public CelValidatorBuilder addAstValidators(CelAstValidator ... astValidators) {
            Preconditions.checkNotNull(astValidators);
            return this.addAstValidators(Arrays.asList(astValidators));
        }

        @Override
        public CelValidatorBuilder addAstValidators(Iterable<CelAstValidator> astValidators) {
            Preconditions.checkNotNull(astValidators);
            this.astValidators.addAll((Iterable)astValidators);
            return this;
        }

        @Override
        public CelValidator build() {
            return new CelValidatorImpl(this.cel, (ImmutableSet<CelAstValidator>)this.astValidators.build());
        }
    }
}

