/*
 * Decompiled with CFR 0.152.
 */
package build.buf.protovalidate;

import build.buf.protovalidate.Expression;
import build.buf.protovalidate.exceptions.CompilationException;
import dev.cel.common.CelAbstractSyntaxTree;
import dev.cel.common.CelValidationException;
import dev.cel.common.CelValidationResult;
import dev.cel.common.types.CelKind;
import dev.cel.compiler.CelCompiler;

final class AstExpression {
    final CelAbstractSyntaxTree ast;
    final Expression source;

    private AstExpression(CelAbstractSyntaxTree ast, Expression source2) {
        this.ast = ast;
        this.source = source2;
    }

    static AstExpression newAstExpression(CelCompiler cel, Expression expr) throws CompilationException {
        CelAbstractSyntaxTree ast;
        CelValidationResult compileResult = cel.compile(expr.expression);
        if (!compileResult.getAllIssues().isEmpty()) {
            throw new CompilationException("Failed to compile expression " + expr.id + ":\n" + compileResult.getIssueString());
        }
        try {
            ast = compileResult.getAst();
        }
        catch (CelValidationException e) {
            throw new CompilationException("Failed to compile expression " + expr.id + ":\n" + compileResult.getIssueString());
        }
        CelKind outKind = ast.getResultType().kind();
        if (outKind != CelKind.BOOL && outKind != CelKind.STRING) {
            throw new CompilationException(String.format("Expression outputs, wanted either bool or string: %s %s", new Object[]{expr.id, outKind}));
        }
        return new AstExpression(ast, expr);
    }
}

