/*
 * Decompiled with CFR 0.152.
 */
package build.buf.protovalidate;

import build.buf.protovalidate.Format;
import build.buf.protovalidate.Ipv4;
import build.buf.protovalidate.Ipv6;
import build.buf.protovalidate.ProtoAdapter;
import build.buf.protovalidate.Uri;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import dev.cel.common.types.CelType;
import dev.cel.common.types.SimpleType;
import dev.cel.runtime.CelEvaluationException;
import dev.cel.runtime.CelFunctionBinding;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;

final class CustomOverload {
    private static final Pattern EMAIL_REGEX = Pattern.compile("^[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)*$");

    CustomOverload() {
    }

    static List<CelFunctionBinding> create() {
        ArrayList<CelFunctionBinding> bindings = new ArrayList<CelFunctionBinding>();
        bindings.addAll(Arrays.asList(CustomOverload.celGetField(), CustomOverload.celFormat(), CustomOverload.celStartsWithBytes(), CustomOverload.celEndsWithBytes(), CustomOverload.celContainsBytes(), CustomOverload.celIsHostname(), CustomOverload.celIsEmail(), CustomOverload.celIsIpUnary(), CustomOverload.celIsIp(), CustomOverload.celIsIpPrefix(), CustomOverload.celIsIpPrefixInt(), CustomOverload.celIsIpPrefixBool(), CustomOverload.celIsIpPrefixIntBool(), CustomOverload.celIsUri(), CustomOverload.celIsUriRef(), CustomOverload.celIsNan(), CustomOverload.celIsInfUnary(), CustomOverload.celIsInfBinary(), CustomOverload.celIsHostAndPort()));
        bindings.addAll(CustomOverload.celUnique());
        return Collections.unmodifiableList(bindings);
    }

    private static CelFunctionBinding celGetField() {
        return CelFunctionBinding.from("get_field_any_string", Message.class, String.class, (message, fieldName) -> {
            Descriptors.FieldDescriptor field = message.getDescriptorForType().findFieldByName((String)fieldName);
            if (field == null) {
                throw new CelEvaluationException("no such field: " + fieldName);
            }
            return ProtoAdapter.toCel(field, message.getField(field));
        });
    }

    private static CelFunctionBinding celFormat() {
        return CelFunctionBinding.from("format_list_dyn", String.class, List.class, Format::format);
    }

    private static List<CelFunctionBinding> celUnique() {
        ArrayList<CelFunctionBinding> uniqueOverloads = new ArrayList<CelFunctionBinding>();
        for (CelType type : Arrays.asList(SimpleType.STRING, SimpleType.INT, SimpleType.UINT, SimpleType.DOUBLE, SimpleType.BYTES, SimpleType.BOOL)) {
            uniqueOverloads.add(CelFunctionBinding.from(String.format("unique_list_%s", type.name().toLowerCase(Locale.US)), List.class, CustomOverload::uniqueList));
        }
        return Collections.unmodifiableList(uniqueOverloads);
    }

    private static CelFunctionBinding celStartsWithBytes() {
        return CelFunctionBinding.from("starts_with_bytes", ByteString.class, ByteString.class, (receiver, param) -> {
            if (receiver.size() < param.size()) {
                return false;
            }
            for (int i = 0; i < param.size(); ++i) {
                if (param.byteAt(i) == receiver.byteAt(i)) continue;
                return false;
            }
            return true;
        });
    }

    private static CelFunctionBinding celEndsWithBytes() {
        return CelFunctionBinding.from("ends_with_bytes", ByteString.class, ByteString.class, (receiver, param) -> {
            if (receiver.size() < param.size()) {
                return false;
            }
            for (int i = 0; i < param.size(); ++i) {
                if (param.byteAt(param.size() - i - 1) == receiver.byteAt(receiver.size() - i - 1)) continue;
                return false;
            }
            return true;
        });
    }

    private static CelFunctionBinding celContainsBytes() {
        return CelFunctionBinding.from("contains_bytes", ByteString.class, ByteString.class, (receiver, param) -> CustomOverload.bytesContains(receiver.toByteArray(), param.toByteArray()));
    }

    static boolean bytesContains(byte[] arr, byte[] subArr) {
        if (subArr.length == 0) {
            return true;
        }
        if (subArr.length > arr.length) {
            return false;
        }
        for (int i = 0; i < arr.length - subArr.length + 1; ++i) {
            boolean found = true;
            for (int j = 0; j < subArr.length; ++j) {
                if (arr[i + j] == subArr[j]) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return true;
        }
        return false;
    }

    private static CelFunctionBinding celIsHostname() {
        return CelFunctionBinding.from("is_hostname", String.class, CustomOverload::isHostname);
    }

    private static CelFunctionBinding celIsEmail() {
        return CelFunctionBinding.from("is_email", String.class, CustomOverload::isEmail);
    }

    private static CelFunctionBinding celIsIpUnary() {
        return CelFunctionBinding.from("is_ip_unary", String.class, value -> CustomOverload.isIp(value, 0L));
    }

    private static CelFunctionBinding celIsIp() {
        return CelFunctionBinding.from("is_ip", String.class, Long.class, CustomOverload::isIp);
    }

    private static CelFunctionBinding celIsIpPrefix() {
        return CelFunctionBinding.from("is_ip_prefix", String.class, prefix -> CustomOverload.isIpPrefix(prefix, 0L, false));
    }

    private static CelFunctionBinding celIsIpPrefixInt() {
        return CelFunctionBinding.from("is_ip_prefix_int", String.class, Long.class, (prefix, version) -> CustomOverload.isIpPrefix(prefix, version, false));
    }

    private static CelFunctionBinding celIsIpPrefixBool() {
        return CelFunctionBinding.from("is_ip_prefix_bool", String.class, Boolean.class, (prefix, strict) -> CustomOverload.isIpPrefix(prefix, 0L, strict));
    }

    private static CelFunctionBinding celIsIpPrefixIntBool() {
        return CelFunctionBinding.from("is_ip_prefix_int_bool", Arrays.asList(String.class, Long.class, Boolean.class), args -> CustomOverload.isIpPrefix((String)args[0], (Long)args[1], (Boolean)args[2]));
    }

    private static CelFunctionBinding celIsUri() {
        return CelFunctionBinding.from("is_uri", String.class, CustomOverload::isUri);
    }

    private static CelFunctionBinding celIsUriRef() {
        return CelFunctionBinding.from("is_uri_ref", String.class, CustomOverload::isUriRef);
    }

    private static CelFunctionBinding celIsNan() {
        return CelFunctionBinding.from("is_nan", Double.class, value -> Double.isNaN(value));
    }

    private static CelFunctionBinding celIsInfUnary() {
        return CelFunctionBinding.from("is_inf_unary", Double.class, value -> value.isInfinite());
    }

    private static CelFunctionBinding celIsInfBinary() {
        return CelFunctionBinding.from("is_inf_binary", Double.class, Long.class, (value, sign) -> {
            if (sign == 0L) {
                return value.isInfinite();
            }
            double expectedValue = sign > 0L ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
            return value == expectedValue;
        });
    }

    private static CelFunctionBinding celIsHostAndPort() {
        return CelFunctionBinding.from("string_bool_is_host_and_port_bool", String.class, Boolean.class, CustomOverload::isHostAndPort);
    }

    private static boolean isHostAndPort(String str, boolean portRequired) {
        if (str.isEmpty()) {
            return false;
        }
        int splitIdx = str.lastIndexOf(58);
        if (str.charAt(0) == '[') {
            int end = str.lastIndexOf(93);
            int endPlus = end + 1;
            if (endPlus == str.length()) {
                return !portRequired && CustomOverload.isIp(str.substring(1, end), 6L);
            }
            if (endPlus == splitIdx) {
                return CustomOverload.isIp(str.substring(1, end), 6L) && CustomOverload.isPort(str.substring(splitIdx + 1));
            }
            return false;
        }
        if (splitIdx < 0) {
            return !portRequired && (CustomOverload.isHostname(str) || CustomOverload.isIp(str, 4L));
        }
        String host = str.substring(0, splitIdx);
        String port = str.substring(splitIdx + 1);
        return (CustomOverload.isHostname(host) || CustomOverload.isIp(host, 4L)) && CustomOverload.isPort(port);
    }

    private static boolean isPort(String str) {
        if (str.isEmpty()) {
            return false;
        }
        if (str.length() > 1 && str.charAt(0) == '0') {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if ('0' <= c && c <= '9') continue;
            return false;
        }
        try {
            int val = Integer.parseInt(str);
            return val <= 65535;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    private static boolean uniqueList(List<?> list) throws CelEvaluationException {
        long size = list.size();
        if (size == 0L) {
            return true;
        }
        HashSet exist = new HashSet((int)size);
        for (Object val : list) {
            if (exist.add(val)) continue;
            return false;
        }
        return true;
    }

    private static boolean isEmail(String addr) {
        return EMAIL_REGEX.matcher(addr).matches();
    }

    private static boolean isHostname(String val) {
        String[] parts;
        if (val.length() > 253) {
            return false;
        }
        String str = val.endsWith(".") ? val.substring(0, val.length() - 1) : val;
        boolean allDigits = false;
        for (String part : parts = str.split("\\.", -1)) {
            allDigits = true;
            int len = part.length();
            if (len == 0 || len > 63 || part.startsWith("-") || part.endsWith("-")) {
                return false;
            }
            for (int i = 0; i < part.length(); ++i) {
                char c = part.charAt(i);
                if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-')) {
                    return false;
                }
                allDigits = allDigits && c >= '0' && c <= '9';
            }
        }
        return !allDigits;
    }

    static boolean isIp(String addr, long ver) {
        if (ver == 6L) {
            return new Ipv6(addr).address();
        }
        if (ver == 4L) {
            return new Ipv4(addr).address();
        }
        if (ver == 0L) {
            return new Ipv4(addr).address() || new Ipv6(addr).address();
        }
        return false;
    }

    private static boolean isUri(String str) {
        return new Uri(str).uri();
    }

    private static boolean isUriRef(String str) {
        return new Uri(str).uriReference();
    }

    private static boolean isIpPrefix(String str, long version, boolean strict) {
        if (version == 6L) {
            Ipv6 ip = new Ipv6(str);
            return ip.addressPrefix() && (!strict || ip.isPrefixOnly());
        }
        if (version == 4L) {
            Ipv4 ip = new Ipv4(str);
            return ip.addressPrefix() && (!strict || ip.isPrefixOnly());
        }
        if (version == 0L) {
            return CustomOverload.isIpPrefix(str, 6L, strict) || CustomOverload.isIpPrefix(str, 4L, strict);
        }
        return false;
    }
}

